/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import net.jcip.annotations.Immutable;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.VariantKey;

@Immutable
public class Grammar_en
extends Grammar {
    private static final Grammar_en INSTANCE = new Grammar_en();

    public static Grammar_en getInstance() {
        return INSTANCE;
    }

    private Grammar_en() {
        this(Locale.ENGLISH);
    }

    protected Grammar_en(Locale l) {
        super(l);
    }

    @Override
    protected Collection<? extends VariantKey> createVariantKeys() {
        return Arrays.asList(SINGULAR, PLURAL, INDEFINITE_ARTICLE_SINGULAR, INDEFINITE_ARTICLE_PLURAL, DEFINITE_ARTICLE_SINGULAR, DEFINITE_ARTICLE_PLURAL, DEMONSTRATIVE_SINGULAR, DEMONSTRATIVE_PLURAL, INDEFINITE_NUMERAL, DEFINITE_NUMERAL, DEMONSTRATIVE_NUMERAL, INDEFINITE_ORDINAL, DEFINITE_ORDINAL);
    }

    public final Phrase createPhrase(String singular) {
        return this.createPhrase(singular, null);
    }

    public final Phrase createPhrase(String singular, String plural) {
        Phrase res = new Phrase(this, singular, null);
        if (plural != null) {
            res.putVariant(PLURAL, plural);
        }
        return res;
    }

    @Override
    public String getVariant(Phrase noun, VariantKey key) {
        String res = key.equals(SINGULAR) ? noun.getBase() : (key.equals(INDEFINITE_ARTICLE_SINGULAR) ? "a " + this.getSingular(noun) : (key.equals(DEFINITE_ARTICLE_SINGULAR) ? "the " + this.getSingular(noun) : (key.equals(DEMONSTRATIVE_SINGULAR) ? "this " + this.getSingular(noun) : (key.equals(PLURAL) ? this.getPlural(noun.getBase()) : (key.equals(INDEFINITE_ARTICLE_PLURAL) ? "some " + this.getPlural(noun) : (key.equals(DEFINITE_ARTICLE_PLURAL) ? "the " + this.getPlural(noun) : (key.equals(DEMONSTRATIVE_PLURAL) ? "these " + this.getPlural(noun) : (key.equals(INDEFINITE_NUMERAL) ? "{0, plural, =0 {No " + this.getPlural(noun) + "} one {# " + this.getSingular(noun) + "} other {# " + this.getPlural(noun) + "}}" : (key.equals(DEFINITE_NUMERAL) ? "{0, plural, =0 {No " + this.getPlural(noun) + "} one {" + this.getVariant(noun, DEFINITE_ARTICLE_SINGULAR) + "} other {the # " + this.getPlural(noun) + "}}" : (key.equals(DEMONSTRATIVE_NUMERAL) ? "{0, plural, =0 {No " + this.getPlural(noun) + "} one {" + this.getVariant(noun, DEMONSTRATIVE_SINGULAR) + "} other {these # " + this.getPlural(noun) + "}}" : (key.equals(INDEFINITE_ORDINAL) ? "{0, ordinal} " + this.getSingular(noun) : (key.equals(DEFINITE_ORDINAL) ? "the {0, ordinal} " + this.getSingular(noun) : null))))))))))));
        return res;
    }

    protected String getSingular(Phrase noun) {
        String res = noun.getVariant(SINGULAR);
        return res == null ? noun.getBase() : res;
    }

    protected String getPlural(Phrase noun) {
        String res = noun.getVariant(PLURAL);
        return res == null ? this.getPlural(noun.getBase()) : res;
    }

    protected String getPlural(String noun) {
        int length = noun.length();
        char lastChar = noun.charAt(length - 1);
        if (lastChar == 'y' && !this.isVowel(noun.charAt(length - 2))) {
            return String.valueOf(noun.substring(0, length - 1)) + "ies";
        }
        if (noun.endsWith("ss") || noun.endsWith("sh") || noun.endsWith("ch")) {
            return String.valueOf(noun) + "es";
        }
        return String.valueOf(noun) + 's';
    }

    protected boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y';
    }
}

