/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.listview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.request.SQLForeignRowItemView;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.view.listview.FFPoolFactory;
import org.openconcerto.sql.view.listview.ItemPool;
import org.openconcerto.sql.view.listview.ItemPoolFactory;
import org.openconcerto.sql.view.listview.ListItemSQLView;
import org.openconcerto.sql.view.listview.ListSQLView;

public abstract class FFItemPool
extends ItemPool {
    protected final List<SQLRowItemView> stills = new ArrayList<SQLRowItemView>();
    protected final List<SQLRowItemView> added = new ArrayList<SQLRowItemView>();
    protected final List<SQLRowItemView> removed = new ArrayList<SQLRowItemView>();
    protected final List<SQLField> availables = new ArrayList<SQLField>();

    public FFItemPool(ItemPoolFactory parent, ListSQLView panel) {
        super(parent, panel);
        this.reset();
    }

    @Override
    public final void reset() {
        this.stills.clear();
        this.added.clear();
        this.removed.clear();
        this.availables.clear();
        this.availables.addAll(((FFPoolFactory)this.getCreator()).getFields());
    }

    @Override
    public final void show(SQLRowAccessor r) {
        this.reset();
        ArrayList<ListItemSQLView> availableViews = new ArrayList<ListItemSQLView>(this.getPanel().getExistantViews());
        List<SQLRowAccessor> items = this.getCreator().getItems(r);
        for (SQLRowAccessor foreignRow : items) {
            ListItemSQLView v = availableViews.isEmpty() ? this.getPanel().addNewItem() : (ListItemSQLView)availableViews.remove(0);
            ((SQLForeignRowItemView)((Object)v.getRowItemView())).setValue(foreignRow);
        }
        this.stills.clear();
        this.stills.addAll(this.added);
        this.added.clear();
    }

    @Override
    public final boolean availableItem() {
        return this.availables.size() > 0;
    }

    @Override
    public abstract SQLRowItemView getNewItem() throws IllegalStateException;

    protected final String getLabel(SQLField field) {
        return field.getName();
    }

    @Override
    public final void removeItem(SQLRowItemView v) {
        this.stills.remove(v);
        this.added.remove(v);
        this.removed.add(v);
        this.itemRemoved(v);
    }

    protected void itemRemoved(SQLRowItemView v) {
    }

    @Override
    public List<SQLRowItemView> getItems() {
        ArrayList<SQLRowItemView> res = new ArrayList<SQLRowItemView>(this.stills);
        res.addAll(this.added);
        return res;
    }

    @Override
    public List<SQLRowItemView> getAddedItems() {
        return Collections.unmodifiableList(this.added);
    }

    @Override
    public List<SQLRowItemView> getRemovedItems() {
        return Collections.unmodifiableList(this.removed);
    }

    public String toString() {
        String res = "Pool on " + this.getCreator();
        res = String.valueOf(res) + "\nstills: " + this.stills;
        res = String.valueOf(res) + "\nadded: " + this.added;
        res = String.valueOf(res) + "\nremoved: " + this.removed;
        res = String.valueOf(res) + "\navailables: " + this.availables;
        return res;
    }
}

