/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import com.mysql.jdbc.Connection;
import java.beans.DefaultPersistenceDelegate;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.dbcp.DelegatingConnection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSyntaxPG;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Trigger;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.xml.XMLCodecUtils;

public class SQLSyntaxMySQL
extends SQLSyntax {
    private static final IdentityHashMap<String, String> DATE_SPECS = new IdentityHashMap();
    private static final Map<Class<?>, String> CAST_TYPES;
    private final boolean noBackslashEscapes;
    private static final Pattern PERCENT_PATTERN;

    static {
        DATE_SPECS.put(SQLSyntax.DateProp.YEAR, "%Y");
        DATE_SPECS.put(SQLSyntax.DateProp.MONTH_NAME, "%M");
        DATE_SPECS.put(SQLSyntax.DateProp.MONTH_NUMBER, "%m");
        DATE_SPECS.put(SQLSyntax.DateProp.DAY_IN_MONTH, "%d");
        DATE_SPECS.put(SQLSyntax.DateProp.DAY_NAME_IN_WEEK, "%W");
        DATE_SPECS.put(SQLSyntax.DateProp.HOUR, "%H");
        DATE_SPECS.put(SQLSyntax.DateProp.MINUTE, "%i");
        DATE_SPECS.put(SQLSyntax.DateProp.SECOND, "%S");
        DATE_SPECS.put(SQLSyntax.DateProp.MICROSECOND, "%f");
        CAST_TYPES = new HashMap();
        CAST_TYPES.put(Short.class, "signed integer");
        CAST_TYPES.put(Integer.class, "signed integer");
        CAST_TYPES.put(Long.class, "signed integer");
        CAST_TYPES.put(BigDecimal.class, "decimal");
        CAST_TYPES.put(Timestamp.class, "datetime");
        CAST_TYPES.put(Date.class, "date");
        CAST_TYPES.put(Time.class, "time");
        CAST_TYPES.put(Blob.class, "binary");
        CAST_TYPES.put(String.class, "char");
        XMLCodecUtils.register(SQLSyntaxMySQL.class, new DefaultPersistenceDelegate(new String[]{"noBackslashEscapes"}));
        PERCENT_PATTERN = Pattern.compile("(%+)");
    }

    static final SQLSyntax create(DBSystemRoot sysRoot) {
        boolean noBackslashEscapes;
        if (sysRoot == null) {
            noBackslashEscapes = false;
        } else {
            String modes = (String)sysRoot.getDataSource().executeScalar("SELECT @@global.sql_mode;");
            noBackslashEscapes = modes.contains("NO_BACKSLASH_ESCAPES");
        }
        return new SQLSyntaxMySQL(noBackslashEscapes);
    }

    public SQLSyntaxMySQL(boolean noBackslashEscapes) {
        super(SQLSystem.MYSQL, DATE_SPECS);
        this.noBackslashEscapes = noBackslashEscapes;
        this.typeNames.addAll(Boolean.class, "boolean", "bool", "bit");
        this.typeNames.addAll(Short.class, "smallint");
        this.typeNames.addAll(Integer.class, "integer", "int");
        this.typeNames.addAll(Long.class, "bigint");
        this.typeNames.addAll(BigDecimal.class, "decimal", "numeric");
        this.typeNames.addAll(Float.class, "float");
        this.typeNames.addAll(Double.class, "double precision", "real");
        this.typeNames.addAll(Timestamp.class, "datetime", "timestamp");
        this.typeNames.addAll(Date.class, "date");
        this.typeNames.addAll(Time.class, "time");
        this.typeNames.addAll(Blob.class, "blob", "tinyblob", "mediumblob", "longblob", "varbinary", "binary");
        this.typeNames.addAll(Clob.class, "text", "tinytext", "mediumtext", "longtext", "varchar", "char");
        this.typeNames.addAll(String.class, "varchar", "char");
    }

    public final boolean isNoBackslashEscapes() {
        return this.noBackslashEscapes;
    }

    @Override
    public final String quoteString(String s) {
        String res = super.quoteString(s);
        if (s == null) {
            return res;
        }
        return !this.noBackslashEscapes ? SQLSyntaxPG.BACKSLASH_PATTERN.matcher(res).replaceAll(SQLSyntaxPG.TWO_BACKSLASH_REPLACEMENT) : res;
    }

    @Override
    public int getMaximumIdentifierLength() {
        return 64;
    }

    @Override
    public String getIDType() {
        return " int";
    }

    @Override
    public boolean isAuto(SQLField f) {
        return "YES".equals(f.getMetadata("IS_AUTOINCREMENT"));
    }

    @Override
    public String getAuto() {
        return String.valueOf(this.getIDType()) + " AUTO_INCREMENT NOT NULL";
    }

    @Override
    protected String getAutoDateType(SQLField f) {
        return "timestamp";
    }

    @Override
    public int getMaximumVarCharLength() {
        return 16383;
    }

    @Override
    protected Tuple2<Boolean, String> getCast() {
        return null;
    }

    @Override
    public String cast(String expr, Class<?> javaType) {
        return this.cast(expr, CAST_TYPES.get(javaType));
    }

    @Override
    protected boolean supportsDefault(String typeName) {
        return !typeName.contains("text") && !typeName.contains("blob");
    }

    @Override
    public String transfDefaultJDBC2SQL(SQLField f) {
        Class<?> javaType = f.getType().getJavaType();
        String res = f.getDefaultValue();
        if (res == null) {
            res = Boolean.FALSE.equals(f.isNullable()) ? null : "NULL";
        } else if (javaType == String.class) {
            res = SQLBase.quoteStringStd(res);
        } else if (res.length() == 0) {
            res = null;
        } else if (java.util.Date.class.isAssignableFrom(javaType) && !res.trim().endsWith("()") && !res.toLowerCase().contains("timestamp")) {
            res = SQLBase.quoteStringStd(res);
        } else if (javaType == Boolean.class) {
            res = res.equals("0") ? "FALSE" : "TRUE";
        }
        return res;
    }

    @Override
    public String getCreateTableSuffix() {
        return " ENGINE = InnoDB ";
    }

    @Override
    public String disableFKChecks(DBRoot b) {
        return "SET FOREIGN_KEY_CHECKS=0;";
    }

    @Override
    public String enableFKChecks(DBRoot b) {
        return "SET FOREIGN_KEY_CHECKS=1;";
    }

    @Override
    public String getDropFK() {
        return "DROP FOREIGN KEY ";
    }

    @Override
    protected String getRuleSQL(Link.Rule r) {
        if (r == Link.Rule.SET_DEFAULT) {
            throw new UnsupportedOperationException((Object)((Object)r) + " isn't supported");
        }
        return super.getRuleSQL(r);
    }

    @Override
    public String getDropConstraint() {
        return "DROP INDEX ";
    }

    public Map<String, Object> normalizeIndexInfo(Map m) {
        Map<String, Object> res;
        Object nonUnique = (res = this.copyIndexInfoMap(m)).get("NON_UNIQUE");
        res.put("NON_UNIQUE", nonUnique instanceof Boolean ? nonUnique : Boolean.valueOf((String)nonUnique));
        res.put("COLUMN_NAME", res.get("COLUMN_NAME"));
        return res;
    }

    @Override
    public String getDropIndex(String name, SQLName tableName) {
        return "DROP INDEX " + SQLBase.quoteIdentifier(name) + " on " + tableName.quote() + ";";
    }

    @Override
    protected String getCreateIndex(String cols, SQLName tableName, SQLTable.SQLIndex i) {
        String method = i.getMethod() != null ? " USING " + i.getMethod() : "";
        return String.valueOf(super.getCreateIndex(cols, tableName, i)) + method;
    }

    @Override
    public boolean isUniqueException(SQLException exn) {
        SQLException e = SQLUtils.findWithSQLState(exn);
        return e.getErrorCode() == 1062 || e.getErrorCode() == 1305 && e.getMessage().contains("Unique constraint violation does not exist");
    }

    @Override
    public boolean isDeadLockException(SQLException exn) {
        return SQLUtils.findWithSQLState(exn).getErrorCode() == 1213;
    }

    @Override
    public boolean isTableNotFoundException(Exception exn) {
        return SQLUtils.findWithSQLState(exn).getErrorCode() == 1146;
    }

    @Override
    public String getSetLockTimeoutQuery(int millis) {
        return "set innodb_lock_wait_timeout = " + NumberUtils.divideRoundUp(millis, 1000);
    }

    @Override
    public String getShowLockTimeoutQuery() {
        return "select @@SESSION.innodb_lock_wait_timeout * 1000";
    }

    @Override
    public Map<ChangeTable.ClauseType, List<String>> getAlterField(SQLField f, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        String newDef;
        boolean newNullable = toAlter.contains((Object)SQLField.Properties.NULLABLE) ? nullable.booleanValue() : this.getNullable(f);
        String newType = toAlter.contains((Object)SQLField.Properties.TYPE) ? type : this.getType(f);
        String string = newDef = toAlter.contains((Object)SQLField.Properties.DEFAULT) ? defaultVal : this.getDefault(f, newType);
        if (!newNullable && newDef != null && newDef.trim().toUpperCase().equals("NULL")) {
            newDef = null;
        }
        return ListMap.singleton(ChangeTable.ClauseType.ALTER_COL, "MODIFY COLUMN " + f.getQuotedName() + " " + this.getFieldDecl(newType, newDef, newNullable));
    }

    @Override
    public String getDropTable(SQLName name, boolean ifExists, boolean restrict) {
        if (!restrict) {
            return null;
        }
        return super.getDropTable(name, ifExists, restrict);
    }

    @Override
    public String getDropRoot(String name) {
        return "DROP DATABASE IF EXISTS " + SQLBase.quoteIdentifier(name) + " ;";
    }

    @Override
    public String getCreateRoot(String name) {
        return "CREATE DATABASE " + SQLBase.quoteIdentifier(name) + " ;";
    }

    @Override
    protected void _storeData(SQLTable t, File file) throws IOException {
        this.checkServerLocalhost(t);
        ListMap<String, String> charsets = new ListMap<String, String>();
        for (SQLField f : t.getFields()) {
            Object charset = f.getInfoSchema().get("CHARACTER_SET_NAME");
            if (charset == null) continue;
            charsets.add(charset.toString(), f.getName());
        }
        if (charsets.size() > 1) {
            throw new IllegalArgumentException(t + " has more than on character set : " + charsets);
        }
        String charset = charsets.size() == 0 ? "UTF8" : (String)charsets.keySet().iterator().next();
        String cols = CollectionUtils.join(t.getOrderedFields(), ",", new ITransformer<SQLField, String>(){

            @Override
            public String transformChecked(SQLField input) {
                return SQLSyntaxMySQL.this.quoteString(input.getName());
            }
        });
        File tmp = File.createTempFile(String.valueOf(SQLSyntaxMySQL.class.getSimpleName()) + "storeData", ".txt");
        tmp.delete();
        SQLSelect sel = new SQLSelect(true).addSelectStar(t);
        t.getDBSystemRoot().getDataSource().execute("SELECT " + cols + " UNION " + sel.asString() + " INTO OUTFILE " + this.quoteString(tmp.getAbsolutePath()) + " " + this.getDATA_OPTIONS() + ";");
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmp), charset));
        Writer w = null;
        try {
            w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StringUtils.UTF8));
            SQLSyntaxMySQL.normalizeData(r, w, 1024000);
        }
        finally {
            r.close();
            if (w != null) {
                w.close();
            }
            tmp.delete();
        }
    }

    static void normalizeData(Reader r, Writer w, int bufferSize) throws IOException {
        int count;
        char[] buf = new char[bufferSize];
        int offset = 0;
        char[] wbuf = new char[buf.length];
        boolean wasBackslash = false;
        while ((count = r.read(buf, offset, buf.length - offset)) != -1) {
            int wbufLength = 0;
            int i = 0;
            while (i < offset + count) {
                char c = buf[i];
                if (wasBackslash && c == '\n') {
                    wbuf[wbufLength - 1] = c;
                } else {
                    wbuf[wbufLength++] = c;
                }
                wasBackslash = c == '\\';
                ++i;
            }
            if (wasBackslash) {
                wasBackslash = wbuf[--wbufLength - 1] == '\\';
                buf[0] = 92;
                offset = 1;
            } else {
                offset = 0;
            }
            w.write(wbuf, 0, wbufLength);
        }
    }

    private String getDATA_OPTIONS() {
        return "FIELDS TERMINATED BY ',' ENCLOSED BY '\"' ESCAPED BY " + this.quoteString("\\") + " LINES TERMINATED BY '\n' ";
    }

    @Override
    public void _loadData(final File f, final SQLTable t) {
        final SQLDataSource ds = t.getDBSystemRoot().getDataSource();
        try {
            SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                @Override
                public Object create() throws SQLException {
                    String charsetClause;
                    java.sql.Connection conn = ((DelegatingConnection)ds.getConnection()).getInnermostDelegate();
                    if (((Connection)conn).versionMeetsMinimum(5, 0, 38)) {
                        charsetClause = "CHARACTER SET utf8 ";
                    } else {
                        String dbCharset = ds.executeA1("show variables like 'character_set_database'")[1].toString().trim().toLowerCase();
                        if (dbCharset.equals("utf8")) {
                            charsetClause = "";
                        } else {
                            throw new IllegalStateException("the database charset is not utf8 and this version doesn't support specifying another one : " + dbCharset);
                        }
                    }
                    ds.execute(String.valueOf(t.getBase().quote("LOAD DATA LOCAL INFILE %s INTO TABLE %f ", f.getAbsolutePath(), t)) + charsetClause + SQLSyntaxMySQL.this.getDATA_OPTIONS() + " IGNORE 1 LINES;");
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't load " + f + " into " + t, e);
        }
    }

    @Override
    public String getNullIsDataComparison(String x, boolean eq, String y) {
        String nullSafe = String.valueOf(x) + " <=> " + y;
        if (eq) {
            return nullSafe;
        }
        return "NOT (" + nullSafe + ")";
    }

    @Override
    public String getDayOfWeek(String sqlTS) {
        return "DAYOFWEEK(" + sqlTS + ")";
    }

    @Override
    public String getFormatTimestamp(String sqlTS, boolean basic) {
        return this.getFormatTimestamp(sqlTS, SQLBase.quoteStringStd(basic ? "%Y%m%dT%H%i%s.%f" : "%Y-%m-%dT%H:%i:%s.%f"));
    }

    @Override
    public String getFormatTimestamp(String sqlTS, String nativeFormat) {
        return "DATE_FORMAT(" + sqlTS + ", " + nativeFormat + ")";
    }

    @Override
    public String quoteForTimestampFormat(String text) {
        return PERCENT_PATTERN.matcher(text).replaceAll("$1$1");
    }

    @Override
    public String getConstantTableStatement(List<List<String>> rows, int colCount) {
        if (colCount < 0) {
            colCount = rows.get(0).size();
        }
        return this.getConstantTable(rows, null, Collections.nCopies(colCount, null));
    }

    private final void getRow(StringBuilder sb, List<String> row, int requiredColCount, List<String> columnsAlias) {
        assert (columnsAlias == null || requiredColCount == columnsAlias.size());
        int actualColCount = row.size();
        if (actualColCount != requiredColCount) {
            throw new IllegalArgumentException("Wrong number of columns, should be " + requiredColCount + " but row is " + row);
        }
        int i = 0;
        while (i < actualColCount) {
            sb.append(row.get(i));
            if (columnsAlias != null && columnsAlias.get(i) != null) {
                sb.append(" as ");
                sb.append(SQLBase.quoteIdentifier(columnsAlias.get(i)));
            }
            if (i < actualColCount - 1) {
                sb.append(", ");
            }
            ++i;
        }
    }

    @Override
    public String getConstantTable(List<List<String>> rows, String alias, List<String> columnsAlias) {
        int rowCount = rows.size();
        if (rowCount < 1) {
            throw new IllegalArgumentException("Empty rows will cause a syntax error");
        }
        int colCount = columnsAlias.size();
        if (colCount < 1) {
            throw new IllegalArgumentException("Empty columns will cause a syntax error");
        }
        StringBuilder sb = new StringBuilder(rows.size() * 64);
        if (alias != null) {
            sb.append("( ");
        }
        sb.append("SELECT ");
        this.getRow(sb, rows.get(0), colCount, columnsAlias);
        int i = 1;
        while (i < rowCount) {
            sb.append("\nUNION ALL\nSELECT ");
            this.getRow(sb, rows.get(i), colCount, null);
            ++i;
        }
        if (alias != null) {
            sb.append(" ) as ");
            sb.append(SQLBase.quoteIdentifier(alias));
        }
        return sb.toString();
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        return "SELECT null as \"schema\", ROUTINE_NAME as \"name\", ROUTINE_DEFINITION as \"src\" FROM \"information_schema\".ROUTINES where ROUTINE_CATALOG is null and ROUTINE_SCHEMA = '" + b.getMDName() + "'";
    }

    @Override
    public String getTriggerQuery(SQLBase b, TablesMap tables) {
        return "SELECT \"TRIGGER_NAME\", null as \"TABLE_SCHEMA\", EVENT_OBJECT_TABLE as \"TABLE_NAME\", ACTION_STATEMENT as \"ACTION\", null as \"SQL\" from INFORMATION_SCHEMA.TRIGGERS " + this.getMySQLTablesMapJoin(b, tables, "EVENT_OBJECT_SCHEMA", "EVENT_OBJECT_TABLE");
    }

    private String getMySQLTablesMapJoin(SQLBase b, TablesMap tables, String schemaCol, String tableCol) {
        TablesMap translated;
        assert (tables.size() <= 1);
        if (tables.size() == 0) {
            translated = tables;
        } else {
            assert (tables.keySet().equals(Collections.singleton(null))) : tables;
            translated = new TablesMap(1);
            translated.put(b.getMDName(), (Set)tables.get(null));
        }
        return this.getTablesMapJoin(translated, schemaCol, tableCol);
    }

    @Override
    public String getColumnsQuery(SQLBase b, TablesMap tables) {
        return "SELECT null as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(0) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(1) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(2) + "\" , \"CHARACTER_SET_NAME\", \"COLLATION_NAME\" from INFORMATION_SCHEMA.\"COLUMNS\" " + this.getMySQLTablesMapJoin(b, tables, "TABLE_SCHEMA", "TABLE_NAME");
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, TablesMap tables) throws SQLException {
        String sel = "SELECT null as \"TABLE_SCHEMA\", c.\"TABLE_NAME\", c.\"CONSTRAINT_NAME\", tc.\"CONSTRAINT_TYPE\", \"COLUMN_NAME\", c.\"ORDINAL_POSITION\", NULL as \"DEFINITION\"\n FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE c\nJOIN (SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS T " + this.getMySQLTablesMapJoin(b, tables, "TABLE_SCHEMA", "TABLE_NAME") + ") tc on tc.\"TABLE_SCHEMA\" = c.\"TABLE_SCHEMA\" and tc.\"TABLE_NAME\"=c.\"TABLE_NAME\" and tc.\"CONSTRAINT_NAME\"=c.\"CONSTRAINT_NAME\"\n" + this.getMySQLTablesMapJoin(b, tables, "c.TABLE_SCHEMA", "c.TABLE_NAME") + "order by c.\"TABLE_SCHEMA\", c.\"TABLE_NAME\", c.\"CONSTRAINT_NAME\", c.\"ORDINAL_POSITION\"";
        List res = (List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        SQLSyntaxMySQL.mergeColumnNames(res);
        return res;
    }

    static void mergeColumnNames(List<Map<String, Object>> res) {
        Iterator<Map<String, Object>> listIter = res.iterator();
        ArrayList<String> l = null;
        while (listIter.hasNext()) {
            Map<String, Object> m = listIter.next();
            int pos = ((Number)m.remove("ORDINAL_POSITION")).intValue();
            if (pos == 1) {
                l = new ArrayList<String>();
                m.put("COLUMN_NAMES", l);
            } else {
                listIter.remove();
            }
            l.add((String)m.remove("COLUMN_NAME"));
        }
    }

    @Override
    public String getDropTrigger(Trigger t) {
        return "DROP TRIGGER " + new SQLName(t.getTable().getSchema().getName(), t.getName()).quote();
    }

    @Override
    public String getUpdate(final SQLTable t, List<String> tables, Map<String, String> setPart) {
        ArrayList<String> l = new ArrayList<String>(tables);
        l.add(0, t.getSQLName().quote());
        return String.valueOf(CollectionUtils.join(l, ", ")) + "\nSET " + CollectionUtils.join(setPart.entrySet(), ",\n", new ITransformer<Map.Entry<String, String>, String>(){

            @Override
            public String transformChecked(Map.Entry<String, String> input) {
                return String.valueOf(t.getField(input.getKey()).getSQLName(t).quote()) + " = " + input.getValue();
            }
        });
    }

    @Override
    public ChangeTable.DeferredClause getSetTableComment(final String comment) {
        return new ChangeTable.DeferredClause(){

            @Override
            public ChangeTable.ClauseType getType() {
                return ChangeTable.ClauseType.OTHER;
            }

            @Override
            protected String asString(ChangeTable<?> ct, SQLName tableName) {
                return "ALTER TABLE " + tableName.quote() + " COMMENT = " + ct.getSyntax().quoteString(comment) + ";";
            }
        };
    }

    @Override
    public String getSessionIDExpression() {
        return "CONNECTION_ID()";
    }

    @Override
    public String getSessionsQuery(DBSystemRoot sysRoot, boolean includeSelf) {
        String allRows = "SELECT \"ID\", \"Info\" as \"QUERY\", \"USER\" as \"USER_NAME\" FROM INFORMATION_SCHEMA.PROCESSLIST";
        if (includeSelf) {
            return "SELECT \"ID\", \"Info\" as \"QUERY\", \"USER\" as \"USER_NAME\" FROM INFORMATION_SCHEMA.PROCESSLIST";
        }
        return "SELECT \"ID\", \"Info\" as \"QUERY\", \"USER\" as \"USER_NAME\" FROM INFORMATION_SCHEMA.PROCESSLIST WHERE \"ID\" != " + this.getSessionIDExpression();
    }

    @Override
    protected String getAllUsersForGrant() {
        return "'%'@'%'";
    }

    @Override
    public String getAllowConnectionsQuery(String sysRootName, boolean allow) {
        return null;
    }
}

