/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.util.Arrays;
import java.util.List;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class ArticleCodeClientProvider
implements SpreadSheetCellValueProvider {
    private final String parentTableField;
    private final String field;

    public ArticleCodeClientProvider(String parentTableField, String field) {
        this.parentTableField = parentTableField;
        this.field = field;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        if (row.getObject("ID_ARTICLE") != null && !row.isForeignEmpty("ID_ARTICLE")) {
            String val;
            int idClient = row.getForeign(this.parentTableField).getForeignID("ID_CLIENT");
            SQLSelect sel = new SQLSelect();
            SQLTable tableCodeClient = row.getTable().getTable("ARTICLE_CODE_CLIENT");
            sel.addSelectStar(tableCodeClient);
            Where w = new Where((FieldRef)tableCodeClient.getField("ID_ARTICLE"), "=", row.getForeignID("ID_ARTICLE"));
            w = w.and(new Where((FieldRef)tableCodeClient.getField("ID_CLIENT"), "=", idClient));
            sel.setWhere(w);
            List<SQLRow> result = SQLRowListRSH.execute(sel);
            if (result.size() > 0 && (val = result.get(0).getString(this.field)).length() > 0) {
                return val;
            }
        }
        return row.getString(this.field);
    }

    public static void register() {
        List<String> fields = Arrays.asList("CODE", "NOM");
        for (String string : fields) {
            SpreadSheetCellValueProviderManager.put("sales.customer.product.quote." + string.toLowerCase(), new ArticleCodeClientProvider("ID_DEVIS", string));
            SpreadSheetCellValueProviderManager.put("sales.customer.product.shipment." + string.toLowerCase(), new ArticleCodeClientProvider("ID_BON_DE_LIVRAISON", string));
            SpreadSheetCellValueProviderManager.put("sales.customer.product.order." + string.toLowerCase(), new ArticleCodeClientProvider("ID_COMMANDE_CLIENT", string));
            SpreadSheetCellValueProviderManager.put("sales.customer.product.invoice." + string.toLowerCase(), new ArticleCodeClientProvider("ID_SAISIE_VENTE_FACTURE", string));
            SpreadSheetCellValueProviderManager.put("sales.customer.product.credit." + string.toLowerCase(), new ArticleCodeClientProvider("ID_AVOIR_CLIENT", string));
        }
    }
}

