/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.jdom2.Element;
import org.openconcerto.erp.core.edm.Attachment;
import org.openconcerto.erp.core.edm.AttachmentUtils;
import org.openconcerto.erp.generationDoc.OOXMLElement;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.FillMode;
import org.openconcerto.utils.ImageUtils;
import org.openconcerto.utils.StringUtils;

public class OOXMLTableImage {
    private float x = 0.0f;
    private float y = 0.0f;
    private final float width;
    private final float height;
    private int dpi = 300;
    private final int rowCount;
    private String bgColor = "#ffffff";
    public static final String EDM_URL = "edm://miniature.png";
    private final String url;
    private String fieldPathEDM;
    private String edmProvider;
    private String vAlign = "center";
    private String hAlign = "center";
    private OOXMLElement xmlField;
    private final SQLRowAccessor row;
    private byte[] img = null;
    private boolean cachedImg = false;

    public OOXMLTableImage(OOXMLElement xmlField, Element e, SQLRowAccessor row) {
        this.xmlField = xmlField;
        this.row = row;
        this.url = e.getAttributeValue("url");
        this.fieldPathEDM = e.getAttributeValue("fieldPathEDM");
        this.edmProvider = e.getAttributeValue("edmProvider");
        this.width = Float.valueOf(e.getAttributeValue("width")).floatValue();
        this.height = Float.valueOf(e.getAttributeValue("height")).floatValue();
        this.rowCount = Integer.valueOf(e.getAttributeValue("rowCount"));
        if (e.getAttributeValue("x") != null && !e.getAttributeValue("x").isEmpty()) {
            this.x = Integer.valueOf(e.getAttributeValue("x")).intValue();
        }
        if (e.getAttributeValue("y") != null && !e.getAttributeValue("y").isEmpty()) {
            this.y = Integer.valueOf(e.getAttributeValue("y")).intValue();
        }
    }

    public byte[] getImgBytes() throws IOException {
        if (this.cachedImg) {
            return this.img;
        }
        if (this.url.startsWith("edm://")) {
            Path p = new Path(this.row.getTable());
            SQLRow r = this.row.asRow();
            String sourceTableName = r.getTable().getName();
            int sourceID = r.getID();
            if (this.fieldPathEDM == null || this.fieldPathEDM.isEmpty() || this.fieldPathEDM.equalsIgnoreCase(".")) {
                SQLRow rowToEdm = r;
            } else if (this.fieldPathEDM != null && this.fieldPathEDM.equalsIgnoreCase("EDM_PROVIDER")) {
                SpreadSheetCellValueProvider provider = SpreadSheetCellValueProviderManager.get(this.edmProvider);
                SQLRow rowToEdm = (SQLRow)provider.getValue(new SpreadSheetCellValueContext(r));
                if (rowToEdm == null) {
                    return null;
                }
                sourceTableName = rowToEdm.getTable().getName();
                sourceID = rowToEdm.getID();
            } else {
                List<String> fields = StringUtils.fastSplit(this.fieldPathEDM, '.');
                if (fields.size() == 1) {
                    sourceTableName = r.getTable().getForeignTable(fields.get(0)).getName();
                    sourceID = r.getForeignID(fields.get(0));
                } else {
                    for (String f : fields) {
                        p = (Path)p.add(p.getLast().getField(f));
                    }
                    SQLRow rowToEdm = r.getDistantRow(p);
                    sourceTableName = rowToEdm.getTable().getName();
                    sourceID = rowToEdm.getID();
                }
            }
            SQLTable tableAttachment = this.row.getTable().getTable("ATTACHMENT");
            SQLRowValues rowVals = new SQLRowValues(tableAttachment);
            rowVals.putNulls(tableAttachment.getFieldsName());
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
            Where where = new Where((FieldRef)tableAttachment.getField("SOURCE_TABLE"), "=", (Object)sourceTableName);
            where = where.and(new Where((FieldRef)tableAttachment.getField("SOURCE_ID"), "=", sourceID));
            where = where.and(new Where((FieldRef)tableAttachment.getField("NAME"), "=", (Object)this.url.replaceAll("edm://", "")));
            List<SQLRowValues> rAttachments = fetcher.fetch(where);
            if (rAttachments.isEmpty()) {
                this.cachedImg = true;
                return null;
            }
            SQLRowValues rowValsAttachment = rAttachments.get(0);
            Attachment a = new Attachment(rowValsAttachment);
            AttachmentUtils u = new AttachmentUtils();
            File f = u.getFile(a);
            BufferedImage unscaledImage = ImageIO.read(f);
            float scale = (float)this.dpi / 25.4f;
            int maxWidth = (int)(this.width * scale);
            int maxHeight = (int)(this.height * scale);
            BufferedImage im = ImageUtils.createQualityResizedImage(unscaledImage, maxWidth, maxHeight, false, new FillMode.ZoomOut(Color.WHITE), true);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)im, "PNG", output);
            output.close();
            this.img = output.toByteArray();
            this.cachedImg = true;
            return this.img;
        }
        this.img = FileUtils.readBytes(new File(this.url));
        this.cachedImg = true;
        return this.img;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public int getDpi() {
        return this.dpi;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int getRowCount() {
        return this.rowCount;
    }
}

