/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.purchase.importer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class FacturXExporter {
    public static Namespace QDT_NS = Namespace.getNamespace("qdt", "urn:un:unece:uncefact:data:standard:QualifiedDataType:100");
    public static Namespace RAM_NS = Namespace.getNamespace("ram", "urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100");
    public static Namespace RSM_NS = Namespace.getNamespace("rsm", "urn:un:unece:uncefact:data:standard:CrossIndustryInvoice:100");
    public static Namespace UDT_NS = Namespace.getNamespace("udt", "urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100");
    public static Namespace XSI_NS = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    DecimalFormat formatAmount = new DecimalFormat("#0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private boolean useCommonClient = false;

    public static void main(String[] args) {
        FacturXExporter ex = new FacturXExporter();
        System.err.println("FacturXExporter.main() " + ex.checkEAN13("5987854125989"));
    }

    public String createXMLFrom(DBRoot dbRoot, int invoiceId, SQLRow societeRow) {
        SQLTable factureTable = dbRoot.getTable("SAISIE_VENTE_FACTURE");
        SQLRowValues rowValsToFetch = new SQLRowValues(factureTable);
        rowValsToFetch.putNulls("NUMERO", "DATE", "NOM", "T_TVA", "T_HT", "T_TTC", "NET_A_PAYER");
        rowValsToFetch.putRowValues("ID_MODE_REGLEMENT").putNulls("COMPTANT", "AJOURS", "LENJOUR", "DATE_FACTURE", "FIN_MOIS").putRowValues("ID_TYPE_REGLEMENT").putNulls("NOM");
        SQLRowValues putRowValuesClient = rowValsToFetch.putRowValues("ID_CLIENT");
        putRowValuesClient.putNulls("NOM", "RESPONSABLE", "SIRET", "NUMERO_TVA", "MAIL", "TEL");
        putRowValuesClient.putRowValues("ID_ADRESSE").putNulls("RUE", "VILLE", "CODE_POSTAL", "PAYS");
        putRowValuesClient.putRowValues("ID_ADRESSE_F").putNulls("RUE", "VILLE", "CODE_POSTAL", "PAYS");
        rowValsToFetch.putRowValues("ID_ADRESSE").putNulls("RUE", "VILLE", "CODE_POSTAL", "PAYS");
        SQLTable factureItemtable = dbRoot.getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        SQLRowValues rowValsItemsToFetch = new SQLRowValues(factureItemtable);
        rowValsItemsToFetch.putNulls("NIVEAU", "CODE", "NOM", "QTE", "QTE_UNITAIRE", "PV_HT", "T_PV_HT", "T_PV_TTC").putRowValues("ID_TAXE").put("TAUX", null);
        rowValsItemsToFetch.put("ID_SAISIE_VENTE_FACTURE", (Object)rowValsToFetch);
        List<SQLRowValues> factures = SQLRowValuesListFetcher.create(rowValsToFetch).fetch(new Where((FieldRef)factureTable.getKey(), "=", invoiceId));
        SQLRowValues facture = factures.get(0);
        Collection factureItems = facture.getReferentRows(factureItemtable.getField("ID_SAISIE_VENTE_FACTURE"));
        HashMap<Integer, Tax> taxes = new HashMap<Integer, Tax>();
        DecimalFormat fQty = new DecimalFormat("#0.########", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        String invoiceNumber = facture.getString("NUMERO");
        Date invoiceDate = facture.getDate("DATE").getTime();
        String regNote = String.valueOf(societeRow.getString("TYPE")) + " au capital de " + societeRow.getObject("CAPITAL") + " \u20ac";
        String legNote = societeRow.getString("RCS");
        int nbLines = factureItems.size();
        Document doc = new Document();
        Element root = new Element("CrossIndustryInvoice", RSM_NS);
        root.addNamespaceDeclaration(QDT_NS);
        root.addNamespaceDeclaration(RAM_NS);
        root.addNamespaceDeclaration(RSM_NS);
        root.addNamespaceDeclaration(UDT_NS);
        root.addNamespaceDeclaration(XSI_NS);
        doc.setRootElement(root);
        Element eDC = new Element("ExchangedDocumentContext", RSM_NS);
        Element bPSDCP = new Element("BusinessProcessSpecifiedDocumentContextParameter", RAM_NS);
        Element bPSDCP_ID = new Element("ID", RAM_NS);
        bPSDCP_ID.setText("A1");
        bPSDCP.addContent(bPSDCP_ID);
        eDC.addContent(bPSDCP);
        Element bGSDCP = new Element("GuidelineSpecifiedDocumentContextParameter", RAM_NS);
        Element bGSDCP_ID = new Element("ID", RAM_NS);
        bGSDCP_ID.setText("urn:cen.eu:en16931:2017");
        bGSDCP.addContent(bGSDCP_ID);
        eDC.addContent(bGSDCP);
        root.addContent(eDC);
        Element ed = new Element("ExchangedDocument", RSM_NS);
        Element edID = new Element("ID", RAM_NS);
        if (invoiceNumber.length() > 20) {
            invoiceNumber = invoiceNumber.substring(0, 20);
        }
        edID.setText(invoiceNumber);
        ed.addContent(edID);
        Element edTypeCode = new Element("TypeCode", RAM_NS);
        edTypeCode.setText("380");
        ed.addContent(edTypeCode);
        Element edIssueDateTime = new Element("IssueDateTime", RAM_NS);
        this.addDateTime(invoiceDate, edIssueDateTime);
        ed.addContent(edIssueDateTime);
        this.addIncludedNote(regNote, "REG", ed);
        this.addIncludedNote(legNote, "ABL", ed);
        Element eSupplyChainTradeTransaction = new Element("SupplyChainTradeTransaction", RSM_NS);
        int lineID = 1;
        for (SQLRowAccessor rowItem : factureItems) {
            BigDecimal totalTTCLigne;
            BigDecimal totalHTLigne;
            BigDecimal pTTC;
            BigDecimal pHT;
            String productCode = rowItem.getString("CODE");
            String productName = rowItem.getString("NOM").trim().length() == 0 ? "Ligne" : rowItem.getString("NOM");
            SQLRowAccessor taxeItem = rowItem.getForeign("ID_TAXE");
            BigDecimal taxValue = new BigDecimal(taxeItem.getFloat("TAUX")).setScale(2, RoundingMode.HALF_UP);
            if (rowItem.getInt("NIVEAU") != 1) {
                pHT = BigDecimal.ZERO;
                pTTC = BigDecimal.ZERO;
                totalHTLigne = BigDecimal.ZERO;
                totalTTCLigne = BigDecimal.ZERO;
            } else {
                pHT = rowItem.getBigDecimal("PV_HT");
                pTTC = pHT.multiply(taxValue.add(BigDecimal.ONE));
                totalHTLigne = rowItem.getBigDecimal("T_PV_HT");
                totalTTCLigne = rowItem.getBigDecimal("T_PV_TTC");
            }
            int idTaxe = taxeItem.getID();
            if (!taxes.containsKey(idTaxe)) {
                Tax t = new Tax(taxValue);
                taxes.put(idTaxe, t);
            }
            ((Tax)taxes.get(idTaxe)).add(totalTTCLigne.subtract(totalHTLigne), totalHTLigne);
            BigDecimal qte = new BigDecimal(rowItem.getInt("QTE")).multiply(rowItem.getBigDecimal("QTE_UNITAIRE"));
            Element eLineItem = new Element("IncludedSupplyChainTradeLineItem", RAM_NS);
            Element eAssociatedDocumentLineDocument = new Element("AssociatedDocumentLineDocument", RAM_NS);
            Element eLineID = new Element("LineID", RAM_NS);
            eLineID.setText(String.valueOf(lineID++));
            eAssociatedDocumentLineDocument.addContent(eLineID);
            eLineItem.addContent(eAssociatedDocumentLineDocument);
            Element eSpecifiedTradeProduct = new Element("SpecifiedTradeProduct", RAM_NS);
            if (!productCode.isEmpty()) {
                Element eGlobalID = new Element("GlobalID", RAM_NS);
                if (productCode.length() > 40) {
                    productCode = productCode.substring(0, 40);
                }
                if (this.checkEAN13(productCode)) {
                    eGlobalID.setAttribute("schemeID", "0088");
                } else {
                    eGlobalID.setAttribute("schemeID", "0197");
                }
                eGlobalID.setText(productCode);
                eSpecifiedTradeProduct.addContent(eGlobalID);
            }
            Element eName = new Element("Name", RAM_NS);
            eName.setText(productName);
            eSpecifiedTradeProduct.addContent(eName);
            eLineItem.addContent(eSpecifiedTradeProduct);
            Element eSpecifiedLineTradeAgreement = new Element("SpecifiedLineTradeAgreement", RAM_NS);
            Element eGrossPriceProductTradePrice = new Element("GrossPriceProductTradePrice", RAM_NS);
            Element eChargeAmount = new Element("ChargeAmount", RAM_NS);
            eChargeAmount.setText(this.formatAmount.format(pTTC));
            eGrossPriceProductTradePrice.addContent(eChargeAmount);
            Element eAppliedTradeAllowanceCharge = new Element("AppliedTradeAllowanceCharge", RAM_NS);
            Element eChargeIndicator = new Element("ChargeIndicator", RAM_NS);
            Element eIndicator = new Element("Indicator", UDT_NS);
            eIndicator.setText("false");
            eChargeIndicator.addContent(eIndicator);
            eAppliedTradeAllowanceCharge.addContent(eChargeIndicator);
            Element eActualAmount = new Element("ActualAmount", RAM_NS);
            eActualAmount.setText(this.formatAmount.format(pTTC.subtract(pHT)));
            eAppliedTradeAllowanceCharge.addContent(eActualAmount);
            eSpecifiedLineTradeAgreement.addContent(eGrossPriceProductTradePrice);
            Element eNetPriceProductTradePrice = new Element("NetPriceProductTradePrice", RAM_NS);
            Element eChargeAmountHT = new Element("ChargeAmount", RAM_NS);
            eChargeAmountHT.setText(this.formatAmount.format(pHT));
            eNetPriceProductTradePrice.addContent(eChargeAmountHT);
            eSpecifiedLineTradeAgreement.addContent(eNetPriceProductTradePrice);
            eLineItem.addContent(eSpecifiedLineTradeAgreement);
            Element eSpecifiedLineTradeDelivery = new Element("SpecifiedLineTradeDelivery", RAM_NS);
            Element eBilledQuantity = new Element("BilledQuantity", RAM_NS);
            eBilledQuantity.setAttribute("unitCode", "C62");
            eBilledQuantity.setText(fQty.format(qte));
            eSpecifiedLineTradeDelivery.addContent(eBilledQuantity);
            eLineItem.addContent(eSpecifiedLineTradeDelivery);
            Element eSpecifiedLineTradeSettlement = new Element("SpecifiedLineTradeSettlement", RAM_NS);
            Element eApplicableTradeTaxt = new Element("ApplicableTradeTax", RAM_NS);
            Element eTypeCode = new Element("TypeCode", RAM_NS);
            eTypeCode.setText("VAT");
            eApplicableTradeTaxt.addContent(eTypeCode);
            Element eCategoryCode = new Element("CategoryCode", RAM_NS);
            eCategoryCode.setText("S");
            eApplicableTradeTaxt.addContent(eCategoryCode);
            Element eRateApplicablePercent = new Element("RateApplicablePercent", RAM_NS);
            eRateApplicablePercent.setText(this.formatAmount.format(taxValue));
            eApplicableTradeTaxt.addContent(eRateApplicablePercent);
            eSpecifiedLineTradeSettlement.addContent(eApplicableTradeTaxt);
            Element eSpecifiedTradeSettlementLineMonetarySummation = new Element("SpecifiedTradeSettlementLineMonetarySummation", RAM_NS);
            Element eLineTotalAmount = new Element("LineTotalAmount", RAM_NS);
            eLineTotalAmount.setText(this.formatAmount.format(totalHTLigne));
            eSpecifiedTradeSettlementLineMonetarySummation.addContent(eLineTotalAmount);
            eSpecifiedLineTradeSettlement.addContent(eSpecifiedTradeSettlementLineMonetarySummation);
            eLineItem.addContent(eSpecifiedLineTradeSettlement);
            eSupplyChainTradeTransaction.addContent(eLineItem);
        }
        root.addContent(ed);
        this.addApplicableHeader(societeRow, facture, eSupplyChainTradeTransaction, taxes.values());
        root.addContent(eSupplyChainTradeTransaction);
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        return xmlOutput.outputString(doc);
    }

    public void addValue(Element parent, Element element, String value) {
        element.setText(value);
        parent.addContent(element);
    }

    private void addApplicableHeader(SQLRowAccessor rowSociete, SQLRowAccessor rowFacture, Element eSupplyChainTradeTransaction, Collection<Tax> taxes) {
        Element eApplicableHeaderTradeAgreement = new Element("ApplicableHeaderTradeAgreement", RAM_NS);
        this.addSupplierInfo(eApplicableHeaderTradeAgreement, rowSociete);
        this.addBuyerInfo(eApplicableHeaderTradeAgreement, rowFacture);
        String orderRef = "";
        String contractRef = "";
        Date effectiveDeliveryDate = rowFacture.getDate("DATE").getTime();
        String invoiceNumber = rowFacture.getString("NUMERO");
        String currencyCode = "EUR";
        SQLRowAccessor foreignMdr = rowFacture.getForeign("ID_MODE_REGLEMENT");
        int ajours = foreignMdr.getInt("AJOURS");
        int lenjour = foreignMdr.getInt("LENJOUR");
        String dueDescription = String.valueOf(ajours > 0 ? "A " + ajours : "") + (lenjour > 0 ? " le " + lenjour : "");
        Date dueDate = ModeDeReglementSQLElement.calculDate(foreignMdr, rowFacture.getDate("DATE").getTime());
        Element eBuyerOrderReferencedDocument = new Element("BuyerOrderReferencedDocument", RAM_NS);
        this.addValue(eBuyerOrderReferencedDocument, new Element("IssuerAssignedID", RAM_NS), orderRef);
        eApplicableHeaderTradeAgreement.addContent(eBuyerOrderReferencedDocument);
        Element eContractReferencedDocument = new Element("ContractReferencedDocument", RAM_NS);
        this.addValue(eContractReferencedDocument, new Element("IssuerAssignedID", RAM_NS), contractRef);
        eApplicableHeaderTradeAgreement.addContent(eContractReferencedDocument);
        eSupplyChainTradeTransaction.addContent(eApplicableHeaderTradeAgreement);
        Element eApplicableHeaderTradeDelivery = new Element("ApplicableHeaderTradeDelivery", RAM_NS);
        if (effectiveDeliveryDate != null) {
            Element eActualDeliverySupplyChainEvent = new Element("ActualDeliverySupplyChainEvent", RAM_NS);
            Element eOccurrenceDateTime = new Element("OccurrenceDateTime", RAM_NS);
            this.addDateTime(effectiveDeliveryDate, eOccurrenceDateTime);
            eActualDeliverySupplyChainEvent.addContent(eOccurrenceDateTime);
            eApplicableHeaderTradeDelivery.addContent(eActualDeliverySupplyChainEvent);
        }
        eSupplyChainTradeTransaction.addContent(eApplicableHeaderTradeDelivery);
        Element eApplicableHeaderTradeSettlement = new Element("ApplicableHeaderTradeSettlement", RAM_NS);
        this.addValue(eApplicableHeaderTradeSettlement, new Element("PaymentReference", RAM_NS), invoiceNumber);
        this.addValue(eApplicableHeaderTradeSettlement, new Element("InvoiceCurrencyCode", RAM_NS), currencyCode);
        Element aSpecifiedTradeSettlementPaymentMeans = new Element("SpecifiedTradeSettlementPaymentMeans", RAM_NS);
        this.addValue(aSpecifiedTradeSettlementPaymentMeans, new Element("TypeCode", RAM_NS), "57");
        eApplicableHeaderTradeSettlement.addContent(aSpecifiedTradeSettlementPaymentMeans);
        DecimalFormat format = new DecimalFormat("#0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        for (Tax t : taxes) {
            Element aApplicableTradeTax = new Element("ApplicableTradeTax", RAM_NS);
            this.addValue(aApplicableTradeTax, new Element("CalculatedAmount", RAM_NS), format.format(t.amount));
            this.addValue(aApplicableTradeTax, new Element("TypeCode", RAM_NS), "VAT");
            this.addValue(aApplicableTradeTax, new Element("BasisAmount", RAM_NS), format.format(t.basisAmount));
            this.addValue(aApplicableTradeTax, new Element("CategoryCode", RAM_NS), "S");
            this.addValue(aApplicableTradeTax, new Element("DueDateTypeCode", RAM_NS), "5");
            this.addValue(aApplicableTradeTax, new Element("RateApplicablePercent", RAM_NS), format.format(t.rate));
            eApplicableHeaderTradeSettlement.addContent(aApplicableTradeTax);
        }
        Element eSpecifiedTradePaymentTerms = new Element("SpecifiedTradePaymentTerms", RAM_NS);
        this.addValue(eSpecifiedTradePaymentTerms, new Element("Description", RAM_NS), dueDescription);
        Element eDueDateDateTime = new Element("DueDateDateTime", RAM_NS);
        this.addDateTime(dueDate, eDueDateDateTime);
        eSpecifiedTradePaymentTerms.addContent(eDueDateDateTime);
        eApplicableHeaderTradeSettlement.addContent(eSpecifiedTradePaymentTerms);
        Element eSpecifiedTradeSettlementHeaderMonetarySummation = new Element("SpecifiedTradeSettlementHeaderMonetarySummation", RAM_NS);
        Element eTotalHT = new Element("LineTotalAmount", RAM_NS);
        eTotalHT.setText(this.formatAmount.format(new BigDecimal(rowFacture.getLong("T_HT")).movePointLeft(2)));
        eSpecifiedTradeSettlementHeaderMonetarySummation.addContent(eTotalHT);
        Element eTotalBaseTVA = new Element("TaxBasisTotalAmount", RAM_NS);
        BigDecimal totalBaseTVA = BigDecimal.ZERO;
        for (Tax tax : taxes) {
            totalBaseTVA = totalBaseTVA.add(tax.basisAmount);
        }
        eTotalBaseTVA.setText(this.formatAmount.format(totalBaseTVA));
        eSpecifiedTradeSettlementHeaderMonetarySummation.addContent(eTotalBaseTVA);
        Element eTotalTVA = new Element("TaxTotalAmount", RAM_NS);
        eTotalTVA.setAttribute("currencyID", "EUR");
        eTotalTVA.setText(this.formatAmount.format(new BigDecimal(rowFacture.getLong("T_TVA")).movePointLeft(2)));
        eSpecifiedTradeSettlementHeaderMonetarySummation.addContent(eTotalTVA);
        Element eTotalTTC = new Element("GrandTotalAmount", RAM_NS);
        BigDecimal totalTTC = new BigDecimal(rowFacture.getLong("T_TTC")).movePointLeft(2);
        eTotalTTC.setText(this.formatAmount.format(totalTTC));
        eSpecifiedTradeSettlementHeaderMonetarySummation.addContent(eTotalTTC);
        Element eTotalPrepaid = new Element("TotalPrepaidAmount", RAM_NS);
        BigDecimal netApayer = new BigDecimal(rowFacture.getLong("NET_A_PAYER")).movePointLeft(2);
        eTotalPrepaid.setText(this.formatAmount.format(totalTTC.subtract(netApayer)));
        eSpecifiedTradeSettlementHeaderMonetarySummation.addContent(eTotalPrepaid);
        Element eTotalDue = new Element("DuePayableAmount", RAM_NS);
        eTotalDue.setText(this.formatAmount.format(netApayer));
        eSpecifiedTradeSettlementHeaderMonetarySummation.addContent(eTotalDue);
        eApplicableHeaderTradeSettlement.addContent(eSpecifiedTradeSettlementHeaderMonetarySummation);
        eSupplyChainTradeTransaction.addContent(eApplicableHeaderTradeSettlement);
    }

    private void addBuyerInfo(Element eApplicableHeaderTradeAgreement, SQLRowAccessor rowFacture) {
        SQLRowAccessor client;
        SQLRowAccessor clientGestion = client = rowFacture.getForeign("ID_CLIENT");
        if (this.useCommonClient) {
            client = client.getForeign("ID_CLIENT");
        }
        SQLRowAccessor adr = !rowFacture.isForeignEmpty("ID_ADRESSE") ? rowFacture.getForeign("ID_ADRESSE") : (!clientGestion.isForeignEmpty("ID_ADRESSE_F") ? clientGestion.getForeign("ID_ADRESSE_F") : client.getForeign("ID_ADRESSE"));
        String buyerName = client.getString("NOM");
        String buyerSIRET = client.getString("SIRET");
        String buyerVAT = client.getString("NUMERO_TVA");
        String buyerContactName = client.getString("RESPONSABLE");
        String buyerPhone = client.getString("TEL");
        String buyerEmail = client.getString("MAIL");
        String buyerAddrL1 = adr.getString("RUE");
        String buyerAddrL2 = "";
        String buyerAddrL3 = "";
        String buyerPostalCode = adr.getString("CODE_POSTAL");
        String buyerCity = adr.getString("VILLE");
        String buyerCountryCode = this.resolveCountryCode(adr.getString("PAYS"));
        Element eBuyerTradeParty = new Element("BuyerTradeParty", RAM_NS);
        this.addValue(eBuyerTradeParty, new Element("Name", RAM_NS), buyerName);
        Element eSpecifiedLegalOrganization = new Element("SpecifiedLegalOrganization", RAM_NS);
        Element eSpecifiedLegalOrganizationId = new Element("ID", RAM_NS);
        eSpecifiedLegalOrganizationId.setAttribute("schemeID", "0002");
        eSpecifiedLegalOrganizationId.setText(buyerSIRET);
        eSpecifiedLegalOrganization.addContent(eSpecifiedLegalOrganizationId);
        eBuyerTradeParty.addContent(eSpecifiedLegalOrganization);
        Element eDefinedTradeContact = new Element("DefinedTradeContact", RAM_NS);
        this.addValue(eDefinedTradeContact, new Element("PersonName", RAM_NS), buyerContactName);
        Element eTelephoneUniversalCommunication = new Element("TelephoneUniversalCommunication", RAM_NS);
        this.addValue(eTelephoneUniversalCommunication, new Element("CompleteNumber", RAM_NS), buyerPhone);
        eDefinedTradeContact.addContent(eTelephoneUniversalCommunication);
        Element eEmailURIUniversalCommunication = new Element("EmailURIUniversalCommunication", RAM_NS);
        Element eURIID = new Element("URIID", RAM_NS);
        eURIID.setAttribute("schemeID", "SMTP");
        eURIID.setText(buyerEmail);
        eEmailURIUniversalCommunication.addContent(eURIID);
        eDefinedTradeContact.addContent(eEmailURIUniversalCommunication);
        eBuyerTradeParty.addContent(eDefinedTradeContact);
        Element ePostalTradeAddress = new Element("PostalTradeAddress", RAM_NS);
        this.addValue(ePostalTradeAddress, new Element("PostcodeCode", RAM_NS), buyerPostalCode);
        this.addValue(ePostalTradeAddress, new Element("LineOne", RAM_NS), buyerAddrL1);
        if (buyerAddrL2 != null && !buyerAddrL2.trim().isEmpty()) {
            this.addValue(ePostalTradeAddress, new Element("LineTwo", RAM_NS), buyerAddrL2);
        }
        if (buyerAddrL3 != null && !buyerAddrL3.trim().isEmpty()) {
            this.addValue(ePostalTradeAddress, new Element("LineThree", RAM_NS), buyerAddrL3);
        }
        this.addValue(ePostalTradeAddress, new Element("CityName", RAM_NS), buyerCity);
        this.addValue(ePostalTradeAddress, new Element("CountryID", RAM_NS), buyerCountryCode);
        eBuyerTradeParty.addContent(ePostalTradeAddress);
        if (buyerVAT != null && buyerVAT.trim().length() > 0) {
            Element eSpecifiedTaxRegistration = new Element("SpecifiedTaxRegistration", RAM_NS);
            Element eSpecifiedTaxRegistrationId = new Element("ID", RAM_NS);
            eSpecifiedTaxRegistrationId.setAttribute("schemeID", "VA");
            eSpecifiedTaxRegistrationId.setText(buyerVAT);
            eSpecifiedTaxRegistration.addContent(eSpecifiedTaxRegistrationId);
            eBuyerTradeParty.addContent(eSpecifiedTaxRegistration);
        }
        eApplicableHeaderTradeAgreement.addContent(eBuyerTradeParty);
    }

    private void addSupplierInfo(Element eApplicableHeaderTradeAgreement, SQLRowAccessor rowSociete) {
        String supplierName = rowSociete.getString("NOM");
        String supplierSIRET = rowSociete.getString("NUM_SIRET");
        String supplierContactName = "";
        String supplierContactPhone = rowSociete.getString("NUM_TEL");
        String supplierContactEmail = rowSociete.getString("MAIL");
        SQLRowAccessor adr = rowSociete.getForeign("ID_ADRESSE_COMMON");
        String supplierAddrL1 = adr.getString("RUE");
        String supplierAddrL2 = "";
        String supplierAddrL3 = "";
        String supplierAddrPostalCode = adr.getString("CODE_POSTAL");
        String supplierAddrCityName = adr.getString("VILLE");
        String supplierAddrCountryID = this.resolveCountryCode(adr.getString("PAYS"));
        String supplierNumTVA = rowSociete.getString("NUM_NII");
        Element eSellerTradeParty = new Element("SellerTradeParty", RAM_NS);
        this.addValue(eSellerTradeParty, new Element("Name", RAM_NS), supplierName);
        Element eSpecifiedLegalOrganization = new Element("SpecifiedLegalOrganization", RAM_NS);
        Element eID = new Element("ID", RAM_NS);
        eID.setAttribute("schemeID", "0002");
        eID.setText(supplierSIRET);
        eSpecifiedLegalOrganization.addContent(eID);
        eSellerTradeParty.addContent(eSpecifiedLegalOrganization);
        Element eDefinedTradeContact = new Element("DefinedTradeContact", RAM_NS);
        Element ePersonName = new Element("PersonName", RAM_NS);
        ePersonName.setText(supplierContactName);
        eDefinedTradeContact.addContent(ePersonName);
        Element eTelephoneUniversalCommunication = new Element("TelephoneUniversalCommunication", RAM_NS);
        Element eCompleteNumber = new Element("CompleteNumber", RAM_NS);
        eCompleteNumber.setText(supplierContactPhone);
        eTelephoneUniversalCommunication.addContent(eCompleteNumber);
        eDefinedTradeContact.addContent(eTelephoneUniversalCommunication);
        Element eEmailURIUniversalCommunication = new Element("EmailURIUniversalCommunication", RAM_NS);
        Element eURIID = new Element("URIID", RAM_NS);
        eURIID.setAttribute("schemeID", "SMTP");
        eURIID.setText(supplierContactEmail);
        eEmailURIUniversalCommunication.addContent(eURIID);
        eDefinedTradeContact.addContent(eEmailURIUniversalCommunication);
        eSellerTradeParty.addContent(eDefinedTradeContact);
        Element ePostalTradeAddress = new Element("PostalTradeAddress", RAM_NS);
        this.addValue(ePostalTradeAddress, new Element("PostcodeCode", RAM_NS), supplierAddrPostalCode);
        this.addValue(ePostalTradeAddress, new Element("LineOne", RAM_NS), supplierAddrL1);
        if (supplierAddrL2 != null && !supplierAddrL2.trim().isEmpty()) {
            this.addValue(ePostalTradeAddress, new Element("LineTwo", RAM_NS), supplierAddrL2);
        }
        if (supplierAddrL3 != null && !supplierAddrL3.trim().isEmpty()) {
            this.addValue(ePostalTradeAddress, new Element("LineThree", RAM_NS), supplierAddrL3);
        }
        this.addValue(ePostalTradeAddress, new Element("CityName", RAM_NS), supplierAddrCityName);
        this.addValue(ePostalTradeAddress, new Element("CountryID", RAM_NS), supplierAddrCountryID);
        eSellerTradeParty.addContent(ePostalTradeAddress);
        Element eSpecifiedTaxRegistration = new Element("SpecifiedTaxRegistration", RAM_NS);
        Element eSpecifiedTaxRegistrationID = new Element("ID", RAM_NS);
        eSpecifiedTaxRegistrationID.setAttribute("schemeID", "VA");
        eSpecifiedTaxRegistrationID.setText(supplierNumTVA);
        eSpecifiedTaxRegistration.addContent(eSpecifiedTaxRegistrationID);
        eSellerTradeParty.addContent(eSpecifiedTaxRegistration);
        eApplicableHeaderTradeAgreement.addContent(eSellerTradeParty);
    }

    private void addIncludedNote(String content, String code, Element ed) {
        Element e = new Element("IncludedNote", RAM_NS);
        Element eContent = new Element("Content", RAM_NS);
        eContent.setText(content);
        e.addContent(eContent);
        Element eCode = new Element("SubjectCode", RAM_NS);
        eCode.setText(code);
        e.addContent(eCode);
        ed.addContent(e);
    }

    private void addDateTime(Date date, Element eTime) {
        Element e = new Element("DateTimeString", UDT_NS);
        e.setAttribute("format", "102");
        SimpleDateFormat s = new SimpleDateFormat("yyyyMMdd");
        e.setText(s.format(date));
        eTime.addContent(e);
    }

    boolean checkEAN13(String code) {
        if (code == null || code.length() != 13) {
            return false;
        }
        int checkdigit = 0;
        int i = 1;
        while (i < 12) {
            checkdigit += Integer.valueOf(code.substring(i, i + 1)).intValue();
            i += 2;
        }
        checkdigit *= 3;
        i = 0;
        while (i < 11) {
            checkdigit += Integer.valueOf(code.substring(i, i + 1)).intValue();
            i += 2;
        }
        if ((checkdigit %= 10) != 0) {
            checkdigit = 10 - checkdigit;
        }
        return Integer.valueOf(code.substring(12, 13)) == checkdigit;
    }

    private String resolveCountryCode(String pays) {
        if (pays == null || pays.trim().length() == 0) {
            return "FR";
        }
        if (pays.toLowerCase().equals("france")) {
            return "FR";
        }
        if (pays.toLowerCase().equals("fr")) {
            return "FR";
        }
        if (pays.toLowerCase().equals("polska")) {
            return "PL";
        }
        if (pays.toLowerCase().equals("pologne")) {
            return "PL";
        }
        if (pays.toLowerCase().equals("pl")) {
            return "PL";
        }
        if (pays.toLowerCase().equals("allemagne")) {
            return "DE";
        }
        if (pays.toLowerCase().equals("de")) {
            return "DE";
        }
        if (pays.toLowerCase().equals("deutschland")) {
            return "DE";
        }
        if (pays.toLowerCase().equals("italie")) {
            return "IT";
        }
        if (pays.toLowerCase().equals("italy")) {
            return "IT";
        }
        if (pays.toLowerCase().equals("italia")) {
            return "IT";
        }
        if (pays.toLowerCase().equals("it")) {
            return "IT";
        }
        if (pays.toLowerCase().equals("espagne")) {
            return "SP";
        }
        if (pays.toLowerCase().equals("spain")) {
            return "SP";
        }
        if (pays.toLowerCase().equals("sp")) {
            return "SP";
        }
        if (pays.toLowerCase().equals("luxembourg")) {
            return "LU";
        }
        if (pays.toLowerCase().equals("lu")) {
            return "LU";
        }
        if (pays.toLowerCase().equals("portugal")) {
            return "PT";
        }
        if (pays.toLowerCase().equals("pt")) {
            return "PT";
        }
        if (pays.toLowerCase().equals("belgique")) {
            return "BE";
        }
        if (pays.toLowerCase().equals("belgium")) {
            return "BE";
        }
        if (pays.toLowerCase().equals("be")) {
            return "BE";
        }
        return "";
    }

    private class Tax {
        final BigDecimal rate;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal basisAmount = BigDecimal.ZERO;

        public Tax(BigDecimal rate) {
            this.rate = rate;
        }

        public void add(BigDecimal taxAmount, BigDecimal basisAmount) {
            this.amount = this.amount.add(taxAmount);
            this.basisAmount = this.basisAmount.add(basisAmount);
        }
    }
}

