/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.openconcerto.erp.core.sales.quote.component.ContactMailMenu;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.doc.Documented;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ITextContactMailField
extends JPanel
implements ValueWrapper<String>,
Documented,
TextComponent,
RowItemViewComponent {
    private JTextField textField;
    private SQLField field;
    private final ValueChangeSupport<String> supp = new ValueChangeSupport<String>(this);
    protected boolean gained;
    protected boolean mousePressed;
    protected String initialText;
    private ContactMailMenu menu;

    public ITextContactMailField() {
        this.textField = new JTextField();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        if (System.getProperties().getProperty("os.name").toLowerCase().contains("linux")) {
            this.textField.setOpaque(false);
        }
        this.setOpaque(false);
        this.add((Component)this.textField, c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridx;
        c.weightx = 0.0;
        this.menu = new ContactMailMenu(this.textField);
        JMenuBar b = new JMenuBar();
        b.setOpaque(false);
        b.setBorderPainted(false);
        b.add(this.menu);
        b.setMinimumSize(b.getPreferredSize());
        this.add((Component)b, c);
        this.textField.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                ITextContactMailField.this.supp.fireValidChange();
            }
        });
        this.setPreferredSize(new Dimension(this.getPreferredSize()));
    }

    @Override
    public void init(SQLRowItemView v) {
        this.field = v.getField();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ITextContactMailField.this.gained = true;
                ITextContactMailField.this.initialText = ITextContactMailField.this.textField.getText();
                if (!ITextContactMailField.this.mousePressed) {
                    ITextContactMailField.this.textField.selectAll();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ITextContactMailField.this.mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ITextContactMailField.this.gained && ITextContactMailField.this.textField.getSelectedText() == null) {
                    ITextContactMailField.this.textField.selectAll();
                }
                ITextContactMailField.this.gained = false;
                ITextContactMailField.this.mousePressed = false;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    ITextContactMailField.this.setValue(ITextContactMailField.this.initialText);
                    ITextContactMailField.this.textField.selectAll();
                }
            }
        });
    }

    public SQLField getField() {
        return this.field;
    }

    @Override
    public void setValue(String val) {
        if (!this.textField.getText().equals(val)) {
            this.textField.setText(val);
        }
    }

    @Override
    public void resetValue() {
        this.setValue("");
    }

    public SQLTable getTable() {
        if (this.field == null) {
            return null;
        }
        return this.field.getTable();
    }

    @Override
    public String toString() {
        return "ITextContactMailField on " + this.field;
    }

    public void setEditable(boolean b) {
        this.textField.setEditable(b);
    }

    @Override
    public String getValue() throws IllegalStateException {
        return this.textField.getText();
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public ValidState getValidState() {
        List<String> mails = StringUtils.fastSplit(this.textField.getText(), ',');
        for (String string : mails) {
            if (string.contains("@") && string.contains(".")) continue;
            return ValidState.create(false, "L'adresse mail " + string + " n'est pas valide!");
        }
        return ValidState.getTrueInstance();
    }

    public void setText(String s) {
        this.textField.setText(s);
    }

    public String getText() {
        return this.textField.getText();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setSelectedRow(SQLRow selectedRow) {
        this.menu.setSelectedRow(selectedRow);
    }

    @Override
    public String getDocId() {
        return "TCM_" + this.field.getFullName();
    }

    @Override
    public String getGenericDoc() {
        return "";
    }

    @Override
    public boolean onScreen() {
        return true;
    }

    @Override
    public boolean isDocTransversable() {
        return false;
    }

    @Override
    public JTextComponent getTextComp() {
        return this.textField;
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }
}

