/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AddressChoiceUI;
import org.openconcerto.erp.core.customerrelationship.customer.ui.AdresseType;
import org.openconcerto.erp.core.customerrelationship.customer.ui.CategorieComptableChoiceUI;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.payment.component.ModeDeReglementSQLComponent;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.invoice.ui.SaisieVenteFactureItemTable;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.erp.preferences.GestionClientPreferencePanel;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.sqlobject.itemview.SimpleRowItemView;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.valuewrapper.ValidatedValueWrapper;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SaisieVenteFactureSQLComponent
extends TransfertBaseSQLComponent {
    private AbstractArticleItemTable tableFacture;
    private JLabel labelAffaire = new JLabel("Affaire");
    private final JDate dateSaisie = new JDate(true);
    private DeviseField textPortHT;
    private DeviseField textAcompte;
    private DeviseField textAvoirTTC;
    private DeviseField textRemiseHT;
    private DeviseField fieldTTC;
    private DeviseField textNetAPayer;
    private DeviseField totalTimbre;
    private DeviseField netPayer;
    private JTextField tauxTimbre;
    private SQLElement factureElt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
    private SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT").getTable();
    public static final SQLTable TABLE_ADRESSE = Configuration.getInstance().getDirectory().getElement("ADRESSE").getTable();
    private SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT");
    private final SQLElement client = Configuration.getInstance().getDirectory().getElement(this.tableClient);
    private JUniqueTextField textNumeroUnique;
    private ElementComboBox comboClient;
    private ISQLCompteSelector compteSel;
    private final SQLTable tableNum = this.factureElt.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private JCheckBox checkCompteServiceAuto;
    private JCheckBox checkPrevisionnelle;
    private JCheckBox checkComplement;
    private JCheckBox checkAcompte;
    private JCheckBox checkCT;
    protected PanelOOSQLComponent panelOO;
    private ElementComboBox selAvoir;
    private ElementComboBox selAffaire;
    private ElementSQLObject eltModeRegl;
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(tablePrefCompte).getRowFromId(2);
    private ElementComboBox contact;
    private SQLRowAccessor rowSelected;
    private SQLElement eltContact = Configuration.getInstance().getDirectory().getElement("CONTACT");
    private JTextField refClient = new JTextField();
    protected TotalPanel totalTTC;
    private final boolean displayDpt;
    private final ElementComboBox comboDpt = new ElementComboBox();
    private final boolean gestionTimbre;
    private SQLTextCombo textTypeMission = new SQLTextCombo();
    private PropertyChangeListener listenerModeReglDefaut = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            int idCli = SaisieVenteFactureSQLComponent.this.comboClient.getWantedID();
            if (idCli > 1) {
                SQLRow rowCli = SaisieVenteFactureSQLComponent.this.client.getTable().getRow(idCli);
                if (!SaisieVenteFactureSQLComponent.this.isFilling() && !rowCli.isForeignEmpty("ID_COMMERCIAL")) {
                    SaisieVenteFactureSQLComponent.this.comboCommercial.setValue(rowCli.getForeignID("ID_COMMERCIAL"));
                }
                if (rowCli.getFields().contains("ID_CATEGORIE_COMPTABLE") && rowCli.getObject("ID_CATEGORIE_COMPTABLE") != null && !rowCli.isForeignEmpty("ID_CATEGORIE_COMPTABLE")) {
                    SaisieVenteFactureSQLComponent.this.totalTTC.setCategorieComptable(rowCli.getForeign("ID_CATEGORIE_COMPTABLE"));
                    SaisieVenteFactureSQLComponent.this.tableFacture.setRowCatComptable(rowCli.getForeign("ID_CATEGORIE_COMPTABLE"));
                } else {
                    SaisieVenteFactureSQLComponent.this.totalTTC.setCategorieComptable(null);
                    SaisieVenteFactureSQLComponent.this.tableFacture.setRowCatComptable(null);
                }
                SaisieVenteFactureSQLComponent.this.tableFacture.setClient(rowCli, !SaisieVenteFactureSQLComponent.this.isFilling());
                if (SaisieVenteFactureSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION || !SaisieVenteFactureSQLComponent.this.isFilling()) {
                    SQLElement sqleltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                    int idModeRegl = rowCli.getInt("ID_MODE_REGLEMENT");
                    if (idModeRegl > 1) {
                        SQLRow rowModeRegl = sqleltModeRegl.getTable().getRow(idModeRegl);
                        SQLRowValues rowValsModeRegl = rowModeRegl.createUpdateRow();
                        rowValsModeRegl.clearPrimaryKeys();
                        SaisieVenteFactureSQLComponent.this.eltModeRegl.setValue(rowValsModeRegl);
                    }
                }
            } else {
                SaisieVenteFactureSQLComponent.this.totalTTC.setCategorieComptable(null);
                SaisieVenteFactureSQLComponent.this.tableFacture.setRowCatComptable(null);
            }
            Where w = new Where((FieldRef)SaisieVenteFactureSQLComponent.this.tableAvoir.getField("SOLDE"), "=", (Object)Boolean.FALSE);
            w = SaisieVenteFactureSQLComponent.this.comboClient.isEmpty() ? w.and(new Where((FieldRef)SaisieVenteFactureSQLComponent.this.getTable().getBase().getTable("AVOIR_CLIENT").getField("ID_CLIENT"), "=", -1)) : w.and(new Where((FieldRef)SaisieVenteFactureSQLComponent.this.getTable().getBase().getTable("AVOIR_CLIENT").getField("ID_CLIENT"), "=", idCli));
            if (SaisieVenteFactureSQLComponent.this.getSelectedID() > 1) {
                SQLRow row = SaisieVenteFactureSQLComponent.this.getTable().getRow(SaisieVenteFactureSQLComponent.this.getSelectedID());
                w = w.or(new Where((FieldRef)SaisieVenteFactureSQLComponent.this.tableAvoir.getKey(), "=", row.getInt("ID_AVOIR_CLIENT")));
            }
            SaisieVenteFactureSQLComponent.this.selAvoir.getRequest().setWhere(w);
            SaisieVenteFactureSQLComponent.this.selAvoir.fillCombo();
        }
    };
    private PropertyChangeListener changeCompteListener;
    private PropertyChangeListener changeClientListener;
    private ISQLCompteSelector compteSelService;
    private JLabel labelCompteServ;
    private ElementComboBox comboCommercial;
    private ElementComboBox comboPoleProduit;
    private ElementComboBox comboVerificateur = new ElementComboBox();
    private SQLTable tableBanque = this.getTable().getTable(BanqueSQLElement.TABLENAME);
    private final SQLRowAccessor defaultNum;
    private int previousClient = -1;
    private ElementComboBox comboNumAuto = null;
    private JCheckBox checkTaux;
    private static final SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");

    public SaisieVenteFactureSQLComponent(int defaultNum) {
        super(Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE"));
        this.defaultNum = this.tableNum.getRow(defaultNum);
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        this.displayDpt = prefs.getBoolean(GestionClientPreferencePanel.DISPLAY_CLIENT_DPT, false);
        this.gestionTimbre = prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.GESTION_TIMBRE_FISCAL, false);
    }

    public SaisieVenteFactureSQLComponent() {
        this(2);
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        if (this.getTable().contains("CREATE_VIRTUAL_STOCK")) {
            this.addView(new JCheckBox(), "CREATE_VIRTUAL_STOCK");
        }
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        if (this.getTable().contains("ID_NUMEROTATION_AUTO")) {
            this.comboNumAuto = new ElementComboBox();
            this.addView(this.comboNumAuto, "ID_NUMEROTATION_AUTO");
        }
        this.checkPrevisionnelle = new JCheckBox();
        this.checkComplement = new JCheckBox();
        this.fieldTTC = new DeviseField();
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        this.textAvoirTTC = new DeviseField();
        this.textAcompte = new DeviseField();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 1));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        JLabel labelNum = new JLabel(this.getLabelFor("NUMERO"));
        labelNum.setHorizontalAlignment(4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)labelNum, c);
        this.textNumeroUnique = new JUniqueTextField(16){

            @Override
            public String getAutoRefreshNumber() {
                if (SaisieVenteFactureSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                    return NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLComponent.this.getElement().getClass(), SaisieVenteFactureSQLComponent.this.dateSaisie.getDate(), SaisieVenteFactureSQLComponent.this.defaultNum);
                }
                return null;
            }
        };
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(this.textNumeroUnique);
        this.add((Component)this.textNumeroUnique, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("DATE"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.dateSaisie.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!SaisieVenteFactureSQLComponent.this.isFilling() && SaisieVenteFactureSQLComponent.this.dateSaisie.getValue() != null) {
                    int answer;
                    String nextNumero = NumerotationAutoSQLElement.getNextNumero(SaisieVenteFactureSQLComponent.this.getElement().getClass(), SaisieVenteFactureSQLComponent.this.dateSaisie.getValue(), SaisieVenteFactureSQLComponent.this.defaultNum);
                    if (SaisieVenteFactureSQLComponent.this.textNumeroUnique.getText().trim().length() > 0 && !nextNumero.equalsIgnoreCase(SaisieVenteFactureSQLComponent.this.textNumeroUnique.getText()) && (answer = JOptionPane.showConfirmDialog(SaisieVenteFactureSQLComponent.this, "Voulez vous actualiser le num\u00e9ro de la facture?", "Changement du num\u00e9ro de facture", 0)) == 1) {
                        return;
                    }
                    SaisieVenteFactureSQLComponent.this.textNumeroUnique.setText(nextNumero);
                    SaisieVenteFactureSQLComponent.this.tableFacture.setDateDevise(SaisieVenteFactureSQLComponent.this.dateSaisie.getValue());
                }
            }
        });
        this.add((Component)this.dateSaisie, c);
        c.gridx = 0;
        c.gridwidth = 1;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        JLabel labelLibelle = new JLabel(this.getLabelFor("NOM"));
        labelLibelle.setHorizontalAlignment(4);
        this.add((Component)labelLibelle, c);
        SQLTextCombo textLibelle = new SQLTextCombo();
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)textLibelle, c);
        this.addSQLObject(textLibelle, "NOM");
        c.fill = 2;
        this.comboCommercial = new ElementComboBox(false);
        this.addRequiredSQLObject(this.comboCommercial, "ID_COMMERCIAL");
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_COMMERCIAL"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)this.comboCommercial, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_CLIENT"), 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        ValidatedValueWrapper<Integer> clientValidatedValueWrapper = ValidatedValueWrapper.add(new ElementComboBox(), new ITransformer<Integer, ValidState>(){

            @Override
            public ValidState transformChecked(Integer t) {
                ElementComboBox boxClient = (ElementComboBox)SaisieVenteFactureSQLComponent.this.getView("ID_CLIENT").getComp();
                if (SaisieVenteFactureSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION && boxClient != null && !boxClient.isEmpty() && boxClient.getSelectedRow().getBoolean("BLOQUE").booleanValue()) {
                    return ValidState.create(false, "Les int\u00e9ractions avec ce client sont verrouill\u00e9es.");
                }
                return ValidState.getTrueInstance();
            }
        });
        this.comboClient = (ElementComboBox)clientValidatedValueWrapper.getComp();
        this.addView(new SimpleRowItemView<Integer>(clientValidatedValueWrapper), "ID_CLIENT", (Object)"required");
        this.add((Component)this.comboClient, c);
        if (this.displayDpt) {
            ++c.gridx;
            c.gridwidth = 1;
            JLabel labelDpt = new JLabel(this.getLabelFor("ID_CLIENT_DEPARTEMENT"));
            labelDpt.setHorizontalAlignment(4);
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)labelDpt, c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)this.comboDpt, c);
            DefaultGridBagConstraints.lockMinimumSize(this.comboDpt);
            this.addSQLObject(this.comboDpt, "ID_CLIENT_DEPARTEMENT");
            this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = SaisieVenteFactureSQLComponent.this.comboClient.getWantedID();
                    if (wantedID != -1 && wantedID >= 0) {
                        SQLRow rowClient = SaisieVenteFactureSQLComponent.this.getTable().getForeignTable("ID_CLIENT").getRow(wantedID);
                        SaisieVenteFactureSQLComponent.this.comboDpt.getRequest().setWhere(new Where((FieldRef)SaisieVenteFactureSQLComponent.this.comboDpt.getRequest().getPrimaryTable().getField("ID_CLIENT"), "=", rowClient.getID()));
                    } else {
                        SaisieVenteFactureSQLComponent.this.comboDpt.getRequest().setWhere(null);
                    }
                }
            });
        }
        if (this.getTable().contains("ID_POLE_PRODUIT")) {
            JLabel labelPole = new JLabel(this.getLabelFor("ID_POLE_PRODUIT"));
            labelPole.setHorizontalAlignment(4);
            ++c.gridx;
            this.add((Component)labelPole, c);
            ++c.gridx;
            this.comboPoleProduit = new ElementComboBox();
            this.add((Component)this.comboPoleProduit, c);
            this.addSQLObject(this.comboPoleProduit, "ID_POLE_PRODUIT");
            DefaultGridBagConstraints.lockMinimumSize(this.comboPoleProduit);
        }
        if (this.getTable().contains("ID_ECHEANCIER_CCI")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_ECHEANCIER_CCI"), 4), c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 0;
            final ElementComboBox echeancier = new ElementComboBox();
            final SQLElement contactElement = Configuration.getInstance().getDirectory().getElement("ECHEANCIER_CCI");
            echeancier.init(contactElement, contactElement.getComboRequest(true));
            DefaultGridBagConstraints.lockMinimumSize(echeancier);
            this.addView(echeancier, "ID_ECHEANCIER_CCI");
            this.selAffaire.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (SaisieVenteFactureSQLComponent.this.selAffaire.getSelectedRow() != null) {
                        echeancier.getRequest().setWhere(new Where((FieldRef)contactElement.getTable().getField("ID_AFFAIRE"), "=", SaisieVenteFactureSQLComponent.this.selAffaire.getSelectedRow().getID()));
                        if (!SaisieVenteFactureSQLComponent.this.isFilling()) {
                            SQLRow rowPole = SaisieVenteFactureSQLComponent.this.selAffaire.getSelectedRow().getForeignRow("ID_POLE_PRODUIT");
                            SaisieVenteFactureSQLComponent.this.comboPoleProduit.setValue(rowPole);
                        }
                    } else {
                        echeancier.getRequest().setWhere(null);
                    }
                }
            });
            this.add((Component)echeancier, c);
        }
        this.comboClient.addValueListener(this.changeClientListener);
        final SQLElement adrElement = this.getElement().getForeignElement("ID_ADRESSE");
        final AddressChoiceUI addressUI = new AddressChoiceUI();
        addressUI.addToUI(this, c);
        this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int wantedID = SaisieVenteFactureSQLComponent.this.comboClient.getWantedID();
                System.err.println("SET WHERE ID_CLIENT = " + wantedID);
                if (wantedID != -1 && wantedID >= 0) {
                    addressUI.getComboAdrF().getRequest().setWhere(new Where((FieldRef)adrElement.getTable().getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)adrElement.getTable().getField("TYPE"), "=", (Object)AdresseType.Invoice.getId())));
                    addressUI.getComboAdrL().getRequest().setWhere(new Where((FieldRef)adrElement.getTable().getField("ID_CLIENT"), "=", wantedID).and(new Where((FieldRef)adrElement.getTable().getField("TYPE"), "=", (Object)AdresseType.Delivery.getId())));
                } else {
                    addressUI.getComboAdrF().getRequest().setWhere(Where.FALSE);
                    addressUI.getComboAdrL().getRequest().setWhere(Where.FALSE);
                }
            }
        });
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.CATEGORIE_COMPTABLE_SPEC, false)) {
            final CategorieComptableChoiceUI catUI = new CategorieComptableChoiceUI();
            catUI.addToUI(this, c);
            catUI.getCombo().addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    int wantedID = catUI.getCombo().getWantedID();
                    if (wantedID != -1 && wantedID >= 0) {
                        SaisieVenteFactureSQLComponent.this.tableFacture.setRowCatComptable(catUI.getCombo().getElement().getTable().getRow(wantedID));
                    } else {
                        SaisieVenteFactureSQLComponent.this.tableFacture.setRowCatComptable(null);
                    }
                }
            });
        }
        this.contact = new ElementComboBox(){

            @Override
            protected SQLComponent createSQLComponent(EditPanel.EditMode mode) {
                SQLComponent c = super.createSQLComponent(mode);
                if (mode.equals((Object)EditPanel.EditMode.CREATION)) {
                    c.setDefaultsFactory(new IFactory<SQLRowValues>(){

                        @Override
                        public SQLRowValues createChecked() {
                            SQLRowValues defaultContactRowValues = new SQLRowValues(SaisieVenteFactureSQLComponent.this.eltContact.getTable());
                            SQLRow row = SaisieVenteFactureSQLComponent.this.comboClient.getSelectedRow();
                            defaultContactRowValues.putForeignID("ID_CLIENT", row);
                            return defaultContactRowValues;
                        }
                    });
                }
                return c;
            }
        };
        JLabel labelContact = new JLabel(this.getLabelFor("ID_CONTACT"));
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        labelContact.setHorizontalAlignment(4);
        this.add((Component)labelContact, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)this.contact, c);
        SQLElement contactElement = this.getElement().getForeignElement("ID_CONTACT");
        this.contact.init(contactElement, contactElement.getComboRequest(true));
        this.contact.getRequest().setWhere(Where.FALSE);
        this.addSQLObject(this.contact, "ID_CONTACT");
        if (this.getTable().contains("DATE_LIVRAISON")) {
            JLabel labelDateLiv = new JLabel("Livraison le");
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 2;
            labelDateLiv.setHorizontalAlignment(4);
            this.add((Component)labelDateLiv, c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            JDate dateLiv = new JDate();
            this.add((Component)dateLiv, c);
            c.fill = 2;
            this.addSQLObject(dateLiv, "DATE_LIVRAISON");
        }
        this.checkAcompte = new JCheckBox(this.getLabelFor("ACOMPTE"));
        ++c.gridx;
        c.gridwidth = 0;
        c.gridwidth = 1;
        this.addView(this.checkAcompte, "ACOMPTE");
        this.checkCompteServiceAuto = new JCheckBox(this.getLabelFor("COMPTE_SERVICE_AUTO"));
        this.addSQLObject(this.checkCompteServiceAuto, "COMPTE_SERVICE_AUTO");
        this.compteSelService = new ISQLCompteSelector();
        this.labelCompteServ = new JLabel("Compte Service");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.labelCompteServ.setHorizontalAlignment(4);
        this.add((Component)this.labelCompteServ, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)this.compteSelService, c);
        String valServ = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServ = Boolean.valueOf(valServ);
        this.checkCompteServiceAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaisieVenteFactureSQLComponent.this.setCompteServiceVisible(!SaisieVenteFactureSQLComponent.this.checkCompteServiceAuto.isSelected());
            }
        });
        this.setCompteServiceVisible(false);
        this.setCompteServiceVisible(bServ == null || bServ != false);
        final JPanel pAcompte = new JPanel();
        DeviseField textAcompteHT = new DeviseField();
        pAcompte.add(new JLabel("Acompte HT"));
        pAcompte.add(textAcompteHT);
        pAcompte.add(new JLabel("soit"));
        JTextField textAcompte = new JTextField(5);
        pAcompte.add(textAcompte);
        pAcompte.add(new JLabel("%"));
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 13;
        c.fill = 0;
        this.add((Component)pAcompte, c);
        c.anchor = 17;
        this.addView(textAcompte, "POURCENT_ACOMPTE");
        pAcompte.setVisible(false);
        this.tableFacture = new SaisieVenteFactureItemTable();
        final ElementComboBox boxTarif = new ElementComboBox();
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_TARIF"), 4), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 0;
            c.weightx = 1.0;
            DefaultGridBagConstraints.lockMinimumSize(boxTarif);
            this.add((Component)boxTarif, c);
            this.addView(boxTarif, "ID_TARIF");
            boxTarif.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SQLRow selectedRow = boxTarif.getRequest().getPrimaryTable().getRow(boxTarif.getWantedID());
                    SaisieVenteFactureSQLComponent.this.tableFacture.setTarif(selectedRow, !SaisieVenteFactureSQLComponent.this.isFilling());
                }
            });
        }
        if (this.getTable().getFieldsName().contains("ACOMPTE_COMMANDE")) {
            c.gridy = c.gridy + (this.getTable().getFieldsName().contains("ID_TARIF") ? 0 : 1);
            c.gridx = c.gridx + (this.getTable().getFieldsName().contains("ID_TARIF") ? 1 : 2);
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ACOMPTE_COMMANDE"), 4), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 0;
            c.weightx = 1.0;
            JTextField acompteCmd = new JTextField(15);
            DefaultGridBagConstraints.lockMinimumSize(acompteCmd);
            this.add((Component)acompteCmd, c);
            this.addView(acompteCmd, "ACOMPTE_COMMANDE");
        }
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        ITextArea infos = new ITextArea(4, 4);
        this.add((Component)this.tableFacture, c);
        this.addView(this.tableFacture.getRowValuesTable(), "");
        JPanel panelBottom = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cBottom = new DefaultGridBagConstraints();
        cBottom.weightx = 1.0;
        cBottom.anchor = 18;
        this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
        this.eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
        panelBottom.add((Component)this.eltModeRegl, cBottom);
        JPanel panelFrais = new JPanel();
        panelFrais.setLayout(new GridBagLayout());
        DefaultGridBagConstraints cFrais = new DefaultGridBagConstraints();
        this.textPortHT = new DeviseField(5);
        DefaultGridBagConstraints.lockMinimumSize(this.textPortHT);
        this.addSQLObject(this.textPortHT, "PORT_HT");
        this.textRemiseHT = new DeviseField(5);
        DefaultGridBagConstraints.lockMinimumSize(this.textRemiseHT);
        this.addSQLObject(this.textRemiseHT, "REMISE_HT");
        cFrais.gridheight = 1;
        cFrais.gridx = 1;
        SQLRequestComboBox boxTaxePort = new SQLRequestComboBox(false, 8);
        if (this.getTable().contains("ID_TAXE_PORT")) {
            JLabel labelPortHT = new JLabel(this.getLabelFor("PORT_HT"));
            labelPortHT.setHorizontalAlignment(4);
            ++cFrais.gridy;
            panelFrais.add((Component)labelPortHT, cFrais);
            ++cFrais.gridx;
            panelFrais.add((Component)this.textPortHT, cFrais);
            JLabel labelTaxeHT = new JLabel(this.getLabelFor("ID_TAXE_PORT"));
            labelTaxeHT.setHorizontalAlignment(4);
            cFrais.gridx = 1;
            ++cFrais.gridy;
            panelFrais.add((Component)labelTaxeHT, cFrais);
            ++cFrais.gridx;
            panelFrais.add((Component)boxTaxePort, cFrais);
            this.addView(boxTaxePort, "ID_TAXE_PORT", (Object)"required");
            boxTaxePort.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SaisieVenteFactureSQLComponent.this.totalTTC.updateTotal();
                }
            });
        }
        final DeviseField textFraisDocHT = new DeviseField();
        final SQLRequestComboBox boxTaxeFraisDoc = new SQLRequestComboBox(false, 8);
        boolean showFrais = prefs.getBoolean(GestionCommercialeGlobalPreferencePanel.FRAIS_DOCUMENT, false);
        if (showFrais) {
            JLabel labelFraisDocHT = new JLabel(this.getLabelFor("FRAIS_DOCUMENT_HT"));
            labelFraisDocHT.setHorizontalAlignment(4);
            cFrais.gridx = 1;
            ++cFrais.gridy;
            panelFrais.add((Component)labelFraisDocHT, cFrais);
            ++cFrais.gridx;
            panelFrais.add((Component)textFraisDocHT, cFrais);
            this.addView(textFraisDocHT, "FRAIS_DOCUMENT_HT");
            JLabel labelTaxeFraisDocHT = new JLabel(this.getLabelFor("ID_TAXE_FRAIS_DOCUMENT"));
            labelTaxeFraisDocHT.setHorizontalAlignment(4);
            cFrais.gridx = 1;
            ++cFrais.gridy;
            panelFrais.add((Component)labelTaxeFraisDocHT, cFrais);
            ++cFrais.gridx;
            panelFrais.add((Component)boxTaxeFraisDoc, cFrais);
            this.addView(boxTaxeFraisDoc, "ID_TAXE_FRAIS_DOCUMENT", (Object)"required");
            boxTaxeFraisDoc.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SaisieVenteFactureSQLComponent.this.totalTTC.updateTotal();
                }
            });
            textFraisDocHT.getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    SaisieVenteFactureSQLComponent.this.totalTTC.updateTotal();
                }
            });
            this.comboClient.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!SaisieVenteFactureSQLComponent.this.isFilling()) {
                        int wantedID = SaisieVenteFactureSQLComponent.this.comboClient.getWantedID();
                        long l = 0L;
                        if (wantedID != -1 && wantedID >= 0) {
                            SQLRow rowClient = SaisieVenteFactureSQLComponent.this.getTable().getForeignTable("ID_CLIENT").getRow(wantedID);
                            SQLRow rowFrais = rowClient.getForeign("ID_FRAIS_DOCUMENT");
                            if (rowFrais != null && !rowFrais.isUndefined()) {
                                l = rowFrais.getLong("MONTANT_HT");
                                boxTaxeFraisDoc.setValue(rowFrais.getForeignID("ID_TAXE"));
                            }
                            textFraisDocHT.setValue(l);
                        }
                    }
                }
            });
        }
        JLabel labelRemiseHT = new JLabel(this.getLabelFor("REMISE_HT"));
        labelRemiseHT.setHorizontalAlignment(4);
        ++cFrais.gridy;
        cFrais.gridx = 1;
        panelFrais.add((Component)labelRemiseHT, cFrais);
        ++cFrais.gridx;
        panelFrais.add((Component)this.textRemiseHT, cFrais);
        ++cFrais.gridy;
        ++cBottom.gridx;
        cBottom.weightx = 1.0;
        cBottom.anchor = 12;
        cBottom.fill = 0;
        panelBottom.add((Component)panelFrais, cBottom);
        DeviseField fieldHT = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldService = new DeviseField();
        DeviseField fieldTHA = new DeviseField();
        DeviseField fieldTEco = new DeviseField();
        DeviseField fieldDevise = null;
        if (this.getTable().getFieldsName().contains("T_DEVISE")) {
            fieldDevise = new DeviseField();
            this.addSQLObject(fieldDevise, "T_DEVISE");
        }
        this.addSQLObject(fieldTHA, "T_HA");
        this.addSQLObject(fieldTEco, "T_ECO_CONTRIBUTION");
        this.addRequiredSQLObject(fieldHT, "T_HT");
        this.addRequiredSQLObject(fieldTVA, "T_TVA");
        this.addRequiredSQLObject(this.fieldTTC, "T_TTC");
        this.addRequiredSQLObject(fieldService, "T_SERVICE");
        JTextField poids = new JTextField();
        this.addSQLObject(poids, "T_POIDS");
        this.allowEditable("T_HA", false);
        this.allowEditable("T_ECO_CONTRIBUTION", false);
        this.allowEditable("T_HT", false);
        this.allowEditable("T_TVA", false);
        this.allowEditable("T_TTC", false);
        this.allowEditable("T_SERVICE", false);
        this.allowEditable("T_POIDS", false);
        this.totalTTC = new TotalPanel(this.tableFacture, fieldTEco, fieldHT, fieldTVA, this.fieldTTC, this.textPortHT, this.textRemiseHT, fieldService, fieldTHA, fieldDevise, poids, null, this.getTable().contains("ID_TAXE_PORT") ? boxTaxePort : null, null);
        this.totalTTC.setTextFraisDoc(textFraisDocHT, boxTaxeFraisDoc);
        DefaultGridBagConstraints.lockMinimumSize(this.totalTTC);
        ++cBottom.gridx;
        cBottom.weightx = 1.0;
        cBottom.anchor = 13;
        cBottom.fill = 2;
        panelBottom.add((Component)this.totalTTC, cBottom);
        c.anchor = 17;
        c.gridwidth = 0;
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)panelBottom, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.anchor = 13;
        c.fill = 2;
        JPanel timbrePanel = this.createTimbrePanel();
        this.add((Component)timbrePanel, c);
        timbrePanel.setVisible(this.gestionTimbre);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.anchor = 13;
        c.fill = 2;
        this.add((Component)this.createPanelAvoir(), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.fill = 1;
        this.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        JScrollPane comp = new JScrollPane(infos);
        infos.setBorder(null);
        DefaultGridBagConstraints.lockMinimumSize(comp);
        this.add((Component)comp, c);
        this.panelOO = new PanelOOSQLComponent(this);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 12;
        this.add((Component)this.panelOO, c);
        this.addSQLObject(this.textAvoirTTC, "T_AVOIR_TTC");
        this.addSQLObject(this.textAcompte, "T_ACOMPTE");
        this.addRequiredSQLObject(this.dateSaisie, "DATE");
        this.addRequiredSQLObject(this.textNumeroUnique, "NUMERO");
        this.addSQLObject(infos, "INFOS");
        this.addSQLObject(this.checkPrevisionnelle, "PREVISIONNELLE");
        this.addSQLObject(this.checkComplement, "COMPLEMENT");
        this.addSQLObject(this.selAvoir, "ID_AVOIR_CLIENT");
        this.addSQLObject(this.compteSelService, "ID_COMPTE_PCE_SERVICE");
        ModeDeReglementSQLComponent modeReglComp = (ModeDeReglementSQLComponent)this.eltModeRegl.getSQLChild();
        modeReglComp.addDateCompListener(this.dateSaisie);
        this.selAvoir.getRequest().setWhere(new Where((FieldRef)this.tableAvoir.getField("SOLDE"), "=", (Object)Boolean.FALSE));
        this.selAvoir.fillCombo();
        int idCompteVenteService = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_SERVICE");
        if (idCompteVenteService <= 1) {
            try {
                idCompteVenteService = ComptePCESQLElement.getIdComptePceDefault("VentesServices");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.compteSelService.setValue(idCompteVenteService);
        DefaultGridBagConstraints.lockMinimumSize(this.comboClient);
        DefaultGridBagConstraints.lockMinimumSize(this.comboCommercial);
        this.comboClient.addValueListener(this.listenerModeReglDefaut);
        this.fieldTTC.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                SaisieVenteFactureSQLComponent.this.calculTimbre();
                SaisieVenteFactureSQLComponent.this.refreshText();
            }
        });
        if (this.checkTaux != null) {
            this.checkTaux.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SaisieVenteFactureSQLComponent.this.calculTimbre();
                    SaisieVenteFactureSQLComponent.this.refreshText();
                }
            });
        }
        this.tauxTimbre.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                SaisieVenteFactureSQLComponent.this.calculTimbre();
                SaisieVenteFactureSQLComponent.this.refreshText();
            }
        });
        this.totalTimbre.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                SaisieVenteFactureSQLComponent.this.refreshText();
            }
        });
        this.selAvoir.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SaisieVenteFactureSQLComponent.this.refreshText();
            }
        });
        this.checkAcompte.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                pAcompte.setVisible(SaisieVenteFactureSQLComponent.this.checkAcompte.isSelected());
            }
        });
        this.changeClientListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (SaisieVenteFactureSQLComponent.this.comboClient.getSelectedRow() != null) {
                    int id;
                    SQLRow row = SaisieVenteFactureSQLComponent.this.comboClient.getSelectedRow();
                    int n = id = row == null ? -1 : row.getID();
                    if (row != null) {
                        if (row.getFields().contains("ID_COMPTE_PCE_SERVICE") && SaisieVenteFactureSQLComponent.this.compteSelService != null && !row.isForeignEmpty("ID_COMPTE_PCE_SERVICE")) {
                            SaisieVenteFactureSQLComponent.this.compteSelService.setValue(row.getForeignID("ID_COMPTE_PCE_SERVICE"));
                        }
                        if (row.getFields().contains("ID_COMPTE_PCE_PRODUIT") && !row.isForeignEmpty("ID_COMPTE_PCE_PRODUIT")) {
                            SaisieVenteFactureSQLComponent.this.totalTTC.setDefaultCompteProduit(row.getForeign("ID_COMPTE_PCE_PRODUIT"));
                        }
                    }
                    if (row != null && SaisieVenteFactureSQLComponent.this.contact != null) {
                        Where w = new Where((FieldRef)SaisieVenteFactureSQLComponent.this.eltContact.getTable().getField("ID_CLIENT"), "=", -1);
                        w = w.or(new Where((FieldRef)SaisieVenteFactureSQLComponent.this.eltContact.getTable().getField("ID_CLIENT"), "=", id));
                        SaisieVenteFactureSQLComponent.this.contact.getRequest().setWhere(w);
                    }
                    SaisieVenteFactureSQLComponent.this.previousClient = id;
                }
            }
        };
        this.changeCompteListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLSelect sel = new SQLSelect(SaisieVenteFactureSQLComponent.this.getTable().getBase());
                sel.addSelect(SaisieVenteFactureSQLComponent.this.client.getTable().getKey());
                Where where = new Where((FieldRef)SaisieVenteFactureSQLComponent.this.client.getTable().getField("ID_COMPTE_PCE"), "=", (Object)SaisieVenteFactureSQLComponent.this.compteSel.getValue());
                sel.setWhere(where);
                String req = sel.asString();
                List l = SaisieVenteFactureSQLComponent.this.getTable().getBase().getDataSource().execute(req);
                if (l != null && l.size() == 1) {
                    Map m = (Map)l.get(0);
                    Object o = m.get(SaisieVenteFactureSQLComponent.this.client.getTable().getKey().getName());
                    System.err.println("Only one value match :: " + o);
                    if (o != null) {
                        SaisieVenteFactureSQLComponent.this.comboClient.setValue((Integer)((Number)o).intValue());
                    }
                }
            }
        };
        this.textPortHT.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                SaisieVenteFactureSQLComponent.this.totalTTC.updateTotal();
            }
        });
        this.textRemiseHT.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                SaisieVenteFactureSQLComponent.this.totalTTC.updateTotal();
            }
        });
        this.comboClient.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (SaisieVenteFactureSQLComponent.this.isFilling()) {
                    return;
                }
                SQLRow row = ((SQLRequestComboBox)evt.getSource()).getSelectedRow();
                if (row != null) {
                    Integer i;
                    int idCpt;
                    if (SaisieVenteFactureSQLComponent.this.client.getTable().contains("ID_TARIF")) {
                        SQLRow foreignRow = row.getForeignRow("ID_TARIF");
                        if (!(foreignRow == null || foreignRow.isUndefined() || boxTarif.getSelectedRow() != null && boxTarif.getSelectedId() == ((SQLRowAccessor)foreignRow).getID())) {
                            boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        } else {
                            boxTarif.setValue(foreignRow);
                        }
                    }
                    if ((idCpt = row.getInt("ID_COMPTE_PCE")) <= 1 && (idCpt = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                        try {
                            idCpt = ComptePCESQLElement.getIdComptePceDefault("Clients");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (SaisieVenteFactureSQLComponent.this.compteSel != null && ((i = SaisieVenteFactureSQLComponent.this.compteSel.getValue()) == null || i != idCpt)) {
                        SaisieVenteFactureSQLComponent.this.compteSel.setValue(idCpt);
                    }
                }
            }
        });
    }

    private void calculTimbre() {
        this.totalTimbre.setValue(0L);
        if (this.gestionTimbre && this.checkTaux != null && this.checkTaux.isSelected() && this.tauxTimbre.getText().trim().length() != 0) {
            BigDecimal taux = new BigDecimal(this.tauxTimbre.getText());
            Long ttc = this.fieldTTC.getValue();
            if (ttc != null) {
                long timbreValue = taux.multiply(new BigDecimal(ttc)).movePointLeft(2).setScale(0, RoundingMode.HALF_UP).longValue();
                this.totalTimbre.setValue(timbreValue);
            }
        }
    }

    private JPanel createPanelAvoir() {
        JPanel panelAvoir = new JPanel(new GridBagLayout());
        panelAvoir.setOpaque(false);
        DefaultGridBagConstraints cA = new DefaultGridBagConstraints();
        JLabel labelAvoir = new JLabel(this.getLabelFor("ID_AVOIR_CLIENT"));
        labelAvoir.setHorizontalAlignment(4);
        cA.weightx = 1.0;
        labelAvoir.setHorizontalAlignment(4);
        panelAvoir.add((Component)labelAvoir, cA);
        cA.weightx = 0.0;
        ++cA.gridx;
        this.selAvoir = new ElementComboBox();
        this.selAvoir.setAddIconVisible(false);
        panelAvoir.add((Component)this.selAvoir, cA);
        JLabel labelTotalAvoir = new JLabel("Total \u00e0 r\u00e9gler");
        this.textNetAPayer = new DeviseField();
        this.textNetAPayer.setEditable(false);
        ++cA.gridx;
        cA.weightx = 0.0;
        panelAvoir.add((Component)labelTotalAvoir, cA);
        ++cA.gridx;
        cA.weightx = 0.0;
        panelAvoir.add((Component)this.textNetAPayer, cA);
        this.addView(this.textNetAPayer, "NET_A_PAYER");
        this.textNetAPayer.setHorizontalAlignment(4);
        return panelAvoir;
    }

    private JPanel createTimbrePanel() {
        JPanel panelTimbre = new JPanel(new GridBagLayout());
        panelTimbre.setOpaque(false);
        DefaultGridBagConstraints cA = new DefaultGridBagConstraints();
        this.checkTaux = new JCheckBox(String.valueOf(this.getLabelFor("SOUMIS_TIMBRE_FISCAL")) + " " + this.getLabelFor("TAUX_TIMBRE_FISCAL"));
        this.checkTaux.setHorizontalAlignment(4);
        cA.weightx = 1.0;
        this.checkTaux.setHorizontalAlignment(4);
        panelTimbre.add((Component)this.checkTaux, cA);
        cA.weightx = 0.0;
        ++cA.gridx;
        this.tauxTimbre = new JTextField(8);
        panelTimbre.add((Component)this.tauxTimbre, cA);
        JLabel labelTotalTimbre = new JLabel(this.getLabelFor("TOTAL_TIMBRE_FISCAL"));
        this.totalTimbre = new DeviseField();
        this.totalTimbre.setEditable(false);
        ++cA.gridx;
        cA.weightx = 0.0;
        panelTimbre.add((Component)labelTotalTimbre, cA);
        ++cA.gridx;
        cA.weightx = 0.0;
        panelTimbre.add((Component)this.totalTimbre, cA);
        this.totalTimbre.setHorizontalAlignment(4);
        this.addView(this.checkTaux, "SOUMIS_TIMBRE_FISCAL");
        this.addView(this.tauxTimbre, "TAUX_TIMBRE_FISCAL");
        this.addView(this.totalTimbre, "TOTAL_TIMBRE_FISCAL");
        return panelTimbre;
    }

    private void setCompteServiceVisible(boolean b) {
        this.compteSelService.setVisible(b);
        this.labelCompteServ.setVisible(b);
    }

    private void refreshText() {
        Long acompte;
        Long timbre;
        Long n = this.fieldTTC.getValue();
        long totalAvoirTTC = 0L;
        long netAPayer = 0L;
        long ttc = 0L;
        if (n != null) {
            netAPayer = n;
            ttc = n;
        }
        if (this.selAvoir.getSelectedId() > 1) {
            SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT").getTable();
            if (n != null) {
                long l;
                SQLRow row;
                int idAvoirOld;
                SQLRow rowAvoir = tableAvoir.getRow(this.selAvoir.getSelectedId());
                long totalAvoir = ((Number)rowAvoir.getObject("MONTANT_TTC")).longValue();
                totalAvoir -= ((Number)rowAvoir.getObject("MONTANT_SOLDE")).longValue();
                if (this.getSelectedID() > 1 && (idAvoirOld = (row = this.getTable().getRow(this.getSelectedID())).getInt("ID_AVOIR_CLIENT")) == rowAvoir.getID()) {
                    totalAvoir += Long.valueOf(row.getObject("T_AVOIR_TTC").toString()).longValue();
                }
                if ((l = ttc - totalAvoir) < 0L) {
                    l = 0L;
                    totalAvoirTTC = ttc;
                } else {
                    totalAvoirTTC = totalAvoir;
                }
                netAPayer = l;
            }
        }
        if (this.gestionTimbre && (timbre = this.totalTimbre.getValue()) != null) {
            netAPayer += timbre.longValue();
        }
        if ((acompte = this.textAcompte.getValue()) != null) {
            netAPayer -= acompte.longValue();
        }
        this.textNetAPayer.setValue(netAPayer);
        this.textAvoirTTC.setValue(totalAvoirTTC);
    }

    @Override
    public int insert(SQLRow order) {
        return this.commit(order);
    }

    private void createCompteServiceAuto(int id) throws SQLException {
        SQLRow rowPole = this.comboPoleProduit.getSelectedRow();
        SQLRow rowVerif = this.comboVerificateur.getSelectedRow();
        String verifInitiale = this.getInitialesFromVerif(rowVerif);
        int idCpt = ComptePCESQLElement.getId("706" + rowPole.getString("CODE") + verifInitiale, "Service " + rowPole.getString("NOM") + " " + rowVerif.getString("NOM"));
        SQLRowValues rowVals = this.getTable().getRow(id).createEmptyUpdateRow();
        rowVals.put("ID_COMPTE_PCE_SERVICE", idCpt);
        rowVals.update();
    }

    @Override
    public void select(SQLRowAccessor r) {
        this.panelOO.getCheckAbo().setSelected(false);
        boolean isPartial = false;
        if (r != null && r.getBoolean("PARTIAL") != null) {
            isPartial = r.getBoolean("PARTIAL");
        }
        boolean isSolde = false;
        if (r != null && r.getBoolean("SOLDE") != null) {
            isSolde = r.getBoolean("SOLDE");
        }
        if (this.getMode() == SQLComponent.Mode.MODIFICATION && r != null && !r.isUndefined() && (isPartial || isSolde)) {
            throw new IllegalArgumentException("Impossible de modifier une facturation interm\u00e9diaire");
        }
        if (this.compteSel != null) {
            this.compteSel.rmValueListener(this.changeCompteListener);
        }
        this.rowSelected = r;
        if (r != null && !r.isUndefined() && r.getObject("ID_MOUVEMENT") != null && !r.isForeignEmpty("ID_MOUVEMENT")) {
            SQLTable tableEcr = this.getTable().getTable("ECRITURE");
            SQLTable tableMvt = this.getTable().getTable("MOUVEMENT");
            SQLTable tablePiece = this.getTable().getTable("PIECE");
            SQLSelect sel = new SQLSelect();
            sel.addSelect(tableEcr.getKey(), "COUNT");
            int idPiece = r.getForeign("ID_MOUVEMENT").getInt("ID_PIECE");
            Where w = new Where((FieldRef)tableMvt.getKey(), "=", tableEcr.getField("ID_MOUVEMENT"));
            w = w.and(new Where((FieldRef)tablePiece.getKey(), "=", tableMvt.getField("ID_PIECE")));
            w = w.and(new Where((FieldRef)tablePiece.getKey(), "=", idPiece));
            w = w.and(new Where((FieldRef)tableEcr.getField("POINTEE"), "!=", (Object)"").or(new Where((FieldRef)tableEcr.getField("LETTRAGE"), "!=", (Object)"")));
            sel.setWhere(w);
            Object o = Configuration.getInstance().getRoot().getBase().getDataSource().executeScalar(sel.asString());
            if (o != null && ((Number)o).longValue() > 0L) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Attention cette facture est point\u00e9e ou lettr\u00e9e en comptabilit\u00e9. \nToute modification \u00e9crasera ces informations comptables.");
                    }
                });
            }
            sel = new SQLSelect();
            SQLTable tableAssoc = this.getTable().getTable("ASSOCIATION_ANALYTIQUE");
            sel.addSelect(tableAssoc.getKey(), "COUNT");
            int idPiece2 = r.getForeign("ID_MOUVEMENT").getInt("ID_PIECE");
            Where w2 = new Where((FieldRef)tableMvt.getKey(), "=", tableEcr.getField("ID_MOUVEMENT"));
            w2 = w2.and(new Where((FieldRef)tableAssoc.getField("ID_ECRITURE"), "=", tableEcr.getKey()));
            w2 = w2.and(new Where((FieldRef)tablePiece.getKey(), "=", tableMvt.getField("ID_PIECE")));
            w2 = w2.and(new Where((FieldRef)tablePiece.getKey(), "=", idPiece2));
            w2 = w2.and(new Where((FieldRef)tableAssoc.getField("GESTION_AUTO"), "=", (Object)Boolean.FALSE));
            sel.setWhere(w2);
            System.err.println(sel.asString());
            Object o2 = Configuration.getInstance().getRoot().getBase().getDataSource().executeScalar(sel.asString());
            if (o2 != null && ((Number)o2).longValue() > 0L) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Attention la r\u00e9partition analytique a \u00e9t\u00e9 modifi\u00e9 manuellement sur cette facture. \nToute modification \u00e9crasera ces informations comptables.");
                    }
                });
            }
        }
        super.select(r);
        if (r != null) {
            Boolean b = (Boolean)r.getObject("ACOMPTE");
            if (b != null) {
                this.setAcompte(b);
            } else {
                this.setAcompte(false);
            }
        }
        if (this.comboClient != null) {
            this.comboClient.addValueListener(this.changeClientListener);
        }
        if (this.compteSel != null) {
            this.compteSel.addValueListener(this.changeCompteListener);
        }
    }

    private String getInitialesFromVerif(SQLRow row) {
        String s = "";
        if (row != null) {
            String nom;
            String prenom = row.getString("PRENOM");
            if (prenom != null && prenom.length() > 0) {
                s = String.valueOf(s) + prenom.toUpperCase().charAt(0);
            }
            if ((nom = row.getString("NOM")) != null && nom.length() > 0) {
                s = String.valueOf(s) + nom.toUpperCase().charAt(0);
            }
        }
        return s;
    }

    public int commit(SQLRow order) {
        String num;
        int idSaisieVF = -1;
        long lFactureOld = 0L;
        SQLRow rowFactureOld = null;
        SQLRow rowFacture = null;
        int attempt = 0;
        boolean validated = this.textNumeroUnique.checkValidation(false);
        while (!validated && attempt < JUniqueTextField.RETRY_COUNT) {
            try {
                Thread.sleep(JUniqueTextField.SLEEP_WAIT_MS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            num = NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), this.dateSaisie.getDate(), this.defaultNum);
            this.textNumeroUnique.setText(num);
            validated = this.textNumeroUnique.checkValidation(false);
            System.err.println("ATTEMPT " + attempt + " WITH NUMERO " + num + " validated : " + validated);
            ++attempt;
        }
        num = this.textNumeroUnique.getText();
        if (!validated) {
            idSaisieVF = this.getSelectedID();
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de facture existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        } else {
            try {
                if (this.getMode() == SQLComponent.Mode.INSERTION) {
                    SQLRow rowNum;
                    idSaisieVF = super.insert(order);
                    rowFacture = this.getTable().getRow(idSaisieVF);
                    SQLRow sQLRow = rowNum = this.comboNumAuto == null ? this.tableNum.getRow(2) : this.comboNumAuto.getSelectedRow();
                    if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), rowFacture.getDate("DATE").getTime(), rowNum).equalsIgnoreCase(this.textNumeroUnique.getText().trim())) {
                        SQLRowValues rowVals = rowNum.createEmptyUpdateRow();
                        String labelNumberFor = NumerotationAutoSQLElement.getLabelNumberFor(this.getElement().getClass());
                        int val = rowNum.getInt(labelNumberFor);
                        rowVals.put(labelNumberFor, (Object)(++val));
                        rowVals.update();
                    }
                } else if (JOptionPane.showConfirmDialog(this, "Attention en modifiant cette facture, vous supprimerez les ch\u00e9ques et les \u00e9ch\u00e9ances associ\u00e9s. Continuer?", "Modification de facture", 0) == 0) {
                    rowFactureOld = this.getTable().getRow(this.getSelectedID());
                    lFactureOld = ((Number)rowFactureOld.getObject("T_HT")).longValue();
                    super.update();
                    idSaisieVF = this.getSelectedID();
                } else {
                    return idSaisieVF;
                }
                rowFacture = this.getTable().getRow(idSaisieVF);
                ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
                this.tableFacture.updateField("ID_SAISIE_VENTE_FACTURE", idSaisieVF);
                this.tableFacture.createArticle(idSaisieVF, this.getElement());
                int idMvt = -1;
                if (!this.checkPrevisionnelle.isSelected()) {
                    SaisieVenteFactureSQLElement.DoWithRow doWithRow;
                    int idAvoir;
                    if (this.getMode() == SQLComponent.Mode.MODIFICATION && !rowFacture.isForeignEmpty("ID_MOUVEMENT")) {
                        idMvt = rowFacture.getInt("ID_MOUVEMENT");
                        System.err.println("Archivage des fils");
                        EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
                        eltEcr.archiveMouvementProfondeur(idMvt, false);
                    }
                    System.err.println("Regeneration des ecritures");
                    if (idMvt > 1) {
                        new GenerationMvtSaisieVenteFacture(idSaisieVF, idMvt);
                    } else {
                        new GenerationMvtSaisieVenteFacture(idSaisieVF);
                    }
                    System.err.println("Fin regeneration");
                    this.updateStock(idSaisieVF);
                    if (rowFactureOld != null && rowFactureOld.getInt("ID_AVOIR_CLIENT") > 1) {
                        SQLRow rowAvoir = rowFactureOld.getForeignRow("ID_AVOIR_CLIENT");
                        Long montantSolde = (Long)rowAvoir.getObject("MONTANT_SOLDE");
                        Long avoirTTC = (Long)rowFactureOld.getObject("T_AVOIR_TTC");
                        long montant = montantSolde - avoirTTC;
                        if (montant < 0L) {
                            montant = 0L;
                        }
                        SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
                        rowVals.put("SOLDE", Boolean.FALSE);
                        rowVals.put("MONTANT_SOLDE", montant);
                        Long restant = (Long)rowAvoir.getObject("MONTANT_TTC") - montantSolde;
                        rowVals.put("MONTANT_RESTANT", restant);
                        rowVals.update();
                    }
                    if ((idAvoir = rowFacture.getInt("ID_AVOIR_CLIENT")) > 1) {
                        SQLRow rowAvoir = rowFacture.getForeignRow("ID_AVOIR_CLIENT");
                        Long montantTTC = (Long)rowAvoir.getObject("MONTANT_TTC");
                        Long montantSolde = (Long)rowAvoir.getObject("MONTANT_SOLDE");
                        Long factTTC = (Long)rowFacture.getObject("T_TTC");
                        long restant = montantTTC - montantSolde;
                        SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
                        long l2 = factTTC - restant;
                        if (l2 >= 0L) {
                            rowVals.put("SOLDE", Boolean.TRUE);
                            rowVals.put("MONTANT_SOLDE", montantTTC);
                            rowVals.put("MONTANT_RESTANT", 0);
                        } else {
                            long m = montantSolde + factTTC;
                            rowVals.put("MONTANT_SOLDE", m);
                            rowVals.put("MONTANT_RESTANT", montantTTC - m);
                        }
                        rowVals.update();
                    }
                    if (this.getTable().getDBRoot().contains("ABONNEMENT") && this.panelOO.isCheckAboSelected() && (doWithRow = ((SaisieVenteFactureSQLElement)this.getElement()).getSpecialAction("subscription.autocreate")) != null) {
                        doWithRow.process(rowFacture);
                    }
                    this.createDocument(rowFacture);
                }
                if (attempt > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, "Le num\u00e9ro a \u00e9t\u00e9 actualis\u00e9 en " + num);
                        }
                    });
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle("", e);
            }
        }
        return idSaisieVF;
    }

    public void createDocument(SQLRow row) {
        VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(row);
        try {
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true, this.getElement(), row);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de g\u00e9n\u00e9rer la facture", e);
        }
    }

    @Override
    public void update() {
        this.commit(null);
    }

    public void loadDevis(int idDevis) {
        SQLElement devis = Configuration.getInstance().getDirectory().getElement("DEVIS");
        SQLElement devisElt = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
        if (idDevis > 1) {
            SQLInjector injector = SQLInjector.getInjector(devis.getTable(), this.getTable());
            SQLRow rowDevis = devis.getTable().getRow(idDevis);
            SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(idDevis);
            String string = rowDevis.getString("OBJET");
            createRowValuesFrom.put("NOM", String.valueOf(string) + (string.trim().length() == 0 ? "" : ",") + rowDevis.getString("NUMERO"));
            this.select(createRowValuesFrom);
        }
        this.loadItem(this.tableFacture, devis, idDevis, devisElt);
    }

    public void loadFactureExistante(int idFacture) {
        Collection myListItem;
        SQLElement fact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLElement factElt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        if (idFacture > 1) {
            SQLRow row = fact.getTable().getRow(idFacture);
            SQLRowValues rowVals = new SQLRowValues(fact.getTable());
            rowVals.put("ID_CLIENT", row.getInt("ID_CLIENT"));
            if (this.getTable().contains("ID_NUMEROTATION_AUTO")) {
                rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date(), row.getForeign("ID_NUMEROTATION_AUTO")));
            } else {
                rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()));
            }
            rowVals.put("NOM", row.getObject("NOM"));
            this.select(rowVals);
        }
        if ((myListItem = fact.getTable().getRow(idFacture).getReferentRows(factElt.getTable())).size() != 0) {
            this.tableFacture.getModel().clearRows();
            for (SQLRow rowElt : myListItem) {
                SQLRowValues rowVals = rowElt.createUpdateRow();
                rowVals.clearPrimaryKeys();
                this.tableFacture.getModel().addRow(rowVals);
                int rowIndex = this.tableFacture.getModel().getRowCount() - 1;
                this.tableFacture.getModel().fireTableModelModified(rowIndex);
            }
        } else {
            this.tableFacture.getModel().clearRows();
        }
        this.tableFacture.getModel().fireTableDataChanged();
        this.tableFacture.repaint();
    }

    public List<SQLRowValues> createFactureAcompte(int idFacture, long acompte) {
        SQLElement fact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLElement factElt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        if (idFacture > 1) {
            SQLRow row = fact.getTable().getRow(idFacture);
            SQLRowValues rowVals = new SQLRowValues(fact.getTable());
            rowVals.put("ID_CLIENT", row.getInt("ID_CLIENT"));
            rowVals.put("ID_AFFAIRE", row.getInt("ID_AFFAIRE"));
            rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()));
            rowVals.put("NOM", "Acompte de " + GestionDevise.currencyToString(acompte) + "\u20ac");
            this.select(rowVals);
        }
        Collection myListItem = fact.getTable().getRow(idFacture).getReferentRows(factElt.getTable());
        ArrayList<SQLRowValues> result = new ArrayList<SQLRowValues>(myListItem.size());
        if (myListItem.size() != 0) {
            this.tableFacture.getModel().clearRows();
            double acc = (double)acompte / (double)myListItem.size();
            long toAdd = 0L;
            SQLTable tablePourcentCCIP = Configuration.getInstance().getRoot().findTable("POURCENT_CCIP");
            for (SQLRow rowElt : myListItem) {
                SQLRowValues rowValsUp = rowElt.createUpdateRow();
                SQLRowValues rowVals = rowElt.createUpdateRow();
                rowVals.clearPrimaryKeys();
                long val = rowVals.getLong("T_PV_HT");
                double value = (acc + (double)toAdd) / (double)val * 100.0;
                if (value > 100.0) {
                    value = 100.0;
                    toAdd = (long)((double)toAdd + (acc - (double)val));
                } else {
                    toAdd = 0L;
                }
                BigDecimal pourcentAcompte = new BigDecimal((double)rowValsUp.getLong("POURCENT_ACOMPTE") - value);
                rowValsUp.put("POURCENT_ACOMPTE", pourcentAcompte);
                BigDecimal pourcentCurrentAcompte = new BigDecimal(value);
                rowVals.put("POURCENT_ACOMPTE", pourcentCurrentAcompte);
                Collection rowsCCIP = rowElt.getReferentRows(tablePourcentCCIP);
                if (rowsCCIP.size() > 0) {
                    SQLRowValues rowValsCCIP = ((SQLRow)rowsCCIP.get(0)).createUpdateRow();
                    rowValsCCIP.clearPrimaryKeys();
                    rowValsCCIP.put("ID_SAISIE_VENTE_FACTURE_ELEMENT", (Object)rowVals);
                    rowValsCCIP.put("NOM", "Acompte");
                    rowValsCCIP.put("POURCENT", pourcentCurrentAcompte);
                }
                System.err.println(value);
                this.tableFacture.getModel().addRow(rowVals);
                int rowIndex = this.tableFacture.getModel().getRowCount() - 1;
                this.tableFacture.getModel().fireTableModelModified(rowIndex);
            }
            if (toAdd > 0L) {
                int i = 0;
                while (i < this.tableFacture.getModel().getRowCount() && toAdd > 0L) {
                    SQLRowValues rowVals = this.tableFacture.getModel().getRowValuesAt(i);
                    if (rowVals.getFloat("POURCENT_ACOMPTE") < 100.0f) {
                        long val = rowVals.getLong("T_PV_HT");
                        double value = (acc + (double)toAdd) / (double)val * 100.0;
                        if (value > 100.0) {
                            value = 100.0;
                            toAdd = (long)((double)toAdd + (acc - (double)val));
                        } else {
                            toAdd = 0L;
                        }
                        rowVals.put("POURCENT_ACOMPTE", new BigDecimal(value));
                        this.tableFacture.getModel().fireTableModelModified(i);
                    }
                    ++i;
                }
            }
        } else {
            this.tableFacture.getModel().clearRows();
        }
        this.tableFacture.getModel().fireTableDataChanged();
        this.tableFacture.repaint();
        return result;
    }

    public void loadCommande(int idCmd) {
        SQLElement cmd = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        SQLElement cmdElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT_ELEMENT");
        if (idCmd > 1) {
            SQLInjector injector = SQLInjector.getInjector(cmd.getTable(), this.getTable());
            SQLRow rowCmd = cmd.getTable().getRow(idCmd);
            SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(idCmd);
            String string = rowCmd.getString("NOM");
            createRowValuesFrom.put("NOM", String.valueOf(string) + (string.trim().length() == 0 ? "" : ",") + rowCmd.getString("NUMERO"));
            this.select(createRowValuesFrom);
            this.listenerModeReglDefaut.propertyChange(null);
        }
        this.loadItem(this.tableFacture, cmd, idCmd, cmdElt);
    }

    public void loadBonItems(SQLRowAccessor rowBL, boolean clear) {
        SQLElement bon = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        SQLElement bonElt = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON_ELEMENT");
        this.loadItem(this.tableFacture, bon, rowBL.getID(), bonElt, clear);
    }

    public void addRowItem(SQLRowValues row) {
        this.tableFacture.getModel().addRow(row);
    }

    @Override
    public synchronized ValidState getValidState() {
        SQLRow clientSel = this.comboClient.getSelectedRow();
        if (clientSel != null && this.getTable().getForeignTable("ID_CLIENT").contains("VERROU_COMPTA") && clientSel.getBoolean("VERROU_COMPTA").booleanValue()) {
            return new ValidState(false, "Le client n'a pas \u00e9t\u00e9 v\u00e9rifi\u00e9 par la comptabilit\u00e9!");
        }
        return super.getValidState();
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRow taxeDefault;
        int idCompteVenteService;
        SQLRowValues vals = new SQLRowValues(this.getTable());
        try {
            SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow(true);
            if (r.getID() > 1) {
                SQLRowValues rowVals = eltModeReglement.createCopy(r, null);
                System.err.println(rowVals.getInt("ID_TYPE_REGLEMENT"));
                vals.put("ID_MODE_REGLEMENT", (Object)rowVals);
            }
        }
        catch (SQLException e) {
            System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
            e.printStackTrace();
        }
        this.tableFacture.getModel().clearRows();
        SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            vals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        Double d = prefs.getDouble(GestionCommercialeGlobalPreferencePanel.TAUX_TIMBRE_FISCAL, 1.0);
        vals.put("TAUX_TIMBRE_FISCAL", new BigDecimal(d));
        vals.put("TOTAL_TIMBRE_FISCAL", 0L);
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        if (this.getTable().contains("ID_NUMEROTATION_AUTO")) {
            vals.put("ID_NUMEROTATION_AUTO", this.defaultNum.getID());
            vals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date(), vals.getForeign("ID_NUMEROTATION_AUTO")));
        } else {
            vals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()));
        }
        int idCompteVenteProduit = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_PRODUIT");
        if (idCompteVenteProduit <= 1) {
            try {
                idCompteVenteProduit = ComptePCESQLElement.getIdComptePceDefault("VentesProduits");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        vals.put("ID_COMPTE_PCE_VENTE", idCompteVenteProduit);
        if (this.checkCT != null) {
            vals.put("CONTROLE_TECHNIQUE", this.checkCT.isSelected());
        }
        if (this.getTable().contains("CREATE_VIRTUAL_STOCK")) {
            vals.put("CREATE_VIRTUAL_STOCK", Boolean.TRUE);
        }
        if ((idCompteVenteService = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_SERVICE")) <= 1) {
            try {
                idCompteVenteService = ComptePCESQLElement.getIdComptePceDefault("VentesServices");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.getTable().contains("ID_TAXE_PORT")) {
            taxeDefault = TaxeCache.getCache().getFirstTaxe();
            vals.put("ID_TAXE_PORT", taxeDefault.getID());
        }
        if (this.getTable().contains("ID_TAXE_FRAIS_DOCUMENT")) {
            taxeDefault = TaxeCache.getCache().getFirstTaxe();
            vals.put("ID_TAXE_FRAIS_DOCUMENT", taxeDefault.getID());
        }
        vals.put("ID_COMPTE_PCE_SERVICE", idCompteVenteService);
        System.err.println("Defaults " + vals);
        return vals;
    }

    public void setDefaults() {
        this.resetValue();
        this.textNumeroUnique.setText(NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date(), this.defaultNum));
        this.tableFacture.getModel().clearRows();
    }

    public RowValuesTableModel getRowValuesTableModel() {
        return this.tableFacture.getModel();
    }

    @Deprecated
    public void setPrevisonnelle(boolean b) {
        this.checkPrevisionnelle.setSelected(b);
        if (!b) {
            this.textNumeroUnique.setText(NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), new Date()));
        }
    }

    public void setComplement(boolean b) {
        this.checkComplement.setSelected(b);
    }

    public void setAcompte(boolean b) {
        this.checkAcompte.setSelected(b);
        this.checkAcompte.firePropertyChange("ValueChanged", !b, b);
    }

    public void setTypeInterventionText(String text) {
        this.textTypeMission.setValue(text);
    }

    public void setReferenceClientText(String text) {
        this.refClient.setText(text);
    }

    protected String getLibelleStock(SQLRowAccessor row, SQLRowAccessor rowElt) {
        return "Saisie vente facture N\u00b0" + row.getString("NUMERO");
    }

    private void updateStock(int id) throws SQLException {
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) {
            SQLRow row = this.getTable().getRow(id);
            if (this.getTable().getForeignTable("ID_CLIENT").contains("NOTE_2018")) {
                Collection trCmd = row.getReferentRows(this.getTable().getTable("TR_COMMANDE_CLIENT"));
                if (!trCmd.isEmpty()) {
                    return;
                }
                Collection trBls = row.getReferentRows(this.getTable().getTable("TR_BON_DE_LIVRAISON"));
                if (!trBls.isEmpty()) {
                    return;
                }
            }
            StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

                @Override
                public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                    return SaisieVenteFactureSQLComponent.this.getLibelleStock(rowOrigin, rowElt);
                }
            }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(this.getTable().getTable("SAISIE_VENTE_FACTURE_ELEMENT")), this.getTable().contains("CREATE_VIRTUAL_STOCK") && row.getBoolean("CREATE_VIRTUAL_STOCK") != false ? StockItemsUpdater.TypeStockUpdate.REAL_VIRTUAL_DELIVER : StockItemsUpdater.TypeStockUpdate.REAL_DELIVER);
            stockUpdater.update();
        }
    }

    @Override
    protected RowValuesTable getRowValuesTable() {
        return this.tableFacture.getRowValuesTable();
    }

    @Override
    protected void refreshAfterSelect(SQLRowAccessor r) {
        this.tableFacture.setDateDevise(this.dateSaisie.getValue());
    }

    @Override
    protected void initDone() {
        super.initDone();
        if (this.getTable().contains("ID_AFFAIRE") && this.getView("ID_AFFAIRE") != null && this.getView("ID_AFFAIRE") instanceof SQLRequestComboBox) {
            final SQLRequestComboBox viewClient = (SQLRequestComboBox)this.getView("ID_CLIENT").getComp();
            final SQLRequestComboBox viewAffaire = (SQLRequestComboBox)this.getView("ID_AFFAIRE").getComp();
            final SQLRequestComboBox viewComm = (SQLRequestComboBox)this.getView("ID_COMMERCIAL").getComp();
            final SQLRequestComboBox viewAgence = this.getTable().contains("ID_POLE_PRODUIT") && (SQLRequestComboBox)((Object)this.getView("ID_POLE_PRODUIT")) != null ? (SQLRequestComboBox)this.getView("ID_POLE_PRODUIT").getComp() : null;
            viewAffaire.addModelListener("wantedID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SQLRow selAffaire;
                    if (!SaisieVenteFactureSQLComponent.this.isFilling() && (selAffaire = viewAffaire.getSelectedRow()) != null && !selAffaire.isUndefined()) {
                        viewClient.setValue(selAffaire.getForeignID("ID_CLIENT"));
                        if (selAffaire.getTable().contains("ID_COMMERCIAL")) {
                            viewComm.setValue(selAffaire.getForeignID("ID_COMMERCIAL"));
                        }
                    }
                }
            });
            if (viewAgence != null) {
                viewComm.addModelListener("wantedID", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SQLRow selComm;
                        if (!SaisieVenteFactureSQLComponent.this.isFilling() && (selComm = viewComm.getSelectedRow()) != null && !selComm.isUndefined() && selComm.getTable().contains("ID_POLE_PRODUIT")) {
                            viewAgence.setValue(selComm.getForeignID("ID_POLE_PRODUIT"));
                        }
                    }
                });
            }
        }
    }
}

