/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.model.PolymorphFK;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public abstract class RowBacked {
    private final SQLElement elem;
    private final SQLRowAccessor r;
    private final Map<String, ITransformer<? super SQLRowAccessor, ?>> propExtractors;
    private final Map<String, Object> values;

    @Deprecated
    public RowBacked(SQLRowAccessor r) {
        this(r, Configuration.getInstance().getDirectory().getElement(r.getTable()));
    }

    public RowBacked(SQLRowAccessor r, SQLElement elem) {
        elem.check(r);
        this.elem = elem;
        this.r = r instanceof SQLRow ? new SQLRow(r.getTable(), r.getAbsolutelyAll()) : ((SQLRowValues)r).toImmutable();
        this.propExtractors = new HashMap();
        this.values = new HashMap<String, Object>();
        for (PolymorphFK f : PolymorphFK.findPolymorphFK(this.getTable())) {
            this.addPolymorphFK(f);
        }
    }

    public final boolean hasGraph() {
        return this.getRow() instanceof SQLRowValues;
    }

    public final Object get(String propName) {
        Object res;
        if (this.values.containsKey(propName)) {
            return this.values.get(propName);
        }
        if (this.propExtractors.containsKey(propName)) {
            res = this.propExtractors.get(propName).transformChecked(this.getRow());
        } else {
            SQLElementLink ownedLink = this.getElement().getOwnedLink(propName);
            if (ownedLink != null) {
                List<Object> ownedRows;
                assert (!ownedLink.isJoin());
                List<Object> list = ownedRows = ownedLink.getOwned().canCreateModelObject() ? this.getOwnedObjects(ownedLink) : this.getOwnedRows(ownedLink);
                assert (ownedRows.size() <= 1) : "More than one row referenced by a field : " + ownedRows;
                res = CollectionUtils.getSole(ownedRows);
            } else {
                res = this.getRow().getContainedObject(propName);
            }
        }
        this.values.put(propName, res);
        return res;
    }

    protected final void putExtractor(String name, ITransformer<? super SQLRowAccessor, ?> extr) {
        this.propExtractors.put(name, extr);
    }

    protected final void addPolymorphFK(String name) {
        this.addPolymorphFK(new PolymorphFK(this.getTable(), name));
    }

    protected final void addPolymorphFK(final PolymorphFK fk) {
        this.putExtractor(fk.getName(), new PropExtractor(){

            @Override
            public Object transformChecked(SQLRowAccessor r) {
                SQLTable foreignT;
                String tableName = r.getString(fk.getTableField().getName());
                SQLTable sQLTable = foreignT = tableName == null ? null : r.getTable().getDBRoot().findTable(tableName);
                if (foreignT == null) {
                    return null;
                }
                int foreignID = r.getInt(fk.getIdField().getName());
                SQLElement foreignElem = RowBacked.this.getElement().getDirectory().getElement(foreignT);
                return RowBacked.this.getModelObject(foreignElem, foreignID);
            }
        });
    }

    public final List<SQLRowAccessor> getOwnedRows(SQLElementLink link) {
        return this.getOwnedRows(link, SQLRowAccessor.class);
    }

    public final <T extends SQLRowAccessor> List<T> getOwnedRows(SQLElementLink link, Class<T> clazz) {
        List<Object> ownedRows;
        if (link.getOwner() != this.getElement()) {
            throw new IllegalArgumentException("Wrong link " + link);
        }
        if (this.getRow() instanceof SQLRow) {
            if (!clazz.isAssignableFrom(SQLRow.class)) {
                throw new ClassCastException("Cannot cast SQLRow to " + clazz);
            }
            ownedRows = new ArrayList<SQLRow>();
            List<SQLRow> distantRows = ((SQLRow)this.getRow()).getDistantRowsList(link.getPath(), SQLSelect.ArchiveMode.UNARCHIVED);
            ownedRows.addAll(distantRows);
        } else {
            boolean isPrivate = link.getLinkType() == SQLElementLink.LinkType.COMPOSITION;
            Step lastStep = link.getPath().getStep(-1);
            assert (lastStep.isForeign().booleanValue());
            String lastFF = lastStep.getSingleField().getName();
            if (link.isJoin()) {
                ownedRows = new ArrayList();
                for (SQLRowValues withFK : ((SQLRowValues)this.getRow()).followPath(link.getPath().minusLast(), SQLRowValues.CreateMode.CREATE_NONE, false)) {
                    assert (!withFK.isForeignEmpty(lastFF)) : "Empty join row";
                    SQLRowAccessor ownedRow = withFK.getForeign(lastStep.getSingleLink());
                    assert (ownedRow != null);
                    assert (!isPrivate || ownedRow instanceof SQLRowValues) : "Incomplete private graph";
                    ownedRows.add((SQLRowAccessor)clazz.cast(ownedRow));
                }
            } else if (this.getRow().isForeignEmpty(lastFF)) {
                ownedRows = Collections.emptyList();
            } else {
                SQLRowAccessor foreign = this.getRow().getForeign(lastFF);
                ownedRows = Collections.singletonList((SQLRowAccessor)clazz.cast(foreign));
                assert (!isPrivate || foreign instanceof SQLRowValues) : "Incomplete private graph";
            }
        }
        return ownedRows;
    }

    public final List<Object> getOwnedObjects(SQLElementLink link) {
        return this.getOwnedObjects(link, Object.class);
    }

    public final <T> List<T> getOwnedObjects(SQLElementLink link, Class<T> clazz) {
        ArrayList<T> modelObjects;
        if (link.getOwner() != this.getElement()) {
            throw new IllegalArgumentException("Wrong link " + link);
        }
        if (!link.getOwned().canCreateModelObject()) {
            throw new IllegalStateException("Cannot create model objects, perhaps use getOwnedRows()");
        }
        List<SQLRowAccessor> ownedRows = this.getOwnedRows(link);
        if (this.hasGraph() && link.getLinkType() != SQLElementLink.LinkType.COMPOSITION) {
            ArrayList<Number> ids = new ArrayList<Number>();
            for (SQLRowAccessor r : ownedRows) {
                ids.add(r.getIDNumber());
            }
            modelObjects = new ArrayList<T>(link.getOwned().fetchModelObjects(ids, clazz).values());
        } else {
            modelObjects = new ArrayList<T>();
            for (SQLRowAccessor r : ownedRows) {
                modelObjects.add(clazz.cast(link.getOwned().getModelObject(r)));
            }
        }
        return modelObjects;
    }

    public final SQLTable getTable() {
        return this.getRow().getTable();
    }

    public final SQLBase getBase() {
        return this.getTable().getBase();
    }

    protected final SQLRowAccessor getRow() {
        return this.r;
    }

    public final SQLRowValues getSQLRowValues() {
        return (SQLRowValues)this.getRow();
    }

    public final SQLRow getSQLRow() {
        return this.getRow().asRow();
    }

    public final int getID() {
        return this.getRow().getID();
    }

    private final RowBacked getModelObject(SQLElement elem, Number id) {
        return (RowBacked)(this.hasGraph() ? elem.fetchModelObject(id) : elem.getModelObject(elem.getTable().getRow(id.intValue())));
    }

    public RowBacked getParent() {
        SQLElement parentElem = this.getElement().getParentLink().getParent();
        SQLRowValues parentID = this.getElement().fetchContainer(this.getRow());
        return this.getModelObject(parentElem, parentID.getIDNumber());
    }

    public final SQLElement getElement() {
        return this.elem;
    }

    protected static interface PropExtractor
    extends ITransformer<SQLRowAccessor, Object> {
    }
}

