/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.TotalAcompteProvider;
import org.openconcerto.erp.generationDoc.provider.TotalCommandeClientProvider;

public class RestantAReglerProvider
implements SpreadSheetCellValueProvider {
    final TotalAcompteProvider acompteProv;
    final TotalCommandeClientProvider cmdProvider;
    private final TypeRestantAReglerProvider type;

    public RestantAReglerProvider(TypeRestantAReglerProvider t) {
        this.type = t;
        if (this.type == TypeRestantAReglerProvider.HT) {
            this.acompteProv = new TotalAcompteProvider(TotalAcompteProvider.TypeTotalAcompteProvider.HT);
            this.cmdProvider = new TotalCommandeClientProvider(TotalCommandeClientProvider.TypeTotalCommandeClientProvider.HT);
        } else {
            this.acompteProv = new TotalAcompteProvider(TotalAcompteProvider.TypeTotalAcompteProvider.TTC);
            this.cmdProvider = new TotalCommandeClientProvider(TotalCommandeClientProvider.TypeTotalCommandeClientProvider.TTC);
        }
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        Object acompte = this.acompteProv.getValue(context);
        Object cmd = this.cmdProvider.getValue(context);
        if (acompte != null && cmd != null) {
            return ((BigDecimal)cmd).subtract((BigDecimal)acompte);
        }
        return null;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.account.due", new RestantAReglerProvider(TypeRestantAReglerProvider.HT));
        SpreadSheetCellValueProviderManager.put("sales.account.due.ttc", new RestantAReglerProvider(TypeRestantAReglerProvider.TTC));
    }

    private static enum TypeRestantAReglerProvider {
        HT,
        TTC;

    }
}

