/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.supplier.ui;

import java.awt.Color;
import java.awt.Component;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.utils.GestionDevise;

public class ListEcheanceFournRenderer
extends DefaultTableCellRenderer {
    private static final Color couleurEcheance = new Color(255, 128, 64);
    private final DateFormat dateFormat = DateFormat.getDateInstance(2);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected && value instanceof Date) {
            if (!((Date)value).after(new Date())) {
                this.setForeground(couleurEcheance);
            } else {
                this.setForeground(Color.BLACK);
            }
        }
        if (value instanceof Date) {
            this.setText(this.dateFormat.format((Date)value));
        }
        if (value != null && (table.getColumnClass(column) == Long.class || table.getColumnClass(column) == BigInteger.class) && value.getClass() == Long.class) {
            this.setText(GestionDevise.currencyToString((Long)value));
        }
        this.setHorizontalAlignment(4);
        if (table.getColumnClass(column) == String.class) {
            this.setHorizontalAlignment(2);
        }
        return this;
    }
}

