/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.DecimalUtils;

public class SaisieVenteFactureItemSQLElement
extends ComptaSQLConfElement {
    private final ComptaPropsConfiguration conf;

    public SaisieVenteFactureItemSQLElement(ComptaPropsConfiguration conf) {
        super(conf.getRootSociete().getTable("SAISIE_VENTE_FACTURE_ELEMENT"));
        this.conf = conf;
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("Transfert vers commande fournisseur"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLElement cmd = SaisieVenteFactureItemSQLElement.this.getDirectory().getElement("COMMANDE");
                EditFrame f = new EditFrame(cmd, EditPanel.EditMode.CREATION);
                f.getSQLComponent().select(SaisieVenteFactureItemSQLElement.this.transfertCommande(IListe.get(e).getSelectedRows()));
                f.setVisible(true);
            }
        }, false);
        action.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(action);
    }

    public final ComptaPropsConfiguration getConf() {
        return this.conf;
    }

    @Override
    protected String getParentFFName() {
        return "ID_SAISIE_VENTE_FACTURE";
    }

    public SQLRowValues transfertCommande(List<SQLRowValues> factItems) {
        SQLTable tableCmd = this.getDirectory().getElement("COMMANDE").getTable();
        SQLTable tableCmdElt = this.getDirectory().getElement("COMMANDE_ELEMENT").getTable();
        SQLRowValues rowCmd = new SQLRowValues(tableCmd);
        HashMap<Integer, SQLRowValues> map = new HashMap<Integer, SQLRowValues>();
        for (SQLRowAccessor sQLRowAccessor : factItems) {
            SQLRow sqlRowFetch = sQLRowAccessor.asRow();
            sqlRowFetch.fetchValues();
            if (sqlRowFetch.getObject("ID_ARTICLE") == null || sqlRowFetch.getForeign("ID_ARTICLE").isUndefined()) continue;
            int idArt = sqlRowFetch.getForeignID("ID_ARTICLE");
            if (map.containsKey(idArt)) {
                SQLRowValues rowValsElt = (SQLRowValues)map.get(idArt);
                rowValsElt.put("QTE", rowValsElt.getInt("QTE") + sqlRowFetch.getInt("QTE"));
                continue;
            }
            SQLInjector inj = SQLInjector.getInjector(sqlRowFetch.getForeign("ID_ARTICLE").getTable(), tableCmdElt);
            SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(sqlRowFetch.getForeign("ID_ARTICLE").asRow()));
            rowValsElt.put("ID_STYLE", sqlRowFetch.getObject("ID_STYLE"));
            rowValsElt.put("QTE", sqlRowFetch.getObject("QTE"));
            rowValsElt.put("T_POIDS", sqlRowFetch.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
            rowValsElt.put("T_PA_HT", ((BigDecimal)sqlRowFetch.getObject("PA_HT")).multiply(new BigDecimal(rowValsElt.getInt("QTE")), DecimalUtils.HIGH_PRECISION));
            rowValsElt.put("T_PA_TTC", ((BigDecimal)sqlRowFetch.getObject("T_PA_HT")).multiply(new BigDecimal((double)sqlRowFetch.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0), DecimalUtils.HIGH_PRECISION));
            rowValsElt.put("ID_COMMANDE", (Object)rowCmd);
            map.put(idArt, rowValsElt);
        }
        return rowCmd;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NIVEAU");
        l.add("CODE");
        l.add("NOM");
        l.add("PV_HT");
        l.add("ID_TAXE");
        l.add("POIDS");
        return l;
    }

    @Override
    protected synchronized void _initTableSource(SQLTableModelSource table) {
        super._initTableSource(table);
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add("CODE");
        s.add("NOM");
        s.add("PV_HT");
        s.add("POIDS");
        s.add("ID_TAXE");
        return super.getReadOnlyFields();
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_SAISIE_VENTE_FACTURE");
        l.add("CODE");
        l.add("NOM");
        l.add("DESCRIPTIF");
        String articleAdvanced = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bArticleAdvanced = Boolean.valueOf(articleAdvanced);
        if (bArticleAdvanced.booleanValue()) {
            l.add("PRIX_METRIQUE_VT_1");
            l.add("ID_MODE_VENTE_ARTICLE");
        }
        if (UserRightsManager.getCurrentUserRights().haveRight("CORPS_VOIR_PRIX_ACHAT")) {
            l.add("PA_HT");
        }
        l.add("PV_HT");
        l.add("QTE");
        if (this.getTable().contains("ID_ECO_CONTRIBUTION")) {
            l.add("ID_ECO_CONTRIBUTION");
            l.add("ECO_CONTRIBUTION");
            l.add("T_ECO_CONTRIBUTION");
        }
        l.add("T_PA_HT");
        l.add("T_PV_HT");
        l.add("T_PV_TTC");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            JTextField textCode;
            JTextField textNom;
            JTextField textMontantHT;
            JTextField textMontantHA;
            ElementComboBox comboTaxe;
            JTextField textPoids;
            JTextField textQte;
            {
                this.textCode = new JTextField();
                this.textNom = new JTextField();
                this.textMontantHT = new JTextField();
                this.textMontantHA = new JTextField();
                this.comboTaxe = new ElementComboBox();
                this.textPoids = new JTextField();
                this.textQte = new JTextField();
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelCode = new JLabel(this.getLabelFor("CODE"));
                c.weightx = 0.0;
                this.add((Component)labelCode, c);
                c.weightx = 1.0;
                ++c.gridx;
                this.textCode.setEditable(false);
                this.add((Component)this.textCode, c);
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
                c.weightx = 0.0;
                ++c.gridx;
                this.add((Component)labelNom, c);
                c.weightx = 1.0;
                ++c.gridx;
                this.textNom.setEditable(false);
                this.add((Component)this.textNom, c);
                JLabel labelMontantHT = new JLabel(this.getLabelFor("PV_HT"));
                c.weightx = 0.0;
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelMontantHT, c);
                c.weightx = 1.0;
                ++c.gridx;
                this.textMontantHT.setEditable(false);
                this.add((Component)this.textMontantHT, c);
                JLabel labelMontantHA = new JLabel(this.getLabelFor("PA_HT"));
                c.weightx = 0.0;
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelMontantHA, c);
                c.weightx = 1.0;
                ++c.gridx;
                this.add((Component)this.textMontantHA, c);
                ++c.gridx;
                c.weightx = 0.0;
                c.gridwidth = 0;
                this.comboTaxe.setEnabled(false);
                this.add((Component)this.comboTaxe, c);
                JLabel labelPoids = new JLabel(this.getLabelFor("POIDS"));
                c.weightx = 0.0;
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 1;
                this.add((Component)labelPoids, c);
                c.weightx = 1.0;
                ++c.gridx;
                this.textPoids.setEditable(false);
                this.add((Component)this.textPoids, c);
                JLabel labelQte = new JLabel(this.getLabelFor("QTE"));
                c.weightx = 0.0;
                ++c.gridx;
                this.add((Component)labelQte, c);
                c.weightx = 1.0;
                ++c.gridx;
                this.textQte.setEditable(false);
                this.add((Component)this.textQte, c);
                this.addRequiredSQLObject(this.textCode, "CODE");
                this.addRequiredSQLObject(this.textNom, "NOM");
                this.addRequiredSQLObject(this.textMontantHT, "PV_HT");
                this.addRequiredSQLObject(this.textMontantHA, "PA_HT");
                this.addSQLObject(this.textPoids, "POIDS");
                this.addSQLObject(this.textQte, "QTE");
                this.addRequiredSQLObject(this.comboTaxe, "ID_TAXE");
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                this.textCode.setEditable(false);
                this.textNom.setEditable(false);
                this.textMontantHT.setEditable(false);
                this.comboTaxe.setInteractionMode(InteractionMode.READ_ONLY);
                this.textPoids.setEditable(false);
                this.textQte.setEditable(false);
            }

            @Override
            public void update() {
                int id = this.getSelectedID();
                super.update();
                SQLRow row = this.getTable().getRow(id);
                SQLRowValues createEmptyUpdateRow = row.createEmptyUpdateRow();
                createEmptyUpdateRow.put("PRIX_METRIQUE_HA_1", row.getObject("PA_HT"));
                createEmptyUpdateRow.put("T_PA_HT", row.getObject("PA_HT"));
                try {
                    createEmptyUpdateRow.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".item";
    }
}

