/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.action.ImpressionGrandLivreAction;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.model.ConsultCompteModel;
import org.openconcerto.erp.core.finance.accounting.ui.EcritureGrandLivreRenderer;
import org.openconcerto.erp.element.objet.ClasseCompte;
import org.openconcerto.erp.element.objet.Compte;
import org.openconcerto.erp.element.objet.Ecriture;
import org.openconcerto.erp.model.LoadingTableListener;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.TableSorter;

public class GrandLivrePanel
extends JPanel {
    private JTabbedPane tabbedClasse;
    EventListenerList loadingListener = new EventListenerList();
    int nbLoading = 0;

    public GrandLivrePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        this.tabbedClasse = new JTabbedPane();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.add((Component)this.tabbedClasse, c);
        JButton buttonImpression = new JButton("PDF");
        JButton buttonClose = new JButton("Fermer");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)buttonImpression, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)buttonClose, c);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(GrandLivrePanel.this)).dispose();
            }
        });
        buttonImpression.addActionListener((ActionListener)((Object)new ImpressionGrandLivreAction()));
    }

    public void loadAsynchronous() {
        List<ClasseCompte> liste = ClasseCompte.getClasseCompte();
        if (!liste.isEmpty()) {
            int k = 0;
            while (k < liste.size()) {
                final ClasseCompte ccTmp = liste.get(k);
                this.fireLoading(true);
                new SwingWorker<JPanel, Object>(){

                    @Override
                    protected JPanel doInBackground() throws Exception {
                        return GrandLivrePanel.this.initClassePanel(ccTmp);
                    }

                    @Override
                    protected void done() {
                        try {
                            JPanel initClassePanel = (JPanel)this.get();
                            initClassePanel.setOpaque(false);
                            JScrollPane scrollPane = new JScrollPane(initClassePanel);
                            scrollPane.setOpaque(false);
                            scrollPane.setBorder(null);
                            scrollPane.getViewport().setOpaque(false);
                            GrandLivrePanel.this.tabbedClasse.addTab(ccTmp.getNom(), scrollPane);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("erreur " + ccTmp.getNom(), e);
                        }
                        GrandLivrePanel.this.fireLoading(false);
                        super.done();
                    }
                }.execute();
                ++k;
            }
        }
    }

    private JPanel initClassePanel(ClasseCompte cc) {
        JPanel panelTmp = new JPanel();
        long totalDebitClasse = 0L;
        long totalCreditClasse = 0L;
        panelTmp.setLayout(new GridBagLayout());
        panelTmp.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.fill = 2;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLTable ecritureTable = base.getTable("ECRITURE");
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(compteTable.getKey());
        sel.addSelect(compteTable.getField("NUMERO"));
        sel.addSelect(compteTable.getField("NOM"));
        sel.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        sel.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        String function = "REGEXP";
        String match = cc.getTypeNumeroCompte();
        if (Configuration.getInstance().getBase().getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
            function = "~";
        }
        Where w = new Where((FieldRef)compteTable.getField("NUMERO"), function, (Object)match);
        Where w2 = new Where((FieldRef)ecritureTable.getField("ID_COMPTE_PCE"), "=", compteTable.getKey());
        if (!UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
            w = w.and(new Where((FieldRef)ecritureTable.getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
        }
        sel.setWhere(w.and(w2));
        String req = String.valueOf(sel.asString()) + " GROUP BY \"COMPTE_PCE\".\"ID\",\"COMPTE_PCE\".\"NUMERO\",\"COMPTE_PCE\".\"NOM\" ORDER BY \"COMPTE_PCE\".\"NUMERO\"";
        System.out.println(req);
        List myList = (List)base.getDataSource().execute(req, new ArrayListHandler());
        JLabel labelTotalClasse = new JLabel();
        labelTotalClasse.setOpaque(false);
        if (!myList.isEmpty()) {
            int i = 0;
            while (i < myList.size()) {
                Object[] objTmp = (Object[])myList.get(i);
                Compte compteTmp = new Compte(((Number)objTmp[0]).intValue(), objTmp[1].toString(), objTmp[2].toString(), "", ((Number)objTmp[3]).longValue(), ((Number)objTmp[4]).longValue());
                c.fill = 2;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.gridx = 0;
                ++c.gridy;
                panelTmp.add((Component)this.creerComptePanel(compteTmp), c);
                totalDebitClasse += compteTmp.getTotalDebit();
                totalCreditClasse += compteTmp.getTotalCredit();
                ++i;
            }
            labelTotalClasse.setText("Total Classe " + cc.getNom() + " D\u00e9bit : " + GestionDevise.currencyToString(totalDebitClasse) + " Cr\u00e9dit : " + GestionDevise.currencyToString(totalCreditClasse));
        } else {
            labelTotalClasse.setHorizontalAlignment(0);
            labelTotalClasse.setText("Aucune \u00e9criture pour la classe " + cc.getNom());
        }
        ++c.gridy;
        c.weighty = 1.0;
        panelTmp.add((Component)labelTotalClasse, c);
        return panelTmp;
    }

    private JPanel creerComptePanel(final Compte compte) {
        final GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.fill = 0;
        c.anchor = 18;
        c.gridx = -1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        final JPanel panelCompte = new JPanel();
        panelCompte.setOpaque(false);
        panelCompte.setLayout(new GridBagLayout());
        panelCompte.setBorder(BorderFactory.createTitledBorder(String.valueOf(compte.getNumero()) + " " + compte.getNom()));
        JButton boutonShow = new JButton("+/-");
        boutonShow.setOpaque(false);
        boutonShow.setHorizontalAlignment(4);
        JLabel labelCompteDebit = new JLabel("Total Debit : " + GestionDevise.currencyToString(compte.getTotalDebit()));
        JLabel labelCompteCredit = new JLabel(" Credit : " + GestionDevise.currencyToString(compte.getTotalCredit()));
        labelCompteDebit.setHorizontalAlignment(2);
        labelCompteCredit.setHorizontalAlignment(2);
        JLabel labelTmp = new JLabel(String.valueOf(compte.getNumero()) + " " + compte.getNom());
        labelTmp.setHorizontalAlignment(2);
        panelCompte.add((Component)labelTmp, c);
        panelCompte.add((Component)labelCompteDebit, c);
        panelCompte.add((Component)labelCompteCredit, c);
        c.weightx = 1.0;
        c.anchor = 12;
        panelCompte.add((Component)boutonShow, c);
        boutonShow.addActionListener(new ActionListener(){
            private boolean isShow = false;
            private JScrollPane scroll = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.isShow) {
                    JTable tableCpt = GrandLivrePanel.this.createJTableCompte(compte);
                    if (tableCpt == null) {
                        JOptionPane.showMessageDialog(GrandLivrePanel.this, "Aucune \u00e9criture");
                        return;
                    }
                    this.scroll = new JScrollPane(tableCpt);
                    Dimension d = tableCpt.getPreferredSize().height > 200 ? new Dimension(this.scroll.getPreferredSize().width, 200) : new Dimension(this.scroll.getPreferredSize().width, tableCpt.getPreferredSize().height + 30);
                    this.scroll.setPreferredSize(d);
                    ++c.gridy;
                    c.gridwidth = 4;
                    c.weightx = 1.0;
                    c.fill = 2;
                    c.anchor = 18;
                    panelCompte.add((Component)this.scroll, c);
                } else {
                    if (this.scroll != null) {
                        panelCompte.remove(this.scroll);
                    }
                    panelCompte.repaint();
                    panelCompte.revalidate();
                }
                this.isShow = !this.isShow;
                SwingUtilities.getRoot(panelCompte).repaint();
            }
        });
        return panelCompte;
    }

    private JTable createJTableCompte(Compte compte) {
        final JTable tableTmp = this.creerJTable(compte);
        if (tableTmp != null) {
            EcritureGrandLivreRenderer ecritureRenderer = new EcritureGrandLivreRenderer((TableSorter)tableTmp.getModel());
            int j = 0;
            while (j < tableTmp.getColumnCount()) {
                tableTmp.getColumnModel().getColumn(j).setCellRenderer(ecritureRenderer);
                ++j;
            }
            tableTmp.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(final MouseEvent mE) {
                    if (mE.getButton() == 3) {
                        JPopupMenu menuDroit = new JPopupMenu();
                        menuDroit.add(new AbstractAction("Voir la source"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                int row = tableTmp.rowAtPoint(mE.getPoint());
                                TableSorter s = (TableSorter)tableTmp.getModel();
                                int modelIndex = s.modelIndex(row);
                                ConsultCompteModel consultCompteModel = (ConsultCompteModel)s.getTableModel();
                                Ecriture ecriture = consultCompteModel.getEcritures().get(modelIndex);
                                MouvementSQLElement.showSource(ecriture.getIdMvt());
                            }
                        });
                        menuDroit.show(mE.getComponent(), mE.getX(), mE.getY());
                    }
                }
            });
        }
        return tableTmp;
    }

    private JTable creerJTable(Compte compte) {
        ConsultCompteModel model = new ConsultCompteModel(compte);
        TableSorter s = new TableSorter(model);
        JTable tableTmp = new JTable(s);
        s.setTableHeader(tableTmp.getTableHeader());
        if (model.getEcritures() != null) {
            return tableTmp;
        }
        return null;
    }

    public void addLoadingListener(LoadingTableListener l) {
        this.loadingListener.add(LoadingTableListener.class, l);
    }

    public void fireLoading(boolean isLoading) {
        this.nbLoading = isLoading ? ++this.nbLoading : --this.nbLoading;
        LoadingTableListener[] loadingTableListenerArray = (LoadingTableListener[])this.loadingListener.getListeners(LoadingTableListener.class);
        int n = loadingTableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LoadingTableListener l = loadingTableListenerArray[n2];
            l.isLoading(this.nbLoading > 0);
            ++n2;
        }
    }
}

