/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openconcerto.ui.component.ComponentWrapper;
import org.openconcerto.ui.table.IAlternateTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererDecorator;

public class AlternateTableCellRenderer
extends TableCellRendererDecorator {
    private static final Color COLOR_LIGHT_GRAY = new Color(233, 237, 243);
    private static final Color DEFAULT_BG_COLOR = Color.WHITE;
    private static Map<Color, Color> DEFAULT_MAP;
    private static final String ODD_BG_COLOR_MAP_PROP;
    private static final ProxyComp altComp;
    public static final TableCellRendererDecorator.TableCellRendererDecoratorUtils<AlternateTableCellRenderer> UTILS;
    private static final PropertyChangeListener RENDERER_L;

    static {
        AlternateTableCellRenderer.setDefaultMap(null);
        ODD_BG_COLOR_MAP_PROP = String.valueOf(AlternateTableCellRenderer.class.getSimpleName()) + " odd background colour map";
        altComp = new ProxyComp();
        UTILS = AlternateTableCellRenderer.createUtils(AlternateTableCellRenderer.class);
        RENDERER_L = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("cellRenderer".equals(evt.getPropertyName())) {
                    UTILS.setRenderer((TableColumn)evt.getSource());
                }
            }
        };
    }

    public static void setDefaultMap(Map<Color, Color> m) {
        DEFAULT_MAP = m == null ? Collections.singletonMap(DEFAULT_BG_COLOR, COLOR_LIGHT_GRAY) : Collections.unmodifiableMap(new HashMap<Color, Color>(m));
    }

    public static void setBGColorMap(JComponent comp, Color evenColor, Color oddColor) {
        AlternateTableCellRenderer.setBGColorMap(comp, Collections.singletonMap(evenColor, oddColor));
    }

    public static void setBGColorMap(JComponent comp, Map<Color, Color> m) {
        comp.putClientProperty(ODD_BG_COLOR_MAP_PROP, m);
    }

    private static Map<Color, Color> getBGColorMap(JComponent comp) {
        return (Map)comp.getClientProperty(ODD_BG_COLOR_MAP_PROP);
    }

    private static Color computeAlternateColor(Color c) {
        return new Color((int)((double)c.getRed() * 0.9), (int)((double)c.getGreen() * 0.9), (int)((double)c.getBlue() * 0.9));
    }

    public static Color getAlternateColor(Color c) {
        return AlternateTableCellRenderer.getAlternateColor(c, DEFAULT_MAP);
    }

    private static Color getAlternateColor(Color c, Map<Color, Color> oddColorMap) {
        Color res = oddColorMap.get(c);
        if (res != null) {
            return res;
        }
        if (oddColorMap != DEFAULT_MAP) {
            return AlternateTableCellRenderer.getAlternateColor(c, DEFAULT_MAP);
        }
        return AlternateTableCellRenderer.computeAlternateColor(c);
    }

    public static final void setRendererAndListen(TableColumn col) {
        col.removePropertyChangeListener(RENDERER_L);
        AlternateTableCellRenderer.setRenderer(col);
        col.addPropertyChangeListener(RENDERER_L);
    }

    public static final void setRenderer(TableColumn col) {
        UTILS.setRenderer(col);
    }

    public static AlternateTableCellRenderer createDefault() {
        return new AlternateTableCellRenderer(new DefaultTableCellRenderer());
    }

    public AlternateTableCellRenderer() {
        this(null);
    }

    public AlternateTableCellRenderer(TableCellRenderer renderer) {
        super(renderer);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer tableRenderer = this.getRenderer(table, column);
        if (tableRenderer instanceof IAlternateTableCellRenderer) {
            return ((IAlternateTableCellRenderer)tableRenderer).getAlternateTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        Component comp = tableRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected || row % 2 == 0) {
            return comp;
        }
        return altComp.setComp(comp);
    }

    private static final class ProxyComp
    extends JComponent
    implements ComponentWrapper.I {
        private Component comp;
        private JComponent jComp;
        private Map<Color, Color> oddBGColorMap;

        private ProxyComp() {
        }

        public ProxyComp setComp(Component comp) {
            if (this.comp != comp) {
                this.comp = comp;
                this.jComp = comp instanceof JComponent ? (JComponent)comp : null;
            }
            Map jCompMap = this.jComp == null ? null : AlternateTableCellRenderer.getBGColorMap(this.jComp);
            this.oddBGColorMap = jCompMap == null ? DEFAULT_MAP : jCompMap;
            return this;
        }

        @Override
        public Component getComponent() {
            return this.comp;
        }

        private Color getAlternateColor(Color c) {
            return AlternateTableCellRenderer.getAlternateColor(c, this.oddBGColorMap);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getComponent().getPreferredSize();
        }

        @Override
        public void paint(Graphics g) {
            Color origBG = this.comp.getBackground();
            Color altBG = this.getAlternateColor(origBG);
            boolean wasDoubleBuffered = false;
            if (this.jComp != null && this.jComp.isDoubleBuffered()) {
                wasDoubleBuffered = true;
                this.jComp.setDoubleBuffered(false);
            }
            if (this.getWidth() != this.comp.getWidth() || this.getHeight() != this.comp.getHeight()) {
                this.comp.setSize(this.getWidth(), this.getHeight());
                this.comp.doLayout();
            }
            this.comp.setBackground(altBG);
            this.comp.paint(g);
            this.comp.setBackground(origBG);
            if (wasDoubleBuffered) {
                this.jComp.setDoubleBuffered(true);
            }
        }
    }
}

