/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.grid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class TwoYearsHeaderPanel
extends JPanel {
    private int year;
    private String[] months = new String[]{"Janv.", "F\u00e9v.", "Mars", "Avr.", "Mai", "Juin", "Juil.", "Ao\u00fbt", "Sept.", "Oct.", "Nov.", "D\u00e9c."};

    public TwoYearsHeaderPanel(int year) {
        this.year = year;
        this.setBackground(Color.white);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(g.getFont().deriveFont(1));
        int x1 = this.getWidth() / 4;
        int x2 = 3 * this.getWidth() / 4;
        String str1 = String.valueOf(this.year);
        int w1 = g.getFontMetrics().stringWidth(str1);
        g.drawString(str1, x1 - w1 / 2, 16);
        String str2 = String.valueOf(this.year + 1);
        int w2 = g.getFontMetrics().stringWidth(str2);
        g.drawString(str2, x2 - w2 / 2, 16);
        int gw = this.getWidth() / 24;
        g.setColor(Color.LIGHT_GRAY);
        int x = 0;
        while (x < this.getWidth()) {
            g.drawLine(x, 36, x, this.getHeight());
            x += gw * 3;
        }
        g.setColor(Color.GRAY);
        x = 0;
        while (x < this.getWidth()) {
            g.drawLine(x, 24, x, this.getHeight());
            x += gw * 6;
        }
        g.setColor(Color.BLACK);
        x = 0;
        while (x < this.getWidth()) {
            g.drawLine(x, 0, x, this.getHeight());
            x += gw * 12;
        }
        g.setFont(g.getFont().deriveFont(0));
        int delta = this.getWidth() / 2;
        int i = 0;
        while (i < 12) {
            String str = this.months[i];
            int w = g.getFontMetrics().stringWidth(str2);
            int x3 = i * gw + gw / 2 - w / 2;
            g.drawString(str, x3, 40);
            g.drawString(str, x3 += delta, 40);
            ++i;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.getPreferredSize().width, 48);
    }
}

