/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.TransfFieldExpander;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.IFieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

final class ComboSQLRequestUtils {
    ComboSQLRequestUtils() {
    }

    private static Tuple2<SQLRowValues, List<FieldPath>> expandOnce(SQLRowValues vals, IFieldPath field) {
        assert (vals.getFields().contains(field.getFieldName()));
        Object foreignObj = vals.getObject(field.getFieldName());
        if (!(foreignObj instanceof SQLRowValues)) {
            return Tuple2.create(null, Collections.emptyList());
        }
        SQLRowValues foreign = (SQLRowValues)foreignObj;
        Path newPath = (Path)field.getPath().add(field.getField(), Link.Direction.FOREIGN);
        ArrayList<FieldPath> res = new ArrayList<FieldPath>();
        for (String f : foreign.getFields()) {
            res.add(new FieldPath(newPath, f));
        }
        return Tuple2.create(foreign, res);
    }

    public static final List<FieldPath> expand(SQLRowValues vals, IFieldPath field) {
        assert (vals.getTable() == field.getTable());
        ArrayList<FieldPath> fields = new ArrayList<FieldPath>();
        if (!field.getTable().getForeignKeys().contains(field.getField())) {
            fields.add(field.getFieldPath());
        } else {
            Tuple2<SQLRowValues, List<FieldPath>> tmp = ComboSQLRequestUtils.expandOnce(vals, field);
            for (FieldPath f : tmp.get1()) {
                fields.addAll(ComboSQLRequestUtils.expand(tmp.get0(), f));
            }
        }
        return fields;
    }

    public static final List<Tuple2<Path, List<FieldPath>>> expandGroupBy(SQLRowValues vals, SQLElementDirectory dir) {
        return ComboSQLRequestUtils.expandGroupBy(new Path(vals.getTable()), vals, dir);
    }

    private static final List<Tuple2<Path, List<FieldPath>>> expandGroupBy(Path fieldsPath, SQLRowValues vals, SQLElementDirectory dir) {
        assert (fieldsPath.getLast() == vals.getTable());
        if (vals.size() == 0) {
            return Collections.emptyList();
        }
        SQLElement element = dir.getElement(fieldsPath.getLast());
        SQLField parentFF = element == null ? null : element.getParentForeignField();
        ArrayList<Tuple2<Path, List<FieldPath>>> res = new ArrayList<Tuple2<Path, List<FieldPath>>>();
        ArrayList<FieldPath> currentL = new ArrayList<FieldPath>();
        res.add(Tuple2.create(fieldsPath, currentL));
        SQLRowValues parent = null;
        for (String f : vals.getFields()) {
            if (parentFF != null && f.equals(parentFF.getName())) {
                Object val = vals.getObject(f);
                parent = val instanceof SQLRowValues ? (SQLRowValues)val : null;
                continue;
            }
            currentL.addAll(ComboSQLRequestUtils.expand(vals, new FieldPath(fieldsPath, f)));
        }
        if (parent != null) {
            res.addAll(ComboSQLRequestUtils.expandGroupBy((Path)fieldsPath.add(parentFF, Link.Direction.FOREIGN), parent, dir));
        }
        return res;
    }

    public static final TransfFieldExpander getShowAs(final SQLElementDirectory dir) {
        TransfFieldExpander exp = new TransfFieldExpander(new ITransformer<SQLField, List<SQLField>>(){

            @Override
            public List<SQLField> transformChecked(SQLField fk) {
                SQLTable foreignTable = fk.getDBSystemRoot().getGraph().getForeignTable(fk);
                return dir.getElement(foreignTable).getComboRequest().getFields();
            }
        });
        return exp;
    }
}

