/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.EnumSet;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.AlterTable;

public class ConvertToNullDate
extends Changer<SQLTable> {
    public ConvertToNullDate(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected EnumSet<SQLSystem> getCompatibleSystems() {
        return EnumSet.of(SQLSystem.MYSQL);
    }

    @Override
    protected void changeImpl(SQLTable t) throws SQLException {
        for (SQLField f : t.getFields()) {
            if (f.getType().getType() != 91 && f.getType().getType() != 93) continue;
            this.getStream().println(f.getType() + ": " + f);
            if (f.isNullable() != Boolean.TRUE || f.getDefaultValue() != null) {
                AlterTable alterColumn = new AlterTable(t).alterColumn(f.getName(), EnumSet.of(SQLField.Properties.DEFAULT, SQLField.Properties.NULLABLE), null, "NULL", true);
                this.getDS().execute(alterColumn.asString());
            }
            String nullValue = f.getType().getType() == 91 ? "0000-00-00" : "0000-00-00 00:00:00";
            this.getDS().execute(t.getBase().quote("UPDATE %f SET %n = NULL WHERE %n = '" + nullValue + "'", f.getTable(), f, f));
        }
    }
}

