/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.jdom2.JDOMException;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Client;
import org.openconcerto.erp.core.sales.pos.model.DBState;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.RegisterDB;
import org.openconcerto.erp.core.sales.pos.model.RegisterFiles;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.model.TicketItem;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSelectionListener;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSelectorDialogPanel;
import org.openconcerto.erp.core.sales.pos.ui.CBPanel;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseMenuPanel;
import org.openconcerto.erp.core.sales.pos.ui.CaissePanel;
import org.openconcerto.erp.core.sales.pos.ui.ListeDesClientsPanel;
import org.openconcerto.erp.core.sales.pos.ui.ListeDesTicketsPanel;
import org.openconcerto.erp.core.sales.pos.ui.POSGlassPane;
import org.openconcerto.erp.core.sales.pos.ui.PostalCodeEditorPanel;
import org.openconcerto.erp.core.sales.pos.ui.PriceEditorPanel;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.RemoteShell;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.utils.ClassPathLoader;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ExnTransformer;

public class CaisseFrame
extends JFrame {
    private final POSConfiguration posConf;
    private final ComptaPropsConfiguration conf;
    private final RegisterFiles files;
    private final RegisterDB registerDB;
    final CaissePanel mainPanel;
    private static final String unknownTK = "unknown";
    private static final String open_datesMismatch = "open.datesMismatch";
    private static final String localOpen_remoteClosed = "localOpen_remoteClosed";
    private static final String localOpen_remoteMissing = "localOpen_remoteMissing";
    private static final String localMissing_remoteReopen = "localMissing_remoteReopen";
    private static final String localOpenFailed_remoteOpen = "localOpenFailed_remoteOpen";
    private static final String localClosed_remoteCloseFailed = "localClosed_remoteCloseFailed";
    private static final String localClosed_remoteOpen_datesMismatch = "localClosed_remoteOpen.datesMismatch";
    private static final String localMissing_remoteClosed = "localMissing_remoteClosed";
    private static final String closed_datesMismatch = "closed.datesMismatch";
    private static final String localClosed_remoteMissing = "localClosed_remoteMissing";

    CaisseFrame(POSConfiguration posConf, ComptaPropsConfiguration conf, RegisterFiles files, RegisterDB registerDB) throws Exception {
        this.posConf = posConf;
        this.conf = conf;
        this.files = files;
        this.registerDB = registerDB;
        this.mainPanel = new CaissePanel(this);
        this.setContentPane(this.mainPanel);
        this.setFocusable(true);
    }

    public final POSConfiguration getPOSConf() {
        return this.posConf;
    }

    public final ComptaPropsConfiguration getConf() {
        return this.conf;
    }

    public final RegisterFiles getFiles() {
        return this.files;
    }

    public final RegisterDB getDB() {
        return this.registerDB;
    }

    public static void main(String[] args) {
        System.setProperty("SQLRowAccessor.accessDBIfNeeded", "true");
        try {
            RegisterState reconciledState;
            System.out.println("Lancement du module de caisse");
            ToolTipManager.sharedInstance().setInitialDelay(0);
            RemoteShell.startDefaultInstance(null, null);
            System.setProperty("redirectToFile", "true");
            System.setProperty("org.openconcerto.sql.identifier.allowRemoval", "true");
            ExceptionHandler.setForceUI(true);
            ExceptionHandler.setForumURL("http://www.openconcerto.org/forum");
            ExceptionHandler.setThrowableHandler(Gestion.createDefaultThrowableHandler());
            System.setProperty("sun.java2d.pmoffscreen", "false");
            System.setProperty("org.openconcerto.sql.structure.useXML", "true");
            System.setProperty("redirectToFile", "true");
            final POSConfiguration posConf = POSConfiguration.setInstance();
            if (posConf.isUsingJPos()) {
                ClassPathLoader c = ClassPathLoader.getInstance();
                try {
                    List<String> posDirectories = posConf.getJPosDirectories();
                    for (String posDirectory : posDirectories) {
                        if (posDirectory == null || posDirectory.trim().isEmpty()) continue;
                        c.addJarFromDirectory(new File(posDirectory.trim()));
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                c.load();
            }
            final ComptaPropsConfiguration conf = posConf.createConnexion();
            TM erpTM = conf.getERP_TM();
            int userID = posConf.getUserID();
            int posID = posConf.getPosID();
            final RegisterFiles registerFiles = new RegisterFiles(posConf.getRootDir(), true, posConf.getPosID());
            final RegisterDB registerDB = new RegisterDB(conf.getDirectory(), conf.getProductInfo(), posConf.getPosID());
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(new SQLRowValues(registerDB.getRegisterTable()));
            if (fetcher.fetchOne(posID) == null) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, erpTM.translate("register.missing", posID), erpTM.translate("register.missing.title", new Object[0]), 0));
                posConf.closeConnexion();
                return;
            }
            boolean quit = registerDB.fetchRegisterState().checkIfMoved(erpTM);
            if (quit) {
                CaisseFrame.quit(posConf);
                return;
            }
            Logger logger = POSConfiguration.getLogger();
            try {
                reconciledState = registerFiles.doWithLock(new ExnTransformer<RegisterFiles, RegisterState, Exception>(){

                    @Override
                    public RegisterState transformChecked(RegisterFiles input) throws Exception {
                        return CaisseFrame.reconcileFSandDB(posConf, conf.getDirectory(), input, registerDB);
                    }
                });
            }
            catch (ReconcileException re) {
                String generalMsg;
                logger.log(Level.WARNING, "States couldn\u2019t be reconciled, local : " + re.getLocalState() + ", remote : " + re.getRemoteState(), re);
                boolean onlyOptionPane = false;
                if (re instanceof OutsideMeddlingException) {
                    generalMsg = String.valueOf(erpTM.translate("register.notReconciled.outsideMeddling", new Object[0])) + '\n';
                    onlyOptionPane = true;
                } else {
                    generalMsg = re instanceof ResumeException ? String.valueOf(erpTM.translate("register.notReconciled.resumeFailed", new Object[0])) + '\n' : "";
                }
                String message = erpTM.trM("register.notReconciled." + re.getTranslationKey(), "localDate", re.getLocalState().copyDate(), "remoteDate", re.getRemoteState().copyDate());
                if (onlyOptionPane) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, String.valueOf(generalMsg) + message, erpTM.translate("register.notReconciled.title", new Object[0]), 0));
                } else {
                    ExceptionHandler.handle(String.valueOf(generalMsg) + message, re);
                }
                posConf.closeConnexion();
                return;
            }
            catch (Exception e) {
                throw new IOException("Couldn't reconcile local and remote state", e);
            }
            logger.log(Level.INFO, "FS and DB states reconciled : {0}", reconciledState);
            System.setProperty("awt.useSystemAAFontSettings", "on");
            System.setProperty("swing.aatext", "true");
            System.setProperty("org.openconcerto.sql.comboCanModify", "true");
            RegisterState state = reconciledState;
            if (reconciledState.getStatus() == RegisterState.Status.CLOSED) {
                FutureTask<Boolean> askUserCallable = new FutureTask<Boolean>(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int ans = JOptionPane.showConfirmDialog(null, "La caisse n\u2019est pas ouverte, voulez-vous l\u2019ouvrir ?", "Caisse ferm\u00e9e", 0);
                        if (ans == 0) {
                            return true;
                        }
                        return false;
                    }
                });
                SwingUtilities.invokeLater(askUserCallable);
                boolean userAgreed = askUserCallable.get();
                if (userAgreed) {
                    RegisterLog newLog = registerFiles.open(userID, registerDB);
                    state = newLog.getRegisterState();
                }
            }
            if (state.getStatus() != RegisterState.Status.OPEN) {
                logger.log(Level.FINE, "State not open ({0}), exiting", state);
                posConf.closeConnexion();
                return;
            }
            logger.log(Level.INFO, "FS and DB states open, opening UI");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        CaisseFrame f = new CaisseFrame(posConf, conf, registerFiles, registerDB);
                        f.setUndecorated(true);
                        f.setDefaultCloseOperation(3);
                        f.pack();
                        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                            f.setLocation(0, 24);
                        } else {
                            f.setLocation(0, 0);
                        }
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        if (posConf.getScreenWidth() > 0 && posConf.getScreenHeight() > 0) {
                            f.setSize(new Dimension(posConf.getScreenWidth() - f.getX(), posConf.getScreenHeight() - f.getY()));
                        } else {
                            f.setSize(new Dimension(screenSize.getSize().width - f.getX(), screenSize.getSize().height - f.getY()));
                        }
                        System.out.println("Affichage de l'interface");
                        f.setVisible(true);
                        if (screenSize.getWidth() < 1024.0 || screenSize.getHeight() < 720.0) {
                            JOptionPane.showMessageDialog(f, "La r\u00e9solution de votre \u00e9cran est trop faible.\nLa largeur doit \u00eatre au minium de 1024 pixels.\nLa hauteur doit \u00eatre au minium de 720 pixels.");
                        }
                    }
                    catch (Throwable e) {
                        ExceptionHandler.handle("Erreur d'initialisation de la caisse (main)", e);
                    }
                }
            });
        }
        catch (Throwable e) {
            ExceptionHandler.handle("Erreur d'initialisation de la caisse", e);
        }
    }

    private static RegisterState reconcileFSandDB(POSConfiguration posConf, SQLElementDirectory dir, RegisterFiles files, RegisterDB registerDB) throws IOException, JDOMException, ParseException, SQLException {
        RegisterState remoteState;
        RegisterState localState;
        block29: {
            EnumSet<RegisterState.Status> validStatus;
            List<File> remainingReceipts;
            RegisterLog lastLog = files.getLastLog();
            POSConfiguration.getLogger().log(Level.CONFIG, "Found last log {0}", lastLog);
            localState = lastLog == null ? new RegisterState((remainingReceipts = ReceiptCode.getReceiptsToImport(files.getPosID())).isEmpty() ? RegisterState.Status.CLOSED : RegisterState.Status.OBSOLETE, null) : lastLog.getRegisterState();
            POSConfiguration.getLogger().log(Level.CONFIG, "FS state {0}", localState);
            DBState fetchedState = registerDB.fetchRegisterState();
            remoteState = fetchedState.getRegisterState();
            POSConfiguration.getLogger().log(Level.CONFIG, "DB state {0}", fetchedState);
            if (localState.getStatus() == RegisterState.Status.OBSOLETE) {
                if (remoteState.hasDate()) {
                    throw new IllegalStateException("There remains obsolete receipts but DB can no longer import them : " + remoteState);
                }
                List<Ticket> allTickets = posConf.allTickets();
                POSConfiguration.getLogger().log(Level.INFO, "{0} obsolete receipt(s) will be stored in the DB", allTickets.size());
                posConf.commitAll(allTickets);
                List<File> remainingReceipts2 = ReceiptCode.getReceiptsToImport(files.getPosID());
                if (!remainingReceipts2.isEmpty()) {
                    throw new IllegalStateException("Not all obsolete receipts could be imported : " + remainingReceipts2);
                }
                localState = new RegisterState(RegisterState.Status.CLOSED, null);
                POSConfiguration.getLogger().log(Level.FINE, "All obsolete receipts have been stored in the DB");
            }
            if (!(validStatus = EnumSet.of(RegisterState.Status.OPEN, RegisterState.Status.CLOSED)).contains((Object)localState.getStatus())) {
                throw new IllegalStateException("Unexpected local status :" + localState);
            }
            if (!validStatus.contains((Object)remoteState.getStatus())) {
                throw new IllegalStateException("Unexpected remote status :" + remoteState);
            }
            if (!localState.equals(remoteState)) {
                POSConfiguration.getLogger().log(Level.INFO, "Different FS and DB state, will try to reconcile\nFS " + localState + " with\nDB " + remoteState);
                int userID = posConf.getUserID();
                boolean localOpen = localState.getStatus() == RegisterState.Status.OPEN;
                boolean remoteOpen = remoteState.getStatus() == RegisterState.Status.OPEN;
                try {
                    if (localOpen) {
                        if (remoteOpen) {
                            throw new OutsideMeddlingException("Both open with but with different dates", open_datesMismatch);
                        }
                        throw new OutsideMeddlingException("local is open but the DB isn't", remoteState.hasDate() ? localOpen_remoteClosed : localOpen_remoteMissing);
                    }
                    if (remoteOpen) {
                        Date lastClosureDate;
                        assert (remoteState.hasDate()) : "Remote state open without date : " + remoteState;
                        SQLRowValues lastClosure = fetchedState.getLastClosureEntry();
                        Date date = lastClosureDate = lastClosure == null ? null : lastClosure.getDate("DATE").getTime();
                        if (!localState.hasDate()) {
                            if (lastClosureDate != null) {
                                throw new OutsideMeddlingException("DB was closed and now open, but local log is missing", localMissing_remoteReopen);
                            }
                            try {
                                localState = files.open(userID, fetchedState).getRegisterState();
                                break block29;
                            }
                            catch (Exception e) {
                                throw new ResumeException("The local opening (following the already open DB) failed", localOpenFailed_remoteOpen, e);
                            }
                        }
                        if (remoteState.compareDateTo(lastLog.getFirstRegisterEvent().getDate()) == 0) {
                            try {
                                remoteState = registerDB.close(posConf, files.getLastLog()).getRegisterState();
                                break block29;
                            }
                            catch (Exception e) {
                                throw new ResumeException("The closure of the DB (following the already closed local) failed", localClosed_remoteCloseFailed, e);
                            }
                        }
                        if (lastClosureDate != null && localState.compareDateTo(lastClosureDate) == 0) {
                            try {
                                localState = files.open(userID, fetchedState).getRegisterState();
                                break block29;
                            }
                            catch (Exception e) {
                                throw new ResumeException("The local opening (following the already open DB) failed", localOpenFailed_remoteOpen, e);
                            }
                        }
                        throw new OutsideMeddlingException("DB was opened for a different date", localClosed_remoteOpen_datesMismatch);
                    }
                    assert (!localOpen && !remoteOpen);
                    if (!localState.hasDate()) {
                        assert (remoteState.hasDate()) : "Both closed with no dates, but not equal";
                        throw new OutsideMeddlingException("DB was opened and closed, but local log is missing", localMissing_remoteClosed);
                    }
                    if (remoteState.hasDate()) {
                        assert (remoteState.compareDateTo(localState) != 0) : "Both closed with equal dates, but not equal";
                        throw new OutsideMeddlingException("DB was opened and closed for a different date", closed_datesMismatch);
                    }
                    throw new OutsideMeddlingException("DB was never opened but local was closed", localClosed_remoteMissing);
                }
                catch (ReconcileException e) {
                    throw e.init(localState, remoteState);
                }
                catch (Exception e) {
                    throw new ReconcileException("Unknown exception", unknownTK, e).init(localState, remoteState);
                }
            }
        }
        if (!remoteState.equals(localState)) {
            throw new IllegalStateException("Unexpected state");
        }
        return remoteState;
    }

    public static void quit(POSConfiguration posConf) {
        POSConfiguration.getLogger().log(Level.INFO, "User exit");
        posConf.closeConnexion();
        Frame[] l = Frame.getFrames();
        int i = 0;
        while (i < l.length) {
            Frame f = l[i];
            System.err.println(String.valueOf(f.getName()) + " " + f + " Displayable: " + f.isDisplayable() + " Valid: " + f.isValid() + " Active: " + f.isActive());
            ++i;
        }
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread thread : threadSet) {
            if (thread.isDaemon()) continue;
            System.err.println(String.valueOf(thread.getName()) + " " + thread.getId() + " not daemon");
        }
    }

    @Override
    public void dispose() {
        CaisseFrame.quit(this.posConf);
        this.getControler().setLCD("   CAISSE FERMEE    ", "", 0);
        super.dispose();
    }

    public void showMenu() {
        System.out.println("CaisseFrame.showMenu()");
        CaisseMenuPanel panel = new CaisseMenuPanel(this);
        this.showPanel(panel);
        this.getControler().setLCD("OpenConcerto", "Menu", 0);
    }

    public void showPanel(final JPanel panel) {
        this.invalidate();
        int x = (this.getWidth() - panel.getPreferredSize().width) / 2;
        int y = 100;
        POSGlassPane glassPane2 = new POSGlassPane(panel, x, 100){

            @Override
            public void mousePressed(MouseEvent e) {
                Point containerPoint = SwingUtilities.convertPoint(this, e.getPoint(), panel);
                if (containerPoint.x < 0 || containerPoint.x > panel.getWidth() || containerPoint.y < 0 || containerPoint.y > panel.getHeight()) {
                    CaisseFrame.this.setGlassPane(new JPanel());
                    CaisseFrame.this.getGlassPane().setVisible(false);
                }
                super.mousePressed(e);
            }
        };
        this.setGlassPane(glassPane2);
        this.getGlassPane().setVisible(true);
        this.validate();
        this.repaint();
    }

    public void showPriceEditor(TicketItem item, CaisseControler caisseControler) {
        this.getControler().disableBarcodeReader();
        System.out.println("CaisseFrame.showPriceEditor()");
        this.invalidate();
        final PriceEditorPanel panel = new PriceEditorPanel(this, item);
        POSGlassPane glassPane2 = new POSGlassPane(panel, (this.getWidth() - panel.getPreferredSize().width) / 2, 100){

            @Override
            public void mousePressed(MouseEvent e) {
                Point containerPoint = SwingUtilities.convertPoint(this, e.getPoint(), panel);
                if (containerPoint.x < 0 || containerPoint.x > panel.getWidth() || containerPoint.y < 0 || containerPoint.y > panel.getHeight()) {
                    CaisseFrame.this.setGlassPane(new JPanel());
                    CaisseFrame.this.getGlassPane().setVisible(false);
                    CaisseFrame.this.getControler().enableBarcodeReader();
                }
                super.mousePressed(e);
            }
        };
        this.setGlassPane(glassPane2);
        this.getGlassPane().setVisible(true);
        this.validate();
        this.repaint();
    }

    public void showCaisse() {
        this.getControler().enableBarcodeReader();
        this.setGlassPane(new JPanel());
        this.getGlassPane().setVisible(false);
        System.out.println("CaisseFrame.showCaisse()");
        this.setContentPane(this.mainPanel);
        this.getControler().setLCD("OpenConcerto", "Caisse", 0);
        this.getControler().setLCDDefaultDisplay(5);
    }

    public void showTickets(Ticket t) {
        System.out.println("CaisseFrame.showMenu()");
        ListeDesTicketsPanel panel = new ListeDesTicketsPanel(this);
        panel.setSelectedTicket(t);
        this.setContentPane(panel);
    }

    public CaisseControler getControler() {
        return this.mainPanel.getControler();
    }

    public void showClients() {
        System.out.println("CaisseFrame.showClients()");
        ListeDesClientsPanel panel = new ListeDesClientsPanel(this);
        this.setContentPane(panel);
    }

    public void setClient(Client client) {
        System.err.println("CaisseFrame.setClient() " + client.getFullName());
        this.getControler().setClient(client);
    }

    @Override
    public void setContentPane(Container contentPane) {
        this.invalidate();
        this.setGlassPane(new JPanel());
        this.getGlassPane().setVisible(false);
        super.setContentPane(contentPane);
        this.validate();
        this.repaint();
    }

    public void showPostalCodeFrame(CaissePanel caissePanel) {
        System.out.println("CaisseFrame.showPostalCodeFrame()");
        this.invalidate();
        PostalCodeEditorPanel panel = new PostalCodeEditorPanel(this, caissePanel);
        POSGlassPane glassPane2 = new POSGlassPane(panel, (this.getWidth() - panel.getPreferredSize().width) / 2, 100);
        this.setGlassPane(glassPane2);
        this.getGlassPane().setVisible(true);
        this.validate();
        this.repaint();
    }

    public void showCBPanel(Paiement p) {
        this.getControler().disableBarcodeReader();
        System.out.println("CaisseFrame.showCBPanel()");
        this.invalidate();
        CBPanel panel = new CBPanel(this, this.getControler(), p);
        POSGlassPane glassPane2 = new POSGlassPane(panel, (this.getWidth() - panel.getPreferredSize().width) / 2, 100);
        this.setGlassPane(glassPane2);
        this.getGlassPane().setVisible(true);
        this.validate();
        this.repaint();
    }

    public void showArticleSelector(List<Article> list, ArticleSelectionListener articleSelectionListener) {
        this.getControler().disableBarcodeReader();
        this.invalidate();
        ArticleSelectorDialogPanel panel = new ArticleSelectorDialogPanel(this, list, articleSelectionListener);
        int x = (this.getWidth() - panel.getPreferredSize().width) / 2;
        int y = 100;
        System.out.println("CaisseFrame.showArticleSelector() at " + x + "," + 100 + " " + panel.getPreferredSize().width + "x" + panel.getPreferredSize().height + " : " + list.size() + " products (barcode : " + list.get(0).getBarCode() + ")");
        POSGlassPane glassPane2 = new POSGlassPane(panel, x, 100);
        this.setGlassPane(glassPane2);
        this.getGlassPane().setVisible(true);
        this.validate();
        this.repaint();
    }

    public static final class OutsideMeddlingException
    extends ReconcileException {
        protected OutsideMeddlingException(String msg, String key) {
            super(msg, key);
        }
    }

    public static class ReconcileException
    extends IllegalStateException {
        private RegisterState localState;
        private RegisterState remoteState;
        private final String translationKey;

        protected ReconcileException(String msg, String key) {
            this(msg, key, null);
        }

        protected ReconcileException(String msg, String key, Throwable cause) {
            super(Objects.requireNonNull(msg, "message"), cause);
            this.translationKey = Objects.requireNonNull(key, "translation key");
        }

        public final RegisterState getLocalState() {
            return this.localState;
        }

        public final RegisterState getRemoteState() {
            return this.remoteState;
        }

        public final String getTranslationKey() {
            return this.translationKey;
        }

        protected final ReconcileException init(RegisterState localState, RegisterState remoteState) {
            this.localState = Objects.requireNonNull(localState, "local state");
            this.remoteState = Objects.requireNonNull(remoteState, "remote state");
            return this;
        }
    }

    public static final class ResumeException
    extends ReconcileException {
        protected ResumeException(String msg, String key, Throwable cause) {
            super(msg, key, Objects.requireNonNull(cause, "missing cause"));
        }
    }
}

