/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;

public class RemiseTotalProvider
extends UserInitialsValueProvider {
    private final TypeRemiseTotalProvider type;

    public RemiseTotalProvider(TypeRemiseTotalProvider t) {
        this.type = t;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        void var6_10;
        SQLRowAccessor row = context.getRow();
        SQLTable table = row.getTable();
        Collection<? extends SQLRowAccessor> cols = row.getReferentRows(table.getTable(String.valueOf(table.getName()) + "_ELEMENT"));
        BigDecimal total = BigDecimal.ZERO;
        for (SQLRowAccessor sQLRowAccessor : cols) {
            if (sQLRowAccessor.getTable().contains("NIVEAU") && sQLRowAccessor.getInt("NIVEAU") != 1) continue;
            BigDecimal lineDiscount = BigDecimal.ZERO;
            lineDiscount = sQLRowAccessor.getBigDecimal("PV_HT").multiply(sQLRowAccessor.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sQLRowAccessor.getInt("QTE"))));
            if (this.type == TypeRemiseTotalProvider.TTC && sQLRowAccessor.getForeign("ID_TAXE") != null && !sQLRowAccessor.isForeignEmpty("ID_TAXE")) {
                BigDecimal vat = new BigDecimal(sQLRowAccessor.getForeign("ID_TAXE").getFloat("TAUX")).movePointLeft(2).add(BigDecimal.ONE);
                lineDiscount = lineDiscount.multiply(vat).setScale(2, RoundingMode.HALF_UP);
            }
            total = total.add(lineDiscount);
        }
        String string = "MONTANT_";
        if (row.getTable().contains("T_HT")) {
            String string2 = "T_";
        }
        total = this.type == TypeRemiseTotalProvider.TTC ? new BigDecimal(row.getLong(String.valueOf(var6_10) + "TTC")).movePointLeft(2).subtract(total) : new BigDecimal(row.getLong(String.valueOf(var6_10) + "HT")).movePointLeft(2).subtract(total);
        return total.abs();
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.discount.total", new RemiseTotalProvider(TypeRemiseTotalProvider.HT));
        SpreadSheetCellValueProviderManager.put("sales.discount.total.ttc", new RemiseTotalProvider(TypeRemiseTotalProvider.TTC));
    }

    private static enum TypeRemiseTotalProvider {
        TTC,
        HT;

    }
}

