/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationReglementVenteNG;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtSaisieVenteComptoir
extends GenerationEcritures
implements Runnable {
    private static final String source = "SAISIE_VENTE_COMPTOIR";
    private static final Integer journal = new Integer(3);
    private static final SQLTable saisieVCTable = base.getTable("SAISIE_VENTE_COMPTOIR");
    private static final SQLTable mvtTable = base.getTable("MOUVEMENT");
    private int idSaisieVenteComptoir;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtSaisieVenteComptoir(int idSaisieVenteComptoir) {
        this(idSaisieVenteComptoir, 1);
    }

    public GenerationMvtSaisieVenteComptoir(int idSaisieVenteComptoir, int idMvt) {
        this.idSaisieVenteComptoir = idSaisieVenteComptoir;
        this.idMvt = idMvt;
        new Thread(this).start();
    }

    private void genereMouvement() throws Exception {
        int idCompteClient;
        long tva;
        SQLRow saisieRow = saisieVCTable.getRow(this.idSaisieVenteComptoir);
        SQLRow clientRow = base.getTable("CLIENT").getRow(saisieRow.getInt("ID_CLIENT"));
        SQLRow taxeRow = base.getTable("TAXE").getRow(saisieRow.getInt("ID_TAXE"));
        PrixTTC prixTTC = new PrixTTC(((Long)saisieRow.getObject("MONTANT_TTC")).longValue());
        PrixHT prixHT = new PrixHT(prixTTC.calculLongHT((double)(taxeRow.getFloat("TAUX") / 100.0f)));
        long service = (Long)saisieRow.getObject("MONTANT_SERVICE");
        this.date = (Date)saisieRow.getObject("DATE");
        String string = "Vente comptoir ";
        String rowLib = saisieRow.getObject("NOM").toString();
        string = rowLib != null && rowLib.trim().length() > 0 ? String.valueOf(string) + rowLib.trim() : String.valueOf(string) + saisieRow.getForeignRow("ID_ARTICLE").getString("NOM");
        this.nom = string;
        this.putValue("DATE", this.date);
        this.putValue("NOM", this.nom);
        this.putValue("ID_JOURNAL", journal);
        this.putValue("ID_MOUVEMENT", new Integer(1));
        if (this.idMvt == 1) {
            this.idMvt = this.getNewMouvement(source, this.idSaisieVenteComptoir, 1, string);
        }
        this.putValue("ID_MOUVEMENT", new Integer(this.idMvt));
        int idCompteVenteProduit = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_PRODUIT");
        if (idCompteVenteProduit <= 1) {
            idCompteVenteProduit = ComptePCESQLElement.getIdComptePceDefault("VentesProduits");
        }
        if (clientRow.getObject("ID_COMPTE_PCE_PRODUIT") != null && !clientRow.isForeignEmpty("ID_COMPTE_PCE_PRODUIT")) {
            idCompteVenteProduit = clientRow.getInt("ID_COMPTE_PCE_PRODUIT");
        }
        if (saisieRow.getObject("ID_COMPTE_PCE_PRODUIT") != null && !saisieRow.isForeignEmpty("ID_COMPTE_PCE_PRODUIT")) {
            idCompteVenteProduit = saisieRow.getInt("ID_COMPTE_PCE_PRODUIT");
        }
        if (service != 0L) {
            int idCompteVenteService = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_SERVICE");
            if (idCompteVenteService <= 1) {
                idCompteVenteService = ComptePCESQLElement.getIdComptePceDefault("VentesServices");
            }
            if (clientRow.getObject("ID_COMPTE_PCE_SERVICE") != null && !clientRow.isForeignEmpty("ID_COMPTE_PCE_SERVICE")) {
                idCompteVenteService = clientRow.getInt("ID_COMPTE_PCE_SERVICE");
            }
            if (saisieRow.getObject("ID_COMPTE_PCE_SERVICE") != null && !saisieRow.isForeignEmpty("ID_COMPTE_PCE_SERVICE")) {
                idCompteVenteService = saisieRow.getInt("ID_COMPTE_PCE_SERVICE");
            }
            this.putValue("ID_COMPTE_PCE", new Integer(idCompteVenteService));
            this.putValue("DEBIT", new Long(0L));
            this.putValue("CREDIT", new Long(service));
            this.ajoutEcriture();
            if (prixHT.getLongValue() - service > 0L) {
                this.putValue("ID_COMPTE_PCE", new Integer(idCompteVenteProduit));
                this.putValue("DEBIT", new Long(0L));
                this.putValue("CREDIT", new Long(prixHT.getLongValue() - service));
                this.ajoutEcriture();
            }
        } else {
            this.putValue("ID_COMPTE_PCE", new Integer(idCompteVenteProduit));
            this.putValue("DEBIT", new Long(0L));
            this.putValue("CREDIT", new Long(prixHT.getLongValue()));
            this.ajoutEcriture();
        }
        if ((tva = prixTTC.calculLongTVA((double)taxeRow.getFloat("TAUX") / 100.0)) > 0L) {
            int idCompteTVA;
            SQLRow rowCptTva = saisieRow.getForeign("ID_TAXE").getForeign("ID_COMPTE_PCE_COLLECTE");
            if (rowCptTva == null || rowCptTva.isUndefined()) {
                idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_VENTE");
                if (idCompteTVA <= 1) {
                    idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVACollectee");
                }
            } else {
                idCompteTVA = ((SQLRowAccessor)rowCptTva).getID();
            }
            this.putValue("ID_COMPTE_PCE", new Integer(idCompteTVA));
            this.putValue("DEBIT", new Long(0L));
            this.putValue("CREDIT", new Long(tva));
            this.ajoutEcriture();
        }
        if ((idCompteClient = clientRow.getInt("ID_COMPTE_PCE")) <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
            idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
        }
        this.putValue("ID_COMPTE_PCE", new Integer(idCompteClient));
        this.putValue("DEBIT", new Long(prixTTC.getLongValue()));
        this.putValue("CREDIT", new Long(0L));
        this.ajoutEcriture();
        String s = "Vente comptoir ";
        String name = saisieRow.getObject("NOM").toString();
        s = name != null && rowLib.trim().length() > 0 ? String.valueOf(s) + name.trim() : String.valueOf(s) + saisieRow.getForeignRow("ID_ARTICLE").getString("NOM");
        SQLRow modeRegRow = saisieRow.getForeignRow("ID_MODE_REGLEMENT");
        new GenerationReglementVenteNG(s, clientRow, prixTTC, this.date, modeRegRow, saisieRow, mvtTable.getRow(this.idMvt));
        SQLRowValues valSaisieVC = new SQLRowValues(saisieVCTable);
        valSaisieVC.put("ID_MOUVEMENT", new Integer(this.idMvt));
        if (valSaisieVC.getInvalid() == null) {
            valSaisieVC.update(this.idSaisieVenteComptoir);
            this.displayMvtNumber();
        }
    }

    @Override
    public void run() {
        try {
            this.genereMouvement();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
        }
    }
}

