/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.PropoLettrageRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.PropoLettrageTableModel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.TableSorter;
import org.openconcerto.utils.Tuple2;

public class PropoLettrage {
    private SQLElement eltEcr;
    private Date dateKm;

    public PropoLettrage(SQLElement eltEcr) {
        this.eltEcr = eltEcr;
    }

    public void transfert(SQLRow rowKM) {
        Collection rowItems = rowKM.getReferentRows(rowKM.getTable().getTable("SAISIE_KM_ELEMENT").getField("ID_SAISIE_KM"));
        this.dateKm = rowKM.getDate("DATE").getTime();
        HashSet<Tuple2<String, String>> cpts = new HashSet<Tuple2<String, String>>();
        for (SQLRow sQLRow : rowItems) {
            String cptNumero = sQLRow.getString("NUMERO");
            if (!cptNumero.startsWith("40") && !cptNumero.startsWith("41")) continue;
            cpts.add(Tuple2.create(cptNumero, sQLRow.getString("NOM")));
        }
        if (!cpts.isEmpty()) {
            for (Tuple2 tuple2 : cpts) {
                SQLRowValues rowValsEcr = new SQLRowValues(this.eltEcr.getTable());
                rowValsEcr.putNulls("DEBIT", "CREDIT", "ID", "COMPTE_NOM", "COMPTE_NUMERO", "NOM", "NOM_PIECE", "DATE");
                rowValsEcr.putRowValues("ID_MOUVEMENT").putNulls("NUMERO").putRowValues("ID_PIECE").putNulls("NOM");
                List<SQLRowValues> resultEcrNonLettrees = SQLRowValuesListFetcher.create(rowValsEcr).fetch(new Where((FieldRef)this.eltEcr.getTable().getField("COMPTE_NUMERO"), "=", tuple2.get0()).and(new Where((FieldRef)this.eltEcr.getTable().getField("LETTRAGE"), "=", (Object)"").or(new Where((FieldRef)this.eltEcr.getTable().getField("LETTRAGE"), "=", (Object)null))));
                this.showPreview(resultEcrNonLettrees, tuple2);
            }
        }
    }

    private void showPreview(List<SQLRowValues> rows, Tuple2<String, String> compte) {
        if (rows.isEmpty() || rows.size() == 1) {
            return;
        }
        JPanel panelPreview = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        final PropoLettrageTableModel propoModel = new PropoLettrageTableModel(this.eltEcr, rows);
        final TableSorter s = new TableSorter(propoModel);
        final JTable table = new JTable(s);
        s.setTableHeader(table.getTableHeader());
        int columnCount = table.getColumnCount();
        int col = 0;
        while (col < columnCount) {
            table.getColumnModel().getColumn(col).setCellRenderer(new PropoLettrageRenderer());
            ++col;
        }
        c.gridwidth = 0;
        panelPreview.add((Component)new JLabelBold("Ecritures non lettr\u00e9es du compte " + compte.get0() + " " + compte.get1()), c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelPreview.add((Component)new JScrollPane(table), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.fill = 2;
        panelPreview.add((Component)new JLabel("Lettrer les \u00e9critures s\u00e9lectionn\u00e9es \u00e0 la date du "), c);
        final JDate date = new JDate();
        date.setValue(this.dateKm);
        ++c.gridx;
        panelPreview.add(date);
        final JDialog diag = new JDialog();
        diag.setModal(true);
        diag.setContentPane(panelPreview);
        diag.setTitle("Lettrage " + compte.get0() + " " + compte.get1());
        ++c.gridy;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        final JButton valid = new JButton(new AbstractAction("Lettrer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SQLUtils.executeAtomic(PropoLettrage.this.eltEcr.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, Exception>(){

                        @Override
                        public Object handle(SQLDataSource ds) throws SQLException, Exception {
                            String codeLettre = NumerotationAutoSQLElement.getNextCodeLettrage();
                            int[] selectedRows = table.getSelectedRows();
                            int[] modelRows = new int[selectedRows.length];
                            int nb = 0;
                            int[] nArray = selectedRows;
                            int n = selectedRows.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int i = nArray[n2];
                                modelRows[nb] = s.modelIndex(i);
                                ++nb;
                                ++n2;
                            }
                            Date dateLettrage = date.getValue() == null ? new Date() : date.getValue();
                            int[] nArray2 = modelRows;
                            int n3 = modelRows.length;
                            n = 0;
                            while (n < n3) {
                                int index = nArray2[n];
                                SQLRowValues rowValsEcr = propoModel.getRowValuesAt(index).createEmptyUpdateRow();
                                if (codeLettre.length() > 0) {
                                    rowValsEcr.put("LETTRAGE", codeLettre);
                                    rowValsEcr.put("DATE_LETTRAGE", dateLettrage);
                                    rowValsEcr.update();
                                }
                                ++n;
                            }
                            SQLElement elt = Configuration.getInstance().getDirectory().getElement("NUMEROTATION_AUTO");
                            SQLRowValues rowVals = elt.getTable().getRow(2).createEmptyUpdateRow();
                            rowVals.put("CODE_LETTRAGE", codeLettre);
                            rowVals.update();
                            return null;
                        }
                    });
                }
                catch (Exception e1) {
                    ExceptionHandler.handle("Erreur lors du lettrage", e1);
                }
                diag.dispose();
            }
        });
        panelPreview.add((Component)valid, c);
        valid.setEnabled(false);
        c.weightx = 0.0;
        ++c.gridx;
        JButton fermer = new JButton(new AbstractAction("Fermer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                diag.dispose();
            }
        });
        panelPreview.add((Component)fermer, c);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int[] selectedRows = table.getSelectedRows();
                int[] modelRows = new int[selectedRows.length];
                int nb = 0;
                int[] nArray = selectedRows;
                int n = selectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    modelRows[nb] = s.modelIndex(i);
                    ++nb;
                    ++n2;
                }
                valid.setEnabled(propoModel.isSelectionEqual(modelRows));
            }
        });
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int[] selectedRows = table.getSelectedRows();
                int[] modelRows = new int[selectedRows.length];
                int nb = 0;
                int[] nArray = selectedRows;
                int n = selectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    modelRows[nb] = s.modelIndex(i);
                    ++nb;
                    ++n2;
                }
                valid.setEnabled(propoModel.isSelectionEqual(modelRows));
            }
        });
        diag.pack();
        diag.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        diag.setLocationRelativeTo(null);
        FrameUtil.show(diag);
    }
}

