/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.AxeAnalytiqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.RepartitionAnalytiqueElementSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.RepartitionAnalytiqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.model.AssociationAnalytiqueModel;
import org.openconcerto.erp.core.finance.accounting.ui.PlanComptableCellRenderer;
import org.openconcerto.erp.element.objet.ClasseCompte;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class AssociationCompteAnalytiqueSQLElement
extends ComptaSQLConfElement {
    private JTabbedPane tabbedClasse;

    public AssociationCompteAnalytiqueSQLElement() {
        super("ASSOCIATION_COMPTE_ANALYTIQUE", "une association compte analytique", "associations comptes analytiques");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_COMPTE_PCE");
        l.add("ID_REPARTITION_ANALYTIQUE");
        l.add("ID_AXE_ANALYTIQUE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_COMPTE_PCE");
        l.add("ID_REPARTITION_ANALYTIQUE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.fill = 1;
                final ArrayList<ClasseCompte> classeComptes = new ArrayList<ClasseCompte>();
                AssociationCompteAnalytiqueSQLElement.this.tabbedClasse = new JTabbedPane();
                SQLTable classeCompteTable = this.getTable().getBase().getTable("CLASSE_COMPTE");
                SQLSelect selClasse = new SQLSelect();
                selClasse.addSelect(classeCompteTable.getField("ID"));
                selClasse.addSelect(classeCompteTable.getField("NOM"));
                selClasse.addSelect(classeCompteTable.getField("TYPE_NUMERO_COMPTE"));
                selClasse.addRawOrder("TYPE_NUMERO_COMPTE");
                String reqClasse = selClasse.asString();
                Object obClasse = this.getTable().getBase().getDataSource().execute(reqClasse, new ArrayListHandler());
                List myListClasse = (List)obClasse;
                for (Object[] objTmp : myListClasse) {
                    ClasseCompte ccTmp = new ClasseCompte(Integer.parseInt(objTmp[0].toString()), objTmp[1].toString(), objTmp[2].toString());
                    classeComptes.add(ccTmp);
                    AssociationCompteAnalytiqueSQLElement.this.tabbedClasse.add(ccTmp.getNom(), new JScrollPane(AssociationCompteAnalytiqueSQLElement.this.creerJTable(ccTmp)));
                }
                this.add((Component)AssociationCompteAnalytiqueSQLElement.this.tabbedClasse, c);
                SQLTableModifiedListener tListener = new SQLTableModifiedListener(){

                    @Override
                    public void tableModified(SQLTableEvent evt) {
                        int tabCount = AssociationCompteAnalytiqueSQLElement.this.tabbedClasse.getTabCount();
                        int i = 0;
                        while (i < tabCount) {
                            AssociationCompteAnalytiqueSQLElement.this.tabbedClasse.setComponentAt(i, new JScrollPane(AssociationCompteAnalytiqueSQLElement.this.creerJTable((ClasseCompte)classeComptes.get(i))));
                            ++i;
                        }
                    }
                };
                SQLTable tAxeAnalytique = this.getElement().getDirectory().getElement(AxeAnalytiqueSQLElement.class).getTable();
                tAxeAnalytique.addTableModifiedListener(tListener);
                SQLTable tRepartitionAnalytique = this.getElement().getDirectory().getElement(RepartitionAnalytiqueSQLElement.class).getTable();
                tRepartitionAnalytique.addTableModifiedListener(tListener);
                SQLTable tRepartitionAnalytiqueElement = this.getElement().getDirectory().getElement(RepartitionAnalytiqueElementSQLElement.class).getTable();
                tRepartitionAnalytiqueElement.addTableModifiedListener(tListener);
                SQLTable tComptePCE = this.getElement().getDirectory().getElement(ComptePCESQLElement.class).getTable();
                tComptePCE.addTableModifiedListener(tListener);
            }
        };
    }

    public JTable creerJTable(ClasseCompte ccTmp) {
        AssociationAnalytiqueModel model = new AssociationAnalytiqueModel(ccTmp);
        JTable table = new JTable(model);
        Vector vect = model.getRepartitionsAxe();
        table.getColumnModel().getColumn(0).setCellRenderer(new PlanComptableCellRenderer(0));
        table.getColumnModel().getColumn(1).setCellRenderer(new PlanComptableCellRenderer(0));
        int i = 0;
        while (i < vect.size()) {
            Vector rep = (Vector)vect.get(i);
            JComboBox combo = new JComboBox();
            int j = 0;
            while (j < rep.size()) {
                combo.addItem(rep.get(j));
                ++j;
            }
            table.getColumnModel().getColumn(i + 2).setCellEditor(new DefaultCellEditor(combo));
            table.getColumnModel().getColumn(i + 2).setCellRenderer(new PlanComptableCellRenderer(0));
            ++i;
        }
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".analytic.account.relation";
    }
}

