/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.ui.AjouterAxeAnalytiqueFrame;
import org.openconcerto.erp.core.finance.accounting.ui.RepartitionAxeAnalytiquePanel;
import org.openconcerto.erp.core.finance.accounting.ui.ValiderSuppressionAxeFrame;
import org.openconcerto.erp.element.objet.Axe;
import org.openconcerto.erp.element.objet.Poste;
import org.openconcerto.erp.element.objet.Repartition;
import org.openconcerto.erp.element.objet.RepartitionElement;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class AnalytiqueSQLElement
extends ComptaSQLConfElement {
    private Vector vecteurTabAxe;
    private final List<Axe> axes = new ArrayList<Axe>();
    private List<List<Repartition>> repartitionsAxe;
    private List<List<RepartitionElement>> repartitionElemsAxe;
    private List<List<Poste>> postesAxe;
    private AnalytiqueSQLElement a = this;
    private JTabbedPane tabAxes;
    private Map<Integer, Integer> mapPostes;
    private Map<Integer, Integer> mapRepartitons;
    private JWindow windowChangeNom;
    private AjouterAxeAnalytiqueFrame ajoutAxeFrame = null;
    private JTextField text;
    private int editedAxeIndex = -1;

    public AnalytiqueSQLElement() {
        super("AXE_ANALYTIQUE", "un axe analytique", "axes analytiques");
    }

    protected List getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    protected List getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                c.anchor = 18;
                c.gridwidth = 4;
                c.gridheight = 8;
                AnalytiqueSQLElement.this.vecteurTabAxe = new Vector();
                AnalytiqueSQLElement.this.repartitionsAxe = new Vector();
                AnalytiqueSQLElement.this.repartitionElemsAxe = new Vector();
                AnalytiqueSQLElement.this.postesAxe = new Vector();
                AnalytiqueSQLElement.this.tabAxes = new JTabbedPane();
                SQLBase base = this.getTable().getBase();
                SQLSelect sel = new SQLSelect();
                sel.addSelect(this.getTable().getKey());
                sel.addSelect(this.getTable().getField("NOM"));
                sel.addFieldOrder(sel.getAlias(this.getTable().getField("NOM")));
                String req = sel.asString();
                Object ob = this.getTable().getBase().getDataSource().execute(req, new ArrayListHandler());
                List myList = (List)ob;
                if (myList.size() != 0) {
                    int i = 0;
                    while (i < myList.size()) {
                        Object[] objTmp = (Object[])myList.get(i);
                        AnalytiqueSQLElement.this.axes.add(new Axe(Integer.parseInt(objTmp[0].toString()), objTmp[1].toString()));
                        RepartitionAxeAnalytiquePanel repAxeComp = new RepartitionAxeAnalytiquePanel(((Axe)AnalytiqueSQLElement.this.axes.get(i)).getId());
                        AnalytiqueSQLElement.this.repartitionsAxe.add(repAxeComp.getRepartitions());
                        AnalytiqueSQLElement.this.repartitionElemsAxe.add(repAxeComp.getRepartitionElems());
                        AnalytiqueSQLElement.this.postesAxe.add(repAxeComp.getPostes());
                        AnalytiqueSQLElement.this.tabAxes.addTab(((Axe)AnalytiqueSQLElement.this.axes.get(i)).getNom(), repAxeComp);
                        AnalytiqueSQLElement.this.vecteurTabAxe.add(i, new String(String.valueOf(i)));
                        ++i;
                    }
                    System.out.println("Size ----> " + AnalytiqueSQLElement.this.axes.size());
                } else {
                    AnalytiqueSQLElement.this.ajouterAxe("Nouvel Axe");
                }
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)AnalytiqueSQLElement.this.tabAxes, c);
                AnalytiqueSQLElement.this.tabAxes.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        int index = AnalytiqueSQLElement.this.tabAxes.indexAtLocation(e.getX(), e.getY());
                        AnalytiqueSQLElement.this.validAxeText();
                        if (e.getClickCount() == 2) {
                            AnalytiqueSQLElement.this.actionModifierAxe(e, index);
                        }
                        if (e.getButton() == 3) {
                            AnalytiqueSQLElement.this.actionDroitOnglet(index, e);
                        }
                    }
                });
                AnalytiqueSQLElement.this.tabAxes.addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent event) {
                        AnalytiqueSQLElement.this.validAxeText();
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent event) {
                        AnalytiqueSQLElement.this.validAxeText();
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent event) {
                        AnalytiqueSQLElement.this.validAxeText();
                    }
                });
                JButton boutonAddAxe = new JButton("Ajouter un axe");
                boutonAddAxe.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        if (AnalytiqueSQLElement.this.ajoutAxeFrame == null) {
                            AnalytiqueSQLElement.this.ajoutAxeFrame = new AjouterAxeAnalytiqueFrame(AnalytiqueSQLElement.this.a);
                        }
                        AnalytiqueSQLElement.this.ajoutAxeFrame.pack();
                        AnalytiqueSQLElement.this.ajoutAxeFrame.setVisible(true);
                    }
                });
                c.gridx += 4;
                c.gridwidth = 1;
                c.gridheight = 1;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.fill = 2;
                this.add((Component)boutonAddAxe, c);
                JButton boutonDelAxe = new JButton("Supprimer un axe");
                boutonDelAxe.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        AnalytiqueSQLElement.this.supprimerAxe(Integer.parseInt(AnalytiqueSQLElement.this.vecteurTabAxe.get(AnalytiqueSQLElement.this.tabAxes.getSelectedIndex()).toString()));
                    }
                });
                ++c.gridy;
                this.add((Component)boutonDelAxe, c);
                JButton boutonSet = new JButton("SetVal");
                boutonSet.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        AnalytiqueSQLElement.this.setVal();
                    }
                });
                ++c.gridy;
                this.add((Component)boutonSet, c);
                JButton boutonCheck = new JButton("Check");
                boutonCheck.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        AnalytiqueSQLElement.this.checkID();
                    }
                });
                ++c.gridy;
                this.add((Component)boutonCheck, c);
            }
        };
    }

    private void actionDroitOnglet(final int index, final MouseEvent e) {
        JPopupMenu pop = new JPopupMenu();
        pop.add(new AbstractAction("Ajouter un axe"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnalytiqueSQLElement.this.ajoutAxeFrame == null) {
                    AnalytiqueSQLElement.this.ajoutAxeFrame = new AjouterAxeAnalytiqueFrame(AnalytiqueSQLElement.this.a);
                }
                AnalytiqueSQLElement.this.ajoutAxeFrame.pack();
                AnalytiqueSQLElement.this.ajoutAxeFrame.setVisible(true);
            }
        });
        if (index != -1) {
            pop.add(new AbstractAction("Supprimer l'axe"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnalytiqueSQLElement.this.supprimerAxe(index);
                }
            });
            pop.add(new AbstractAction("Modifier le nom"){

                @Override
                public void actionPerformed(ActionEvent aE) {
                    AnalytiqueSQLElement.this.actionModifierAxe(e, index);
                }
            });
        }
        pop.show(e.getComponent(), e.getX(), e.getY());
        System.out.println("Click droit onglet");
    }

    private void actionModifierAxe(MouseEvent e, int index) {
        if (index == -1) {
            return;
        }
        Component comp = (Component)e.getSource();
        JFrame frame = (JFrame)SwingUtilities.getRoot(comp);
        this.windowChangeNom = new JWindow(frame);
        Container container = this.windowChangeNom.getContentPane();
        container.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        this.editedAxeIndex = index;
        this.text = new JTextField(" " + this.tabAxes.getTitleAt(index) + " ");
        this.text.setEditable(true);
        container.add((Component)this.text, c);
        this.text.setBorder(null);
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    AnalytiqueSQLElement.this.validAxeText();
                }
            }
        });
        this.windowChangeNom.pack();
        int ecartY = this.tabAxes.getBoundsAt((int)index).height - this.text.getBounds().height + 2;
        int ecartX = this.tabAxes.getBoundsAt((int)index).width - this.text.getBounds().width;
        this.windowChangeNom.setLocation(comp.getLocationOnScreen().x + this.tabAxes.getBoundsAt((int)index).getLocation().x + ecartX / 2, comp.getLocationOnScreen().y + this.tabAxes.getBoundsAt((int)index).getLocation().y + ecartY / 2);
        this.windowChangeNom.setVisible(true);
    }

    private synchronized void validAxeText() {
        if (this.text == null || this.windowChangeNom == null) {
            return;
        }
        this.modifierAxe(this.editedAxeIndex, this.text.getText());
        this.windowChangeNom.setVisible(false);
        this.windowChangeNom.dispose();
        this.editedAxeIndex = -1;
        this.text = null;
    }

    private void modifierAxe(int axeIndex, String nom) {
        if (axeIndex < 0) {
            return;
        }
        this.axes.get(Integer.parseInt(this.vecteurTabAxe.get(axeIndex).toString())).setNom(nom);
        this.tabAxes.setTitleAt(axeIndex, nom);
    }

    public void ajouterAxe(String nom) {
        RepartitionAxeAnalytiquePanel repAxePanel = new RepartitionAxeAnalytiquePanel(1);
        if (nom.trim().length() == 0) {
            this.tabAxes.addTab("Nouvel axe", repAxePanel);
        } else {
            this.tabAxes.addTab(nom, repAxePanel);
        }
        this.repartitionsAxe.add(repAxePanel.getRepartitions());
        this.repartitionElemsAxe.add(repAxePanel.getRepartitionElems());
        this.postesAxe.add(repAxePanel.getPostes());
        this.vecteurTabAxe.add(this.tabAxes.getTabCount() - 1, new String(String.valueOf(this.axes.size())));
        this.axes.add(new Axe(1, this.tabAxes.getTitleAt(this.tabAxes.getTabCount() - 1), true));
    }

    private void supprimerAxe(int axeSelect) {
        SQLTable assocTable = this.getTable().getBase().getTable("ASSOCIATION_COMPTE_ANALYTIQUE");
        SQLBase base = this.getTable().getBase();
        SQLSelect selAssoc = new SQLSelect(base);
        selAssoc.addSelect(assocTable.getField("ID"));
        selAssoc.addSelect(assocTable.getField("ID_COMPTE_PCE"));
        selAssoc.setWhere(assocTable.getField("ID_AXE_ANALYTIQUE"), "=", this.axes.get(axeSelect).getId());
        String reqAssoc = selAssoc.asString();
        Object obAssoc = this.getTable().getBase().getDataSource().execute(reqAssoc, new ArrayListHandler());
        List myListAssoc = (List)obAssoc;
        if (myListAssoc.size() != 0) {
            System.out.println("La r\u00e9partition est affect\u00e9e \u00e0 un compte.");
            ValiderSuppressionAxeFrame validFrame = new ValiderSuppressionAxeFrame(this.a, axeSelect);
            validFrame.pack();
            validFrame.setVisible(true);
        } else {
            this.deleteAxe(axeSelect);
        }
    }

    public void deleteAxe(int axeSelect) {
        this.axes.get(axeSelect).setSuppression(true);
        int j = this.tabAxes.getSelectedIndex();
        while (j < this.tabAxes.getTabCount() - 1) {
            this.vecteurTabAxe.set(j, new String(this.vecteurTabAxe.get(j + 1).toString()));
            ++j;
        }
        Vector repartitions = (Vector)this.repartitionsAxe.get(axeSelect);
        j = 0;
        while (j < repartitions.size()) {
            ((Repartition)repartitions.get(j)).setSuppression(true);
            ++j;
        }
        Vector repartitionElems = (Vector)this.repartitionElemsAxe.get(axeSelect);
        j = 0;
        while (j < repartitionElems.size()) {
            ((RepartitionElement)repartitionElems.get(j)).setSuppression(true);
            ++j;
        }
        Vector post = (Vector)this.postesAxe.get(axeSelect);
        j = 0;
        while (j < post.size()) {
            ((Poste)post.get(j)).setSuppression(true);
            ++j;
        }
        this.tabAxes.remove(this.tabAxes.getSelectedIndex());
        System.out.println("suppression de tab numero --> " + this.tabAxes.getSelectedIndex() + " numero Axe : " + axeSelect);
    }

    private void supprimerAxeTable(Axe axe) {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        vals.put(this.getTable().getArchiveField().getName(), new Integer(1));
        try {
            vals.update(axe.getId());
        }
        catch (SQLException e) {
            System.out.println("Erreur suppression Axe " + axe.getId());
        }
        System.out.println("Axe Supprim\u00e9  -->" + axe.toString());
    }

    private void creerAxeTable(Axe axe) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("NOM", axe.getNom());
        SQLRowValues val = new SQLRowValues(this.getTable(), m);
        try {
            SQLRow row = val.insert();
            System.out.println("Row ID -->" + row.getID());
            axe.setId(row.getInt("ID"));
        }
        catch (SQLException e) {
            System.out.println("Error insert row in " + this.getTable().toString());
        }
        axe.setCreation(false);
        axe.setModif(false);
        System.out.println("Axe Nouveau  -->" + axe.toString());
    }

    private void modifierAxeTable(Axe axe) {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        vals.put("NOM", axe.getNom());
        try {
            vals.update(axe.getId());
        }
        catch (SQLException e) {
            System.err.println("Erreur modification Axe " + axe.getId());
            e.printStackTrace();
        }
        axe.setCreation(false);
        axe.setModif(false);
        System.out.println("Axe Modifi\u00e9  -->" + axe.toString());
    }

    private void supprimerRepartitionTable(Repartition rep) {
        SQLRowValues vals = new SQLRowValues(this.getTable().getBase().getTable("REPARTITION_ANALYTIQUE"));
        vals.put(this.getTable().getBase().getTable("REPARTITION_ANALYTIQUE").getArchiveField().getName(), new Integer(1));
        SQLTable assocTable = this.getTable().getBase().getTable("ASSOCIATION_COMPTE_ANALYTIQUE");
        SQLBase base = assocTable.getBase();
        SQLSelect selAssoc = new SQLSelect(base);
        selAssoc.addSelect(assocTable.getField("ID"));
        selAssoc.addSelect(assocTable.getField("ID_COMPTE_PCE"));
        selAssoc.setWhere(assocTable.getField("ID_REPARTITION_ANALYTIQUE"), "=", rep.getId());
        String reqAssoc = selAssoc.asString();
        Object obAssoc = this.getTable().getBase().getDataSource().execute(reqAssoc, new ArrayListHandler());
        List myListAssoc = (List)obAssoc;
        if (myListAssoc.size() != 0) {
            SQLRowValues valsAssoc = new SQLRowValues(this.getTable().getBase().getTable("ASSOCIATION_COMPTE_ANALYTIQUE"));
            valsAssoc.put("ARCHIVE", 1);
            try {
                int i = 0;
                while (i < myListAssoc.size()) {
                    Object[] objTmp = (Object[])myListAssoc.get(i);
                    valsAssoc.update(Integer.parseInt(objTmp[0].toString()));
                    ++i;
                }
            }
            catch (SQLException e) {
                System.err.println("Erreur suppression association ");
                e.printStackTrace();
            }
        }
        try {
            vals.update(rep.getId());
        }
        catch (SQLException e) {
            System.err.println("Erreur suppression Repartition " + rep.getId());
            e.printStackTrace();
        }
        System.out.println("Rep Supprim\u00e9e  -->" + rep.toString());
    }

    private void creerRepartitionTable(Repartition rep) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("NOM", rep.getNom());
        SQLRowValues val = new SQLRowValues(this.getTable().getBase().getTable("REPARTITION_ANALYTIQUE"), m);
        try {
            SQLRow row = val.insert();
            System.out.println("Row ID -->" + row.getID());
            this.mapRepartitons.put(new Integer(rep.getId()), new Integer(row.getID()));
            rep.setId(row.getID());
        }
        catch (SQLException e) {
            System.err.println("Error insert row in " + val.getTable().getName());
            e.printStackTrace();
        }
        rep.setCreation(false);
        rep.setModif(false);
        System.out.println("Rep Cr\u00e9e  -->" + rep.toString());
    }

    private void modifierRepartitionTable(Repartition rep) {
        SQLRowValues vals = new SQLRowValues(this.getTable().getBase().getTable("REPARTITION_ANALYTIQUE"));
        vals.put("NOM", rep.getNom());
        try {
            vals.update(rep.getId());
        }
        catch (SQLException e) {
            System.err.println("Erreur modification Repartition " + rep.getId());
            e.printStackTrace();
        }
        rep.setCreation(false);
        rep.setModif(false);
        System.out.println("R\u00e9partition Modifi\u00e9  -->" + rep.toString());
    }

    private void creerPosteTable(Poste p, int id_axe) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("NOM", p.getNom());
        m.put("ID_AXE_ANALYTIQUE", new Integer(id_axe));
        SQLRowValues val = new SQLRowValues(this.getTable().getBase().getTable("POSTE_ANALYTIQUE"), m);
        try {
            SQLRow row = val.insert();
            this.mapPostes.put(p.getId(), row.getID());
            p.setId(row.getID());
            p.setIdAxe(id_axe);
        }
        catch (SQLException e) {
            System.err.println("Error insert row in " + val.getTable().getName());
            e.printStackTrace();
        }
        p.setCreation(false);
        p.setModif(false);
        System.out.println("Poste Cr\u00e9e  -->" + p.toString());
    }

    private void supprimerPosteTable(Poste p) {
        SQLRowValues vals = new SQLRowValues(this.getTable().getBase().getTable("POSTE_ANALYTIQUE"));
        vals.put(this.getTable().getBase().getTable("POSTE_ANALYTIQUE").getArchiveField().getName(), new Integer(1));
        try {
            vals.update(p.getId());
        }
        catch (SQLException e) {
            System.err.println("Erreur suppression Poste " + p.getId());
            e.printStackTrace();
        }
        System.out.println("Poste Supprim\u00e9e  -->" + p.toString());
    }

    private void modifierPosteTable(Poste p) {
        SQLRowValues vals = new SQLRowValues(this.getTable().getBase().getTable("POSTE_ANALYTIQUE"));
        vals.put("NOM", p.getNom());
        try {
            vals.update(p.getId());
        }
        catch (SQLException e) {
            System.err.println("Erreur modification Poste " + p.getId());
            e.printStackTrace();
        }
        p.setCreation(false);
        p.setModif(false);
        System.out.println("Poste Modifi\u00e9  -->" + p.toString());
    }

    private void creerRepartitionElementTable(RepartitionElement repElem) {
        HashMap<String, Number> m = new HashMap<String, Number>();
        m.put("ID_REPARTITION_ANALYTIQUE", this.mapRepartitons.get(new Integer(repElem.getIdRep())));
        m.put("ID_POSTE_ANALYTIQUE", this.mapPostes.get(new Integer(repElem.getIdPoste())));
        m.put("TAUX", new Float(repElem.getTaux()));
        SQLRowValues val = new SQLRowValues(this.getTable().getBase().getTable("REPARTITION_ANALYTIQUE_ELEMENT"), m);
        try {
            if (val.getInvalid() == null) {
                SQLRow row = val.insert();
                System.out.println("Row ID -->" + row.getID());
                repElem.setId(row.getID());
                repElem.setIdRep(this.mapRepartitons.get(new Integer(repElem.getIdRep())));
                repElem.setIdPoste(this.mapPostes.get(new Integer(repElem.getIdPoste())));
            } else {
                System.out.println("--------------------------> Element supprim\u00e9");
                repElem.setDeleted(true);
            }
        }
        catch (SQLException e) {
            System.err.println("Error insert row in " + val.getTable().getName());
            e.printStackTrace();
        }
        repElem.setCreation(false);
        repElem.setModif(false);
        System.out.println("RepElement Cr\u00e9e  -->" + repElem.toString());
    }

    private void supprimerRepartitionElementTable(RepartitionElement repElem) {
        SQLRowValues vals = new SQLRowValues(this.getTable().getBase().getTable("REPARTITION_ANALYTIQUE_ELEMENT"));
        vals.put(this.getTable().getBase().getTable("REPARTITION_ANALYTIQUE_ELEMENT").getArchiveField().getName(), new Integer(1));
        try {
            vals.update(repElem.getId());
        }
        catch (SQLException e) {
            System.err.println("Erreur suppression Repartition Elem " + repElem.getId());
            e.printStackTrace();
        }
        System.out.println("RepElement Supprim\u00e9e  -->" + repElem.toString());
    }

    private void modifierRepartitionElementTable(RepartitionElement repElem) {
        SQLRowValues vals = new SQLRowValues(this.getTable().getBase().getTable("REPARTITION_ANALYTIQUE_ELEMENT"));
        vals.put("TAUX", new Float(repElem.getTaux()));
        try {
            vals.update(repElem.getId());
        }
        catch (SQLException e) {
            System.err.println("Erreur suppression Repartition Elem " + repElem.getId());
            e.printStackTrace();
        }
        repElem.setCreation(false);
        repElem.setModif(false);
        System.out.println("RepElement Modifi\u00e9  -->" + repElem.toString());
    }

    private void setVal() {
        int i = 0;
        while (i < this.axes.size()) {
            Axe axe = this.axes.get(i);
            this.mapPostes = new HashMap<Integer, Integer>();
            this.mapRepartitons = new HashMap<Integer, Integer>();
            if (!(axe.getSuppression() && axe.getCreation() && axe.getDeleted())) {
                if (axe.getSuppression()) {
                    this.supprimerAxeTable(axe);
                } else if (axe.getCreation()) {
                    this.creerAxeTable(axe);
                } else if (axe.getModif()) {
                    this.modifierAxeTable(axe);
                }
            }
            List<Repartition> repartitions = this.repartitionsAxe.get(i);
            int j = 0;
            while (j < repartitions.size()) {
                Repartition rep = repartitions.get(j);
                this.mapRepartitons.put(new Integer(rep.getId()), new Integer(rep.getId()));
                if (!(rep.getSuppression() && rep.getCreation() && rep.getDeleted())) {
                    if (rep.getCreation()) {
                        this.creerRepartitionTable(rep);
                    } else if (rep.getSuppression()) {
                        this.supprimerRepartitionTable(rep);
                    } else if (rep.getModif()) {
                        this.modifierRepartitionTable(rep);
                    }
                }
                ++j;
            }
            List<Poste> postes = this.postesAxe.get(i);
            int j2 = 0;
            while (j2 < postes.size()) {
                Poste p = postes.get(j2);
                this.mapPostes.put(p.getId(), p.getId());
                if (!(p.getSuppression() && p.getCreation() && p.getDeleted())) {
                    if (p.getCreation()) {
                        this.creerPosteTable(p, axe.getId());
                    } else if (p.getSuppression()) {
                        this.supprimerPosteTable(p);
                    } else if (p.getModif()) {
                        this.modifierPosteTable(p);
                    }
                }
                ++j2;
            }
            List<RepartitionElement> repartitionElems = this.repartitionElemsAxe.get(i);
            int j3 = 0;
            while (j3 < repartitionElems.size()) {
                RepartitionElement repElem = repartitionElems.get(j3);
                if (!(repElem.getSuppression() && repElem.getCreation() && repElem.getDeleted())) {
                    if (repElem.getCreation()) {
                        this.creerRepartitionElementTable(repElem);
                    } else if (repElem.getSuppression()) {
                        this.supprimerRepartitionElementTable(repElem);
                    } else if (repElem.getModif()) {
                        this.modifierRepartitionElementTable(repElem);
                    }
                }
                ++j3;
            }
            ++i;
        }
    }

    private void checkID() {
        int size = this.axes.size();
        int i = 0;
        while (i < size) {
            List<RepartitionElement> repartitionElems = this.repartitionElemsAxe.get(i);
            int repartitionElemsCount = repartitionElems.size();
            List<Poste> postes = this.postesAxe.get(i);
            int postesCount = postes.size();
            List<Repartition> repartitions = this.repartitionsAxe.get(i);
            int repartitionsCount = repartitions.size();
            int j = 0;
            while (j < repartitionElemsCount) {
                RepartitionElement repElem = repartitionElems.get(j);
                if (!repElem.getSuppression() || !repElem.getDeleted()) {
                    int k = 0;
                    while (k < postesCount) {
                        Poste poste = postes.get(k);
                        if (repElem.getIdPoste() == poste.getId() && poste.getSuppression() && poste.getDeleted()) {
                            System.out.println("Probleme repElem " + repElem.toString());
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < repartitionsCount) {
                        Repartition repartition = repartitions.get(k);
                        if (repElem.getIdRep() == repartition.getId() && repartition.getSuppression() && repartition.getDeleted()) {
                            System.out.println("Probleme repElem " + repElem.toString());
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".analytic";
    }
}

