/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import java.text.Format;
import java.util.Date;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PrinterName;
import org.openconcerto.erp.core.sales.pos.io.DefaultTicketPrinter;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.XMLDateFormat;

public class StringStandardPrinter
extends DefaultTicketPrinter {
    private static final Format DATE_FMT = new XMLDateFormat();
    private final String printerName;

    static JobName createJobName(String name) {
        return new JobName(String.valueOf(name) + ' ' + DATE_FMT.format(new Date()), Locale.getDefault());
    }

    public StringStandardPrinter(String printerName) {
        if (StringUtils.isEmpty(printerName, true)) {
            throw new IllegalArgumentException("Missing printer name");
        }
        this.printerName = printerName;
    }

    public final String getPrinterName() {
        return this.printerName;
    }

    @Override
    public void printBuffer() throws Exception {
        HashPrintServiceAttributeSet attrSet = new HashPrintServiceAttributeSet(new PrinterName(this.printerName, null));
        PrintService[] lookupPrintServices = PrintServiceLookup.lookupPrintServices(null, attrSet);
        if (lookupPrintServices.length <= 0) {
            throw new PrintException("Printer " + this.printerName + " not found");
        }
        DocPrintJob job = lookupPrintServices[0].createPrintJob();
        int size = this.strings.size();
        StringBuilder sb = new StringBuilder(size * 50);
        int i = 0;
        while (i < size) {
            sb.append((String)this.strings.get(i));
            sb.append('\n');
            ++i;
        }
        SimpleDoc doc = new SimpleDoc(sb.toString(), DocFlavor.STRING.TEXT_PLAIN, new HashDocAttributeSet(new DocumentName(this.getDocName(), Locale.getDefault())));
        job.print(doc, new HashPrintRequestAttributeSet(StringStandardPrinter.createJobName(this.getDocName())));
    }

    @Override
    public void openDrawer() throws Exception {
    }
}

