/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URL;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.action.NouvelleConnexionAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.NewsChecker;
import org.openconcerto.erp.config.ServerFinderPanel;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.panel.PostgreSQLFrame;
import org.openconcerto.erp.panel.UserExitConf;
import org.openconcerto.erp.panel.UserExitPanel;
import org.openconcerto.erp.preferences.UIPreferencePanel;
import org.openconcerto.erp.rights.ComptaTotalUserRight;
import org.openconcerto.ftp.updater.UpdateManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.RemoteShell;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.request.BaseFillSQLRequest;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.ui.SoftwareInfoPanel;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.component.WaitIndeterminatePanel;
import org.openconcerto.ui.preferences.EmailProps;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.ThrowableHandler;
import org.openconcerto.utils.i18n.TranslationManager;
import org.openconcerto.utils.protocol.Helper;
import org.openconcerto.xml.FastXMLProperties;

public class Gestion {
    static final String MODULES_DIR_NAME = "Modules";
    public static final String MINIMAL_PROP = "org.openconcerto.erp.minimal";
    private static List<Image> frameIcon;
    static final boolean MAC_OS_X;
    private static final PermissionCollection ALL_PERMS;
    public static PostgreSQLFrame pgFrameStart;
    private static JDialog frameExit;

    static {
        MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        AllPermission allPermission = new AllPermission();
        ALL_PERMS = allPermission.newPermissionCollection();
        ALL_PERMS.add(allPermission);
        ALL_PERMS.setReadOnly();
        pgFrameStart = null;
        frameExit = null;
    }

    static boolean inWebStart() {
        try {
            String[] names = (String[])Class.forName("javax.jnlp.ServiceManager").getMethod("getServiceNames", new Class[0]).invoke(null, new Object[0]);
            return names != null && names.length > 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void openPDF(File f) {
        try {
            FileUtils.openFile(f);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Impossible d'ouvrir le fichier " + f + ".\nV\u00e9rifiez qu'un logiciel pour lire les fichiers PDF est install\u00e9 sur votre ordinateur.\nVoir http://get.adobe.com/fr/reader.", "Erreur d'ouverture du PDF", 0);
        }
    }

    public static final boolean isMinimalMode() {
        return Boolean.getBoolean(MINIMAL_PROP);
    }

    private static void initSecurity() {
        String[] extDirs = System.getProperty("java.ext.dirs").split(File.pathSeparator);
        final ArrayList<String> canonExtDirs = new ArrayList<String>(extDirs.length);
        String[] stringArray = extDirs;
        int n = extDirs.length;
        int n2 = 0;
        while (n2 < n) {
            String extDir = stringArray[n2];
            try {
                canonExtDirs.add(new File(extDir).getCanonicalPath());
            }
            catch (IOException e) {
                System.err.println("Couldn't add extension dir : " + extDir);
                e.printStackTrace();
            }
            ++n2;
        }
        final ClassLoader mainLoader = Gestion.class.getClassLoader();
        Policy.setPolicy(new Policy(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean isExt(ProtectionDomain domain) {
                URL location = domain.getCodeSource().getLocation();
                if (!"file".equals(location.getProtocol())) return false;
                try {
                    String canonExtDir;
                    String canonPath = new File(location.toURI()).getCanonicalPath();
                    Iterator iterator = canonExtDirs.iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return false;
                    } while (!canonPath.startsWith(canonExtDir = (String)iterator.next()));
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }

            @Override
            public PermissionCollection getPermissions(ProtectionDomain domain) {
                if (domain != null && (domain.getClassLoader() == mainLoader || this.isExt(domain))) {
                    return ALL_PERMS;
                }
                return super.getPermissions(domain);
            }

            @Override
            public boolean implies(ProtectionDomain domain, Permission permission) {
                if (domain != null && domain.getClassLoader() == mainLoader) {
                    return true;
                }
                return super.implies(domain, permission);
            }
        });
        System.setSecurityManager(new SecurityManager());
    }

    public static void main(String[] args) {
        boolean hasCloud;
        boolean hasManual;
        File f;
        System.setProperty("org.xml.sax.driver", "com.bluecast.xml.Piccolo");
        System.setProperty("org.xml.sax.parser", "com.bluecast.xml.Piccolo");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.bluecast.xml.JAXPSAXParserFactory");
        ComptaPropsConfiguration.checkJava();
        String cwd = new File(System.getProperty("user.dir")).toURI().toString();
        if (cwd.startsWith("file:/private/var/folders")) {
            JOptionPane.showMessageDialog(null, "Vous \u00e9xecutez OpenConcerto depuis la sandbox de MacOS.\nVous devez d\u00e9placer le logiciel dans votre dossier Application.\n\nSi cela ne fonctionne pas, vous pouvez utiliser la commande : \nsudo xattr -r -d com.apple.quarantine /Applications/OpenConcerto", "Sandbox", 0);
            return;
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                ExceptionHandler.handle("UncaughtException on thread " + t, e);
            }
        });
        System.out.println("Java version: " + System.getProperty("java.vendor", "??") + " - " + System.getProperty("java.version", "??"));
        System.out.println("Runtime: Java " + System.getProperty("java.runtime.version", "??") + " - " + System.getProperty("os.name", "??"));
        ExceptionHandler.setForceUI(true);
        ExceptionHandler.setForumURL("http://www.openconcerto.org/forum");
        ExceptionHandler.setSoftwareInformations(SoftwareInfoPanel.FACTORY);
        ExceptionHandler.setShowProbably(true);
        ExceptionHandler.setThrowableHandler(Gestion.createDefaultThrowableHandler());
        ReOrder.setAutoFixNulls(true);
        System.setProperty("SQLRowAccessor.accessDBIfNeeded", "true");
        System.setProperty("redirectToFile", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("org.openconcerto.editpanel.noborder", "true");
        System.setProperty("org.openconcerto.sql.editPanel.endAdd", "true");
        System.setProperty("org.openconcerto.sql.listPanel.deafEditPanel", "true");
        System.setProperty("org.openconcerto.listframe.shortTitle", "true");
        System.setProperty("org.openconcerto.sql.canSaveInList", "false");
        System.setProperty("org.openconcerto.ui.addComboButton", "true");
        System.setProperty("org.openconcerto.sql.structure.useXML", "true");
        System.setProperty("org.openconcerto.sql.requiredSuffix", "");
        System.setProperty("org.openconcerto.sql.comboCanModify", "true");
        System.setProperty("org.openconcerto.ui.removeSwapSearchCheckBox", "true");
        if (System.getProperty("org.openconcerto.oo.useODSViewer") == null) {
            System.setProperty("org.openconcerto.oo.useODSViewer", "true");
        }
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        System.setProperty("org.openconcerto.ui.simpleTraversal", "true");
        TranslationManager.addTranslationStreamFromClass(Gestion.class);
        BaseFillSQLRequest.setDefaultLockSelect(false);
        ComboSQLRequest.setDefaultItemsOrder(CompareUtils.naturalOrder());
        try {
            SplashScreen.getSplashScreen();
        }
        catch (Throwable e) {
            System.out.println("SplashScreen failed... " + e.getMessage());
        }
        UserRightsManager.DEFAULT_MACRO_RIGHTS.add(new ComptaTotalUserRight());
        long t1 = System.currentTimeMillis();
        final ComptaPropsConfiguration conf = ComptaPropsConfiguration.create(true);
        if (conf == null) {
            System.out.println("Unable to create configuration, launching ServerFinderPanel");
            ServerFinderPanel.main(new String[0]);
            return;
        }
        try {
            System.out.println("Application data folder : " + conf.getBaseDirs().getAppDataFolder().getCanonicalPath());
            System.out.println("Application cache folder : " + conf.getBaseDirs().getCacheFolder().getCanonicalPath());
            System.out.println("Application preferences folder : " + conf.getBaseDirs().getPreferencesFolder().getCanonicalPath());
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
        System.out.println("Application working directory folder : " + conf.getWD().getAbsolutePath());
        System.out.println("Modules folders : " + conf.getModuleManager().getFolders().toString());
        if (Gestion.inWebStart()) {
            Helper.setURLStreamHandlerFactory();
            System.setSecurityManager(null);
        }
        Configuration.setInstance(conf);
        ExceptionHandler.setSafeToExit(!conf.getServerIp().contains("file:"));
        try {
            Configuration.migrateToNewDir(conf.getOldDataDir(), conf.getDataDir());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Couldn't migrate data dir", ex);
        }
        final boolean logRequests = Boolean.valueOf(conf.getProperty("logRequests", "false"));
        if (logRequests) {
            SQLRequestLog.setEnabled(true);
        }
        IListFrame.setConfDirFunction(elem -> conf.getConfDir(elem.getTable().getDBRoot()));
        if (Boolean.valueOf(conf.getProperty("minimal", "false")).booleanValue()) {
            System.setProperty(MINIMAL_PROP, Boolean.TRUE.toString());
        }
        if (Boolean.valueOf(conf.getProperty("statelessTable", "false")).booleanValue()) {
            System.setProperty("org.openconcerto.sql.list.statelessTable", Boolean.TRUE.toString());
        }
        System.setProperty("org.openconcerto.oo.useODSViewer", Boolean.TRUE.toString());
        if (conf.getProperty("odsViewer") != null) {
            System.setProperty("org.openconcerto.oo.useODSViewer", Boolean.valueOf(conf.getProperty("odsViewer")).toString());
        }
        if (conf.getProperty("rwOnDoubleClick") != null) {
            System.setProperty("org.openconcerto.sql.listPanel.rwOnDoubleClick", Boolean.valueOf(conf.getProperty("rwOnDoubleClick")).toString());
        }
        RemoteShell.startDefaultInstance(conf.getDirectory(), conf.getRoot());
        UIPreferencePanel.initUIFromPreferences();
        UpdateManager.start();
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        ComboSQLRequest.setDefaultFieldSeparator(" ");
        long t4 = System.currentTimeMillis();
        System.out.println("Ip:" + conf.getServerIp());
        if (conf.getServerIp().startsWith("127.0.0.1:6543") && !(f = new File("PostgreSQL/data/postmaster.pid")).exists()) {
            Gestion.startDB(conf);
        }
        try {
            conf.getSystemRoot();
            conf.getRoot().getTables().iterator().next().getUndefinedID();
        }
        catch (Exception e) {
            SQLException sqlExn;
            String msg;
            System.out.println("Init phase 1 error:" + (System.currentTimeMillis() - t4) + "ms");
            if (conf.getSystem() == SQLSystem.H2 && e.getCause() instanceof SQLException && (msg = (sqlExn = (SQLException)e.getCause()).getErrorCode() == 90020 ? "Base de donn\u00e9e d\u00e9j\u00e0 ouverte." : (sqlExn.getSQLState().equals("08000") ? "Impossible d'ouvrir la base de donn\u00e9e. V\u00e9rifier les permissions.\n" + conf.getServerIp() : null)) != null) {
                try {
                    e.printStackTrace();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(null, msg, "Erreur fatale", 0);
                        }
                    });
                }
                catch (Exception e1) {
                    ExceptionHandler.die("Erreur fatale", e1);
                }
                System.exit(1);
            }
            ExceptionHandler.die("Erreur de connexion \u00e0 la base de donn\u00e9es", e);
        }
        System.out.println("Init phase 1:" + (System.currentTimeMillis() - t1) + "ms");
        final File fTOS = new File(Configuration.getInstance().getConfDir(), "tos.properties");
        final Properties pTOS = new Properties();
        pTOS.setProperty("launchCounter", "1");
        pTOS.setProperty("allowDebug", "false");
        pTOS.setProperty("hasManual", "false");
        pTOS.setProperty("hasCloud", "false");
        if (fTOS.exists()) {
            try {
                FastXMLProperties.load(pTOS, new FileInputStream(fTOS));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (ComptaPropsConfiguration.getInstanceCompta().isOnCloud()) {
            pTOS.setProperty("hasCloud", "true");
        }
        boolean allowDebug = pTOS.getProperty("allowDebug", "false").equals("true");
        ExceptionHandler.setSubmitErrorAutoEnabled(allowDebug);
        int launchCounter = Integer.parseInt(pTOS.getProperty("launchCounter", "0"));
        pTOS.setProperty("launchCounter", String.valueOf(launchCounter + 1));
        Gestion.saveProperties(fTOS, pTOS);
        if (!allowDebug && (launchCounter - 2) % 30 == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] options = new Object[]{"J'accepte", "Non, merci"};
                    int n = JOptionPane.showOptionDialog(null, "Afin d'am\u00e9liorer plus rapidement le logiciel, nous avons int\u00e9gr\u00e9 l'envoi automatique de rapports d'erreur.\nIl contient les informations techniques n\u00e9cessaires \u00e0 la corrections de bugs.\nSouhaitez-vous activer l'envoi automatique ?", "Rapport d'erreur", 0, 3, null, options, options[0]);
                    if (n == 0) {
                        pTOS.setProperty("allowDebug", "true");
                        Gestion.saveProperties(fTOS, pTOS);
                        ExceptionHandler.setSubmitErrorAutoEnabled(true);
                    }
                }
            });
        }
        if (!(hasManual = pTOS.getProperty("hasManual", "false").equals("true")) && (launchCounter - 5) % 100 == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] options = new Object[]{"Je l'ai d\u00e9j\u00e0", "Bonne id\u00e9e!"};
                    int n = JOptionPane.showOptionDialog(null, "Afin de ma\u00eetriser le logiciel, nous conseillons vivement l'acquisition du manuel.\nSon achat vous permet de soutenir les d\u00e9veloppements d'OpenConcerto et d'avoir une documentation papier de plus de 250 pages.\nVous pouvez le commmander avec port gratuit depuis le site internet : https://www.openconcerto.org ", "Le manuel utilisateur", 0, 3, null, options, options[1]);
                    if (n == 0) {
                        pTOS.setProperty("hasManual", "true");
                        Gestion.saveProperties(fTOS, pTOS);
                    } else {
                        try {
                            Desktop.getDesktop().browse(new URI("https://www.openconcerto.org/fr/documentation.html"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        if (!(hasCloud = pTOS.getProperty("hasCloud", "false").equals("true")) && (launchCounter - 30) % 100 == 0 && ComptaPropsConfiguration.getInstanceCompta().isServerless()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Vous utilisez actuellement le logiciel en version monoposte.\nLes donn\u00e9es sont stock\u00e9es sur votre ordinateur, ce qui peut poser probl\u00e8me en cas de vol ou de panne.\nNous proposons une offre cloud qui vous permet de travailler \u00e0 plusieurs et de ne plus avoir \u00e0 vous soucier de la sauvegarde de vos donn\u00e9es.\nVous aurez juste besoin d'une connexion internet.\nPlus d'informations sur https://cloud.openconcerto.org", "Cloud", 1);
                    try {
                        Desktop.getDesktop().browse(new URI("https://cloud.openconcerto.org"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        File fMail2 = new File(Configuration.getInstance().getConfDir(), "Email.properties");
        EmailProps.getInstance().setDefaultPropsFileName(fMail2.toString());
        EmailProps.getInstance().setPropsFileName(fMail2.toString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                block11: {
                    long t1 = System.currentTimeMillis();
                    IListe.setForceAlternateCellRenderer(true);
                    AWTEventListener awtListener = new AWTEventListener(){
                        Set<Integer> frames = new HashSet<Integer>();
                        String prefix;

                        @Override
                        public final void eventDispatched(AWTEvent event) {
                            HierarchyEvent hevent;
                            Component changed;
                            if (!$assertionsDisabled && event == null) {
                                throw new AssertionError();
                            }
                            if (event instanceof HierarchyEvent && event.getID() == 1400 && (changed = (hevent = (HierarchyEvent)event).getChanged()) instanceof JFrame && (hevent.getChangeFlags() & 2L) != 0L && changed.isDisplayable()) {
                                final JFrame frame = (JFrame)changed;
                                frame.setIconImages(Gestion.getFrameIcon());
                                if (!this.frames.contains(frame.hashCode())) {
                                    this.frames.add(frame.hashCode());
                                    frame.addPropertyChangeListener(new PropertyChangeListener(){

                                        @Override
                                        public void propertyChange(PropertyChangeEvent evt) {
                                            String title;
                                            if (prefix == null) {
                                                if (ComptaPropsConfiguration.getInstance() != null && ComptaPropsConfiguration.getInstanceCompta().getRowSociete() != null) {
                                                    prefix = "[" + ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getString("NOM") + "] ";
                                                } else {
                                                    return;
                                                }
                                            }
                                            if ((title = frame.getTitle()) != null && !title.startsWith(prefix)) {
                                                frame.setTitle(String.valueOf(prefix) + title);
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    };
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    if (!$assertionsDisabled && toolkit == null) {
                        throw new AssertionError();
                    }
                    toolkit.addAWTEventListener(awtListener, 32768L);
                    if (logRequests) {
                        SQLRequestLog.showFrame();
                    }
                    JFrame f = null;
                    try {
                        try {
                            f = new NouvelleConnexionAction(conf).createFrame();
                            if (f != null) {
                                f.pack();
                                f.setResizable(false);
                                f.addWindowListener(new WindowAdapter(){

                                    @Override
                                    public void windowClosing(WindowEvent e) {
                                        try {
                                            Gestion.askForExit();
                                        }
                                        catch (Exception ex) {
                                            ex.printStackTrace();
                                            System.exit(2);
                                        }
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            Thread.dumpStack();
                            e.printStackTrace();
                            ExceptionHandler.handle("Erreur lors de la tentative de connexion \u00e0 la base.", e);
                            if (f != null) {
                                FrameUtil.show(f);
                            }
                            System.out.println("Init phase 2:" + (System.currentTimeMillis() - t1) + "ms");
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        if (f != null) {
                            FrameUtil.show(f);
                        }
                        System.out.println("Init phase 2:" + (System.currentTimeMillis() - t1) + "ms");
                        throw throwable;
                    }
                    if (f != null) {
                        FrameUtil.show(f);
                    }
                    System.out.println("Init phase 2:" + (System.currentTimeMillis() - t1) + "ms");
                }
            }
        });
        System.setProperty("org.openconcerto.sql.identifier.allowRemoval", "true");
        NewsChecker.check(pTOS, conf.getConfDir(), conf.getServer().getSQLSystem().equals((Object)SQLSystem.H2));
    }

    private static void saveProperties(File fTOS, Properties pTOS) {
        try {
            FileOutputStream outputStream = new FileOutputStream(fTOS);
            FastXMLProperties.store(pTOS, outputStream, "tos");
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ThrowableHandler createDefaultThrowableHandler() {
        return new ThrowableHandler(){

            @Override
            public boolean handle(String message, Throwable throwable) {
                if (throwable == null) {
                    return false;
                }
                throwable.printStackTrace();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                throwable.printStackTrace(new PrintStream(out));
                String s = new String(out.toByteArray());
                if (s.contains("Database may be already in use")) {
                    JOptionPane.showMessageDialog(null, "Votre base de donn\u00e9es est d\u00e9j\u00e0 en cours d'utilisation.\nEn version monoposte, vous ne pouvez lancer qu'un seul programme OpenConcerto \u00e0 la fois.");
                    System.exit(1);
                    return true;
                }
                if (s.contains("PSQLException: Connexion") && ComptaPropsConfiguration.getInstanceCompta().isOnCloud()) {
                    JOptionPane.showMessageDialog(null, "Suite \u00e0 une coupure de votre connexion internet, vous avez \u00e9t\u00e9 d\u00e9connect\u00e9 du Cloud.\nMerci de red\u00e9marrer le logiciel.");
                    System.exit(1);
                    return true;
                }
                if (s.contains("File corrupted while reading")) {
                    JOptionPane.showMessageDialog(null, "Votre fichier de base de donn\u00e9es est endommag\u00e9.\nLes causes possibles sont vari\u00e9es : probl\u00e8me mat\u00e9riel (m\u00e9moire, disque dur...), coupure brutale du PC, virus, antivirus, erreur de fichiers...\n\nIl vous faudra restaurer votre base de donn\u00e9es depuis une sauvegarde\nou contacter notre service technique pour r\u00e9paration (voir https://www.openconcerto.org).");
                    System.exit(1);
                    return true;
                }
                if (s.contains("h2") && (s.contains("File corrupted while reading") || s.contains("data leaf table"))) {
                    JOptionPane.showMessageDialog(null, "Votre fichier de base de donn\u00e9es est endommag\u00e9.\nLes causes possibles sont vari\u00e9es : probl\u00e8me mat\u00e9riel (m\u00e9moire, disque dur...), coupure brutale du PC, virus, antivirus, erreur de fichiers...\n\nIl vous faudra restaurer votre base de donn\u00e9es depuis une sauvegarde\nou contacter notre service technique pour r\u00e9paration (voir https://www.openconcerto.org).");
                    System.exit(1);
                    return true;
                }
                if (s.contains("/private/var/folders/")) {
                    JOptionPane.showMessageDialog(null, "Votre installation d'OpenConcerto n'est pas correcte!\nOpenConcerto ne doit pas s'executer dans l'app Sandbox de MacOS.\nVeuillez d\u00e9bloquer l'application.");
                    System.exit(1);
                    return true;
                }
                if (s.contains("com.sun.java.swing.plaf.windows.WindowsTableHeaderUI")) {
                    return true;
                }
                if (s.contains("WInputMethod.openCandidateWindow") && s.contains("java.lang.NullPointerException: peer")) {
                    return true;
                }
                if (s.contains("No application is associated with the specified file for this operation") || s.contains("Error message: Package could not be registered")) {
                    JOptionPane.showMessageDialog(null, "Merci d'installer LibreOffice ou tout autre application succeptible d'ouvrir ce fichier");
                    return true;
                }
                if (s.contains("java.net.SocketTimeoutException: connect timed out")) {
                    JOptionPane.showMessageDialog(null, "Le serveur de base de donn\u00e9es n'est pas joignable.\n" + message);
                    return true;
                }
                if (s.contains("java.lang.NoSuchMethodError")) {
                    JOptionPane.showMessageDialog(null, "Un de vos modules n'est pas \u00e0 jour.\n" + message);
                    return true;
                }
                if (s.contains("InvalidTemplateException")) {
                    JOptionPane.showMessageDialog(null, "Votre mod\u00e8le de document n'est pas valide.\n" + message, "Mod\u00e8le incorrect", 0);
                    return true;
                }
                return false;
            }
        };
    }

    private static void startDB(PropsConfiguration conf) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("Lancement de la base de donn\u00e9es");
        PostgreSQLFrame pgFrame = null;
        try {
            pgFrame = new PostgreSQLFrame("D\u00e9marrage en cours");
            pgFrame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println("start DB");
        WaitIndeterminatePanel panel = new WaitIndeterminatePanel(l);
        PanelFrame f = new PanelFrame(panel, "Gestion NX");
        f.setResizable(false);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
        String serverAdr = conf.getProperty("server.ip");
        if (serverAdr.startsWith("127.0.0.1") || serverAdr.startsWith("localhost")) {
            Runtime runtime = Runtime.getRuntime();
            try {
                File file = new File(".\\PostgreSQL\\bin\\");
                if (!file.canWrite()) {
                    ExceptionHandler.die("Vous n'avez pas le droit en \u00e9criture sur la base de donn\u00e9es.\nImpossible de lancer le logiciel!");
                }
                final Process p = runtime.exec(new String[]{"cmd.exe", "/C", "launchPostGres.bat"}, null, file);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            String line = "";
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                                while ((line = reader.readLine()) != null) {
                                    System.out.println(line);
                                }
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            String line = "";
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                                while ((line = reader.readLine()) != null) {
                                    System.err.println(line);
                                }
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }.start();
                try {
                    p.waitFor();
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            System.err.println("L'adresse du serveur n'est pas en local (" + serverAdr + ").");
        }
        panel.taskEnded(0);
        if (pgFrame != null) {
            pgFrame.dispose();
        }
        f.dispose();
        String realIp = "127.0.0.1";
        realIp = Gestion.getIp();
        try {
            pgFrameStart = new PostgreSQLFrame(String.valueOf(realIp) + " port " + "6543");
            pgFrameStart.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getIp() {
        String realIp = "127.0.0.1";
        try {
            InetAddress Ip = InetAddress.getLocalHost();
            realIp = Ip.getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ip = e2.nextElement();
                    String iip = ip.toString().replace('/', ' ').trim();
                    if (!iip.startsWith("192")) continue;
                    return iip;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return realIp;
    }

    public static void askForExit() {
        Gestion.askForExit(UserExitConf.DEFAULT);
    }

    public static void askForExit(UserExitConf conf) {
        JDialog exitDialog = new JDialog();
        exitDialog.setModal(true);
        if (frameExit == null) {
            frameExit = new JDialog();
            frameExit.setTitle("Quitter");
            frameExit.setModal(true);
            frameExit.setIconImages(Gestion.getFrameIcon());
            frameExit.setDefaultCloseOperation(1);
        }
        frameExit.setContentPane(new UserExitPanel(conf));
        frameExit.pack();
        frameExit.setResizable(false);
        frameExit.setLocationRelativeTo(null);
        frameExit.setAlwaysOnTop(true);
        frameExit.setVisible(true);
    }

    public static synchronized List<Image> getFrameIcon() {
        if (frameIcon == null) {
            frameIcon = new ArrayList<Image>();
            int[] sizes = new int[]{16, 32, 48, 96};
            int i = 0;
            while (i < sizes.length) {
                int v = sizes[i];
                try {
                    frameIcon.add(new ImageIcon(Gestion.class.getResource(String.valueOf(v) + ".png")).getImage());
                }
                catch (Exception e) {
                    ExceptionHandler.die("Impossible de charger l'icone de fenetre " + v + ".png");
                }
                ++i;
            }
        }
        return frameIcon;
    }
}

