/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.openconcerto.utils.Log;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static <T extends Exception> T createExn(Class<T> exnClass, String msg, Throwable cause) {
        Exception instance = null;
        try {
            Constructor<T> ctor = exnClass.getConstructor(String.class);
            instance = (Exception)ctor.newInstance(msg);
        }
        catch (Exception exn) {
            throw new IllegalArgumentException(exnClass + " has no working String constructor");
        }
        instance.initCause(cause);
        return (T)instance;
    }

    public static <T extends Throwable, X extends T, Y extends T> X throwExn(T toThrow, Class<X> classX, Class<Y> classY) throws X, Y {
        if (classX.isInstance(toThrow)) {
            throw (Throwable)classX.cast(toThrow);
        }
        throw (Throwable)classY.cast(toThrow);
    }

    public static <T extends RuntimeException> T createRTExn(Class<T> exnClass, String msg, Throwable cause) {
        if (!RuntimeException.class.isAssignableFrom(exnClass)) {
            throw new IllegalArgumentException(exnClass + " is not a Runtime exception");
        }
        return (T)((RuntimeException)ExceptionUtils.createExn(exnClass, msg, cause));
    }

    public static String getStackTrace(Throwable cause) {
        StringWriter res = new StringWriter(8192);
        try (PrintWriter pw = new PrintWriter(res);){
            cause.printStackTrace(pw);
        }
        if (pw.checkError()) {
            Log.get().warning("Error while writing " + cause);
        }
        return res.toString();
    }

    public static void requireEquals(Object a, Object b, String msg) {
        if (!Objects.equals(a, b)) {
            throw new IllegalArgumentException(String.valueOf(msg) + ", expected " + a + " but got " + b);
        }
    }

    public static void requireSame(Object a, Object b, String msg) {
        if (a != b) {
            throw new IllegalArgumentException(String.valueOf(msg) + ", expected same reference to " + a + " but got " + b);
        }
    }

    public static void requireEquals(int a, int b, String msg) {
        if (a != b) {
            throw new IllegalArgumentException(String.valueOf(msg) + ", expected " + a + " but got " + b);
        }
    }
}

