/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Color;
import java.awt.Component;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.utils.GestionDevise;

public class ListEcheanceClientRenderer
extends DefaultTableCellRenderer {
    private static final Color couleurEcheance = new Color(255, 128, 64);
    private final DateFormat dateFormat = DateFormat.getDateInstance(2);
    private static final Color couleur1 = new Color(253, 243, 204);
    private static final Color couleur2 = new Color(225, 254, 207);
    private static final Color couleur3 = new Color(255, 232, 245);
    private static final Color couleurRegCompta = new Color(255, 202, 255);
    private final boolean date;

    public ListEcheanceClientRenderer(boolean date) {
        this.date = date;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ListSQLLine line;
        SQLRowValues row2;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected) {
            this.setForeground(Color.BLACK);
            if (this.date && !((Date)value).after(new Date())) {
                this.setForeground(couleurEcheance);
            }
        }
        if (value instanceof Date) {
            this.setText(this.dateFormat.format((Date)value));
        }
        if (!(value == null || table.getColumnClass(column) != Long.class && table.getColumnClass(column) != BigInteger.class || value.getClass() != Long.class && value.getClass() != BigInteger.class)) {
            this.setText(GestionDevise.currencyToString((Long)value));
        }
        this.setHorizontalAlignment(4);
        if (table.getColumnClass(column) == String.class) {
            this.setHorizontalAlignment(2);
        }
        if ((row2 = (line = ITableModel.getLine(table.getModel(), row)).getRow()).getBoolean("REG_COMPTA").booleanValue()) {
            if (!isSelected) {
                this.setBackground(couleurRegCompta);
            }
        } else {
            int nbRelance = row2.getInt("NOMBRE_RELANCE");
            if (!isSelected) {
                switch (nbRelance) {
                    case 0: {
                        this.setBackground(Color.WHITE);
                        break;
                    }
                    case 1: {
                        this.setBackground(couleur1);
                        break;
                    }
                    case 2: {
                        this.setBackground(couleur2);
                        break;
                    }
                    default: {
                        this.setBackground(couleur3);
                    }
                }
            }
        }
        return this;
    }
}

