/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.protocol;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.openconcerto.utils.FileUtils;

public class JavaSourceFromString
extends SimpleJavaFileObject {
    private final String code;

    public static boolean compile(File outputDir, JavaFileObject ... classes) throws IOException {
        FileUtils.mkdir_p(outputDir);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        Throwable throwable = null;
        Object var4_5 = null;
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);){
            fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(outputDir));
            return compiler.getTask(null, fileManager, null, null, null, Arrays.asList(classes)).call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public JavaSourceFromString(String name, String code) {
        super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
        this.code = code;
    }

    public final String getClassFile() {
        String name = this.getName();
        return String.valueOf(name.substring(1, name.length() - JavaFileObject.Kind.SOURCE.extension.length())) + JavaFileObject.Kind.CLASS.extension;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.code;
    }
}

