/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openconcerto.utils.AbstractXMLDateFormat;

public class XMLDateFormat
extends AbstractXMLDateFormat {
    public XMLDateFormat() {
        this(null, null);
    }

    public XMLDateFormat(TimeZone timezone, Locale aLocale) {
        super(timezone, aLocale);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        GregorianCalendar cal;
        if (obj instanceof GregorianCalendar) {
            cal = (GregorianCalendar)obj;
        } else {
            TimeZone tz;
            Date d;
            if (obj instanceof Calendar) {
                d = ((Calendar)obj).getTime();
                tz = ((Calendar)obj).getTimeZone();
            } else {
                d = (Date)obj;
                tz = this.getTimeZone();
            }
            cal = new GregorianCalendar(tz, this.getLocale());
            cal.setTime(d);
        }
        return toAppendTo.append(factory.newXMLGregorianCalendar(cal).toXMLFormat());
    }

    @Override
    public Date parseObject(String source, ParsePosition pos) {
        try {
            XMLGregorianCalendar res = factory.newXMLGregorianCalendar(source.substring(pos.getIndex()));
            pos.setIndex(source.length());
            TimeZone tz = res.getTimezone() == Integer.MIN_VALUE ? this.tz : null;
            return res.toGregorianCalendar(tz, this.locale, null).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            pos.setErrorIndex(pos.getIndex());
            return null;
        }
    }
}

