/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.convertor.NumberConvertor;

@Immutable
public final class RowRef {
    private final SQLTable table;
    private final List<?> pk;
    private final Number id;

    private static Number convert(SQLTable table, Number n) {
        return n == null ? (Number)null : (Number)NumberConvertor.convertExact(n, table.getKey().getType().getJavaType().asSubclass(Number.class));
    }

    RowRef(SQLTable table, List<?> pk) {
        this(table, pk, false);
    }

    RowRef(SQLTable table, List<?> pk, boolean safe) {
        this(table, Objects.requireNonNull(pk), null, safe);
    }

    RowRef(SQLTable table, Number id) {
        this(table, null, Objects.requireNonNull(id), false);
    }

    private RowRef(SQLTable table, List<?> pk, Number id, boolean safe) {
        assert (pk == null != (id == null));
        if (id != null && !table.isRowable()) {
            throw new IllegalStateException("Not rowable : " + table.getSQLName());
        }
        if (!safe && pk != null && pk.size() != table.getPrimaryKeyFields().size()) {
            throw new IllegalArgumentException("Wrong number of items");
        }
        this.table = Objects.requireNonNull(table);
        if (id != null || table.isRowable()) {
            this.id = RowRef.convert(table, id != null ? (Number)id : (Number)((Number)pk.get(0)));
            this.pk = Collections.singletonList(this.id);
        } else {
            this.id = null;
            this.pk = safe ? pk : CollectionUtils.toImmutableList(pk);
        }
    }

    public final SQLTable getTable() {
        return this.table;
    }

    public final List<?> getPK() {
        return this.pk;
    }

    public final Number getID() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(this.pk, this.table);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RowRef other = (RowRef)obj;
        return this.table.equals(other.table) && this.pk.equals(other.pk);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getTable() + " " + this.getPK();
    }
}

