/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.element;

import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.edm.AttachmentAction;
import org.openconcerto.erp.core.supplychain.order.component.FactureFournisseurSQLComponent;
import org.openconcerto.erp.generationDoc.gestcomm.FactureFournisseurXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.action.ListEvent;
import org.openconcerto.ui.table.PercentTableCellRenderer;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ListMap;

public class FactureFournisseurSQLElement
extends ComptaSQLConfElement {
    public FactureFournisseurSQLElement() {
        super("FACTURE_FOURNISSEUR", "une facture fournisseur", "factures fournisseur");
        MouseSheetXmlListeListener mouseSheetXmlListeListener = new MouseSheetXmlListeListener(FactureFournisseurXmlSheet.class);
        mouseSheetXmlListeListener.setGenerateHeader(true);
        mouseSheetXmlListeListener.setShowHeader(true);
        this.getRowActions().addAll(mouseSheetXmlListeListener.getRowActions());
        if (this.getTable().contains("ATTACHMENTS")) {
            RowAction.PredicateRowAction actionAttachment = new RowAction.PredicateRowAction(new AttachmentAction().getAction(), true);
            actionAttachment.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
            this.getRowActions().add(actionAttachment);
        }
        RowAction actionClone = new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditFrame editFrame = new EditFrame(FactureFournisseurSQLElement.this, EditPanel.CREATION);
                ((FactureFournisseurSQLComponent)editFrame.getSQLComponent()).loadFactureExistante(IListe.get(e).getSelectedId());
                editFrame.setVisible(true);
            }
        }, true, "supplychain.invoice.clone"){

            @Override
            public boolean enabledFor(ListEvent evt) {
                List<SQLRowValues> l = evt.getSelectedRows();
                return l != null && l.size() == 1;
            }
        };
        this.getRowActions().add(actionClone);
        SQLTable tableNum = this.getTable().getTable("NUMEROTATION_AUTO");
        if (tableNum.contains("FACTURE_FOURNISSEUR_START")) {
            NumerotationAutoSQLElement.addClass(this.getClass(), "FACTURE_FOURNISSEUR");
        }
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>();
        s.add("NET_A_PAYER");
        return s;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("NOM");
        l.add("DATE");
        l.add("ID_FOURNISSEUR");
        l.add("T_HT");
        l.add("T_TTC");
        l.add("INFOS");
        l.add("DATE_REGLEMENT");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        ListMap<String, String> map = new ListMap<String, String>();
        map.putCollection(null, "NUMERO", "DATE");
        return map;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("NOM");
        l.add("DATE");
        return l;
    }

    @Override
    protected void _initTableSource(SQLTableModelSource res) {
        super._initTableSource(res);
        BaseSQLTableModelColumn colAvancement = new BaseSQLTableModelColumn("Avancement r\u00e9glement", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return FactureFournisseurSQLElement.this.getAvancement(r);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(FactureFournisseurSQLElement.this.getTable());
                p = (Path)p.add(FactureFournisseurSQLElement.this.getTable().getTable("ECHEANCE_FOURNISSEUR"));
                Path p2 = new Path(FactureFournisseurSQLElement.this.getTable());
                p2 = (Path)p2.add(FactureFournisseurSQLElement.this.getTable().getField("ID_AVOIR_FOURNISSEUR"));
                return CollectionUtils.createSet(new FieldPath(p, "MONTANT"), new FieldPath(p, "REG_COMPTA"), new FieldPath(p, "REGLE"), new FieldPath(p2, "MONTANT_TTC"));
            }
        };
        res.getColumns().add(colAvancement);
        colAvancement.setRenderer(new PercentTableCellRenderer());
    }

    private BigDecimal getAvancement(SQLRowAccessor r) {
        BigDecimal totalAregler;
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("ECHEANCE_FOURNISSEUR"));
        long totalEch = 0L;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.getBoolean("REGLE").booleanValue() || sQLRowAccessor.getBoolean("REG_COMPTA").booleanValue()) continue;
            totalEch += sQLRowAccessor.getLong("MONTANT");
        }
        SQLRowAccessor sQLRowAccessor = r.getForeign("ID_AVOIR_FOURNISSEUR");
        BigDecimal avoirTTC = BigDecimal.ZERO;
        if (sQLRowAccessor != null && !sQLRowAccessor.isUndefined()) {
            avoirTTC = new BigDecimal(sQLRowAccessor.getLong("MONTANT_TTC"));
        }
        if ((totalAregler = new BigDecimal(r.getLong("T_TTC")).subtract(avoirTTC)).signum() > 0 && totalEch > 0L) {
            return totalAregler.subtract(new BigDecimal(totalEch)).divide(totalAregler, DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }

    @Override
    public SQLComponent createComponent() {
        return new FactureFournisseurSQLComponent();
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".invoice.purchase";
    }
}

