/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import org.openconcerto.erp.core.sales.pos.io.AbstractESCPrinter;

public class ESCStandardPrinter
extends AbstractESCPrinter {
    private String printerName;

    public ESCStandardPrinter(String printerName) {
        if (printerName.isEmpty() || printerName.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing printer name");
        }
        this.printerName = printerName;
    }

    public String getPrinterName() {
        return this.printerName;
    }

    @Override
    public void printBuffer() throws Exception {
        this.sendBytes(this.getPrintBufferBytes());
    }

    @Override
    public void openDrawer() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(16);
        out.write(20);
        out.write(1);
        out.write(0);
        out.write(2);
        this.sendBytes(out.toByteArray());
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        out = new ByteArrayOutputStream();
        out.write(16);
        out.write(20);
        out.write(1);
        out.write(1);
        out.write(2);
        this.sendBytes(out.toByteArray());
    }

    private synchronized void sendBytes(byte[] b) throws PrintException {
        HashPrintServiceAttributeSet attrSet = new HashPrintServiceAttributeSet(new PrinterName(this.printerName, null));
        PrintService[] lookupPrintServices = PrintServiceLookup.lookupPrintServices(null, attrSet);
        if (lookupPrintServices.length <= 0) {
            throw new PrintException("Printer " + this.printerName + " not found");
        }
        DocPrintJob job = lookupPrintServices[0].createPrintJob();
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        SimpleDoc doc = new SimpleDoc(b, flavor, null);
        job.print(doc, null);
    }

    public static void main(String[] args) {
        String printer = "EPSON TM-T20 Receipt";
        ESCStandardPrinter prt = new ESCStandardPrinter(printer);
        int col = 42;
        prt.addToBuffer("ILM INFORMATIQUE", 2);
        prt.addToBuffer("");
        prt.addToBuffer("22 place de la liberation");
        prt.addToBuffer("80100 ABBEVILLE");
        prt.addToBuffer("T\u00e9l: 00 00 00 00 00");
        prt.addToBuffer("Fax: 00 00 00 00 00");
        prt.addToBuffer("");
        SimpleDateFormat df = new SimpleDateFormat("EEEE d MMMM yyyy \u00e0 HH:mm");
        prt.addToBuffer(ESCStandardPrinter.formatRight(42, "Le " + df.format(Calendar.getInstance().getTime())));
        prt.addToBuffer("");
        prt.addToBuffer(String.valueOf(ESCStandardPrinter.formatRight(5, "3")) + " " + ESCStandardPrinter.formatLeft(col - 6 - 9, "ILM Informatique") + " " + ESCStandardPrinter.formatRight(8, "3.00"));
        prt.addToBuffer(ESCStandardPrinter.formatLeft(col, "      ======================================="));
        prt.addToBuffer(String.valueOf(ESCStandardPrinter.formatRight(col - 8, "Total")) + ESCStandardPrinter.formatRight(8, "3.00"), 1);
        prt.addToBuffer("");
        prt.addToBuffer("Merci de votre visite, \u00e0 bient\u00f4t.");
        prt.addToBuffer("");
        prt.addToBuffer("01 05042010 00002", 10);
        try {
            prt.printBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

