/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.ooxml;

import com.ibm.icu.math.BigDecimal;
import java.awt.Point;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.openconcerto.utils.StringInputStream;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.ooxml.XLSXDocument;
import org.openconcerto.utils.ooxml.XLSXFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XLSXSheet {
    private int columnCount;
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private static final String MINCELL = "\\$?([A-Z]+)\\$?([0-9]+)";
    private static final Pattern minCellPattern = Pattern.compile("\\$?([A-Z]+)\\$?([0-9]+)");
    private final List<List<Object>> rows;
    private String id;
    private String rId;
    private String name;

    public XLSXSheet(XLSXDocument document, String id, String rId, String name, String xml) throws IOException, ParserConfigurationException, SAXException {
        this.id = id;
        this.rId = rId;
        this.name = name;
        DocumentBuilder dBuilder = document.getDbFactory().newDocumentBuilder();
        Document doc = dBuilder.parse(new StringInputStream(xml, StandardCharsets.UTF_8.name()));
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName("dimension");
        String dimension = nList.item(0).getAttributes().getNamedItem("ref").getNodeValue();
        List<String> parts = StringUtils.fastSplit(dimension, ':');
        Point start = XLSXSheet.resolve(parts.get(0));
        this.startX = start.x;
        this.startY = start.y;
        Point end = XLSXSheet.resolve(parts.size() == 1 ? parts.get(0) : parts.get(1));
        this.endX = end.x;
        this.endY = end.y;
        this.rows = new ArrayList<List<Object>>(end.y - start.y);
        this.columnCount = this.endX - this.startX + 1;
        int i = start.y;
        while (i <= end.y) {
            ArrayList<Object> row = new ArrayList<Object>();
            int j = 0;
            while (j < this.columnCount) {
                row.add(null);
                ++j;
            }
            this.rows.add(row);
            ++i;
        }
        Calendar calendar = Calendar.getInstance();
        NodeList nListRows = doc.getElementsByTagName("row");
        int l1 = nListRows.getLength();
        int i2 = 0;
        while (i2 < l1) {
            Node r = nListRows.item(i2);
            NodeList nListCells = r.getChildNodes();
            int l2 = nListCells.getLength();
            int j = 0;
            while (j < l2) {
                Node c = nListCells.item(j);
                String location = c.getAttributes().getNamedItem("r").getNodeValue();
                Point p = XLSXSheet.resolve(location);
                if (p == null) {
                    throw new IllegalStateException("unable to parse location : " + location);
                }
                int style = 0;
                if (c.getAttributes().getNamedItem("s") != null) {
                    style = Integer.parseInt(c.getAttributes().getNamedItem("s").getNodeValue());
                }
                String type = "n";
                if (c.getAttributes().getNamedItem("t") != null) {
                    type = c.getAttributes().getNamedItem("t").getNodeValue();
                }
                NodeList nListCellParts = c.getChildNodes();
                int l3 = nListCellParts.getLength();
                int k = 0;
                while (k < l3) {
                    Node part = nListCellParts.item(k);
                    if (part.getNodeName().equals("v")) {
                        String value = part.getTextContent();
                        Comparable<Date> cellValue = null;
                        if (type.equals("n")) {
                            XLSXFormat format = document.getFormatFromStyle(style);
                            cellValue = format != null ? (format.isDateFormat() ? XLSXSheet.stringToDate(calendar, value) : new BigDecimal(value)) : new BigDecimal(value);
                        } else if (type.equals("s")) {
                            cellValue = document.getSharedString(Integer.parseInt(value));
                        }
                        this.rows.get(p.y - this.startY).set(p.x - this.startX, cellValue);
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    public Object getValueAt(int col, int row) {
        return this.rows.get(row).get(col);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    static final Point resolve(String ref) {
        Matcher matcher = minCellPattern.matcher(ref);
        if (!matcher.matches()) {
            return null;
        }
        return XLSXSheet.resolve(matcher.group(1), matcher.group(2));
    }

    static final Point resolve(String letters, String digits) {
        return new Point(XLSXSheet.toInt(letters), Integer.parseInt(digits) - 1);
    }

    static final int toInt(String col) {
        if (col.length() < 1) {
            throw new IllegalArgumentException("x cannot be empty");
        }
        col = col.toUpperCase();
        int x = 0;
        int i = 0;
        while (i < col.length()) {
            x = x * 26 + (col.charAt(i) - 65 + 1);
            ++i;
        }
        return x - 1;
    }

    public static final String toStr(int col) {
        if (col < 0) {
            throw new IllegalArgumentException("negative column : " + col);
        }
        ++col;
        int radix = 26;
        StringBuilder chars = new StringBuilder(4);
        while (col > 0) {
            chars.append((char)(65 + (col - 1) % 26));
            col = (col - 1) / 26;
        }
        return chars.reverse().toString();
    }

    static final String getAddress(Point p) {
        if (p.x < 0 || p.y < 0) {
            throw new IllegalArgumentException("negative coordinates : " + p);
        }
        return String.valueOf(XLSXSheet.toStr(p.x)) + (p.y + 1);
    }

    public String getId() {
        return this.id;
    }

    public static Date stringToDate(Calendar c, String d) {
        c.clear();
        c.set(1900, 0, 0);
        c.add(6, Integer.parseInt(d) - 1);
        return c.getTime();
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public int getEndX() {
        return this.endX;
    }

    public int getEndY() {
        return this.endY;
    }

    public String getName() {
        return this.name;
    }

    public String getRId() {
        return this.rId;
    }
}

