/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.BiConsumerExn;

public final class ReentrantEventDispatcher<L, E, X extends Exception> {
    private final ThreadLocal<LinkedList<DispatchingState>> events = new ThreadLocal<LinkedList<DispatchingState>>(){

        @Override
        protected LinkedList<DispatchingState> initialValue() {
            return new LinkedList<DispatchingState>();
        }
    };
    private final BiConsumerExn<L, E, X> callback;

    public ReentrantEventDispatcher() {
        this(null);
    }

    public ReentrantEventDispatcher(BiConsumerExn<L, E, X> callback) {
        this.callback = callback;
    }

    public final void fire(Iterator<L> iter, E evt) throws X {
        this.fire(iter, this.callback, evt);
    }

    public final void fire(Iterator<L> iter, BiConsumerExn<L, E, X> callback, E evt) throws X {
        this.fire(new DispatchingState(iter, callback, evt));
    }

    private final void fire(DispatchingState newTuple) throws X {
        DispatchingState currentTuple;
        LinkedList<DispatchingState> linkedList = this.events.get();
        linkedList.addLast(newTuple);
        while ((currentTuple = linkedList.peekFirst()) != null) {
            Iterator currentIter = (Iterator)currentTuple.get0();
            BiConsumerExn currentCallback = (BiConsumerExn)currentTuple.get1();
            Object currentEvt = currentTuple.get2();
            while (currentIter.hasNext()) {
                Object l = currentIter.next();
                currentCallback.accept(l, currentEvt);
            }
            linkedList.pollFirst();
        }
    }

    private final class DispatchingState
    extends Tuple3<Iterator<L>, BiConsumerExn<L, E, X>, E> {
        public DispatchingState(Iterator<L> iter, BiConsumerExn<L, E, X> callback, E evt) {
            super(Objects.requireNonNull(iter, "Missing iterator"), Objects.requireNonNull(callback, "Missing callback"), evt);
        }
    }
}

