/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidChangeSupport;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public final class ValidatedValueWrapper<T>
implements ValueWrapper<T> {
    private final ValueWrapper<T> delegate;
    private final Set<ITransformer<? super T, ValidState>> validators;
    private ValidState delegateValid;
    private ValidState selfValid;
    private final ValidChangeSupport validSupp;

    public static final <T> ValidatedValueWrapper<T> add(ValueWrapper<T> vw, ITransformer<? super T, ValidState> validator) {
        if (vw instanceof ValidatedValueWrapper) {
            return ((ValidatedValueWrapper)vw).add(validator);
        }
        return new ValidatedValueWrapper<T>(vw, validator);
    }

    public static final <T extends Number> ITransformer<T, ValidState> createTransformer(T min, String belowMin, T max, String aboveMax) {
        return ValidatedValueWrapper.createTransformer(min, false, belowMin, max, aboveMax);
    }

    public static final <T extends Number> ITransformer<T, ValidState> createTransformer(final T min, final boolean minValid, final String belowMin, final T max, final String aboveMax) {
        return new ITransformer<T, ValidState>(){

            @Override
            public ValidState transformChecked(T input) {
                if (input == null) {
                    return ValidState.getTrueInstance();
                }
                int minComp = NumberUtils.compare(input, min);
                if (minComp < 0 || !minValid && minComp == 0) {
                    return ValidState.createCached(false, belowMin);
                }
                if (NumberUtils.compare(input, max) > 0) {
                    return ValidState.createCached(false, aboveMax);
                }
                return ValidState.getTrueInstance();
            }
        };
    }

    private ValidatedValueWrapper(ValueWrapper<T> vw, ITransformer<? super T, ValidState> validator) {
        this.delegate = vw;
        this.validators = new LinkedHashSet<ITransformer<? super T, ValidState>>();
        this.validSupp = new ValidChangeSupport(this);
        ValidListener validL = new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
                ValidatedValueWrapper.this.delegateValid = newValue;
                ValidatedValueWrapper.this.updateValidated();
            }
        };
        validL.validChange(this.delegate, this.delegate.getValidState());
        this.delegate.addValidListener(validL);
        this.delegate.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ValidatedValueWrapper.this.updateValidated();
            }
        });
        this.add(validator);
    }

    public final ValidatedValueWrapper<T> add(ITransformer<? super T, ValidState> validator) {
        this.validators.add(validator);
        this.updateValidated();
        return this;
    }

    private void updateValidated() {
        if (!this.delegateValid.isValid()) {
            this.selfValid = this.delegateValid;
        } else {
            Object value = this.delegate.getValue();
            ValidState valid = ValidState.getTrueInstance();
            for (ITransformer<T, ValidState> validator : this.validators) {
                valid = valid.and(validator.transformChecked(value));
            }
            this.selfValid = valid;
        }
        this.validSupp.fireValidChange(this.selfValid);
    }

    @Override
    public ValidState getValidState() {
        return this.validSupp.getValidState();
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.validSupp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.validSupp.removeValidListener(l);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.delegate.addValueListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.delegate.rmValueListener(l);
    }

    @Override
    public void setValue(T val) {
        this.delegate.setValue(val);
    }

    @Override
    public void resetValue() {
        this.delegate.resetValue();
    }

    @Override
    public T getValue() {
        return this.delegate.getValue();
    }

    @Override
    public JComponent getComp() {
        return this.delegate.getComp();
    }
}

