/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.util.Date;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.text.TextComponentUtils;
import org.openconcerto.ui.preferences.JavaPrefPreferencePanel;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapperFactory;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.PrefType;
import org.openconcerto.utils.text.DocumentFilterList;
import org.openconcerto.utils.text.LimitedSizeDocumentFilter;

public class PrefView<T> {
    private final PrefType<T> type;
    private final int length;
    private final ValueWrapper<T> vw;
    private T defaultValue;
    private final String name;
    private final String prefKey;

    public PrefView(PrefType<T> type, String name, String prefKey) {
        this(type, -1, name, prefKey);
    }

    public PrefView(PrefType<T> type, int length, String name, String prefKey) {
        this.type = type;
        this.length = length;
        this.name = name;
        this.prefKey = prefKey;
        this.vw = this.createVW();
        this.setDefaultValue(this.type.getDefaultValue());
    }

    public final PrefType<T> getType() {
        return this.type;
    }

    public final Class<T> getViewClass() {
        return this.getType().getTypeClass();
    }

    public final int getLength() {
        return this.length;
    }

    public final String getName() {
        return this.name;
    }

    public final String getPrefKey() {
        return this.prefKey;
    }

    protected JComponent createComponent() {
        JComponent comp = Boolean.class.isAssignableFrom(this.getViewClass()) ? new JCheckBox(" ") : (Date.class.isAssignableFrom(this.getViewClass()) ? new JDate() : (String.class.isAssignableFrom(this.getViewClass()) && this.getLength() >= 512 ? new ITextArea() : new JTextField()));
        return comp;
    }

    protected ValueWrapper<T> createVW() {
        Document doc;
        JComponent comp = this.createComponent();
        if (this.getLength() > 0 && (doc = TextComponentUtils.getDocument(comp)) instanceof AbstractDocument) {
            DocumentFilterList.add((AbstractDocument)doc, new LimitedSizeDocumentFilter(this.getLength()), DocumentFilterList.FilterType.SIMPLE_FILTER);
        }
        return ValueWrapperFactory.create(comp, this.getViewClass());
    }

    public final ValueWrapper<T> getVW() {
        return this.vw;
    }

    public void init(JavaPrefPreferencePanel prefPanel) {
    }

    public final PrefView<T> setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public final T getDefaultValue() {
        return this.defaultValue;
    }

    final void resetViewValue() {
        this.getVW().setValue(this.getDefaultValue());
    }

    final void setViewValue(Preferences prefs) {
        this.getVW().setValue(this.getPrefValue(prefs));
    }

    private final T getPrefValue(Preferences prefs) {
        return this.getType().get(prefs, this.getPrefKey(), this.getDefaultValue());
    }

    final boolean equalsToPrefValue(Preferences prefs) {
        return CompareUtils.equals(this.getPrefValue(prefs), this.getVW().getValue());
    }

    final void setPrefValue(Preferences prefs) {
        Object val = this.getVW().getValue();
        if (val == null) {
            prefs.remove(this.getPrefKey());
        } else {
            this.getType().put(prefs, this.getPrefKey(), val);
        }
    }
}

