/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.ReloadPanel;
import org.openconcerto.ui.SwingThrottle;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.ui.login.Company;
import org.openconcerto.ui.login.CompanyIListModel;
import org.openconcerto.ui.login.ConnectionStateListener;
import org.openconcerto.ui.login.LoginProperties;
import org.openconcerto.ui.valuewrapper.EmptyValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapperFactory;
import org.openconcerto.utils.Base64;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.i18n.TM;
import org.openconcerto.utils.i18n.TranslationManager;
import org.openconcerto.utils.jsonrpc.JSONRPCClient;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class LoginFrame
extends JFrame
implements ActionListener,
ConnectionStateListener {
    public static final int CONNECTION_NOT_INITIATED = -1;
    public static final int CONNECTION_INPROGRESS = 0;
    public static final int CONNECTION_OK = 1;
    public static final int CONNECTION_TIMEOUT = 2;
    public static final int CONNECTION_REFUSED = 3;
    public static final int CONNECTION_BROKEN = 4;
    private final LoginProperties loginProperties;
    private EmptyValueWrapper<String> textLogin;
    private JPasswordField textPassWord;
    private String encryptedPassword;
    private String clearPassword;
    private boolean allowStoredPass = true;
    private ISearchableCombo<Company> comboCompany;
    private ReloadPanel reloadPanel;
    private CompanyIListModel model;
    private final JCheckBox saveCheckBox = new JCheckBox(this.getTM().translate("loginPanel.storePass", new Object[0]));
    private final JButton buttonConnect = new JButton(this.getTM().translate("loginPanel.loginAction", new Object[0]));
    private final JLabel loginLabel = new JLabel(this.getTM().translate("loginPanel.loginLabel", new Object[0]));
    private final JLabel passwordLabel = new JLabel(this.getTM().translate("loginPanel.passLabel", new Object[0]));
    private final JLabel companyLabel = new JLabel(this.getTM().translate("loginPanel.companyLabel", new Object[0]));
    private String localeBaseName = null;
    private final List<Locale> localesToDisplay = new ArrayList<Locale>();
    private final JButton langButton = new JButton(Locale.ROOT.getLanguage());
    private String company;
    private final JSONRPCClient client;
    private int connectionState = -1;
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private final String serverUrl;
    private String context;
    private int idCompany;
    private SwingThrottle tCheckValidity;
    private static MessageDigest md;

    public LoginFrame(String serverUrl, JSONRPCClient client, String context) throws IOException {
        this.client = client;
        this.serverUrl = serverUrl;
        this.context = context;
        this.setContentPane(this.createLoginPanel());
        System.err.println("LoginFrame.LoginFrame()" + serverUrl);
        this.loginProperties = new LoginProperties(serverUrl);
        this.loginProperties.load();
        Company storedDefaultCompany = new Company(this.loginProperties.getLastCompanyId(), this.loginProperties.getLastCompanyName());
        this.init(this.loginProperties.getLastLoginName(), this.loginProperties.getEncryptedStoredPassword(), storedDefaultCompany);
    }

    public synchronized int getConnectionState() {
        return this.connectionState;
    }

    public synchronized void setConnectionState(int connectionState) {
        this.connectionState = connectionState;
    }

    private TM getTM() {
        return TM.getInstance();
    }

    private void init(String storedLogin, String storedEncryptedPassword, Company storedDefaultCompany) {
        this.textLogin.setValue(storedLogin);
        if (this.saveCheckBox != null && storedEncryptedPassword != null && storedEncryptedPassword.length() > 0) {
            this.saveCheckBox.setSelected(true);
        }
        if (storedEncryptedPassword != null) {
            char[] s = new char[8];
            Arrays.fill(s, ' ');
            this.textPassWord.setText(new String(s));
            this.clearPassword = null;
        } else {
            this.clearPassword = "";
        }
        this.model = new CompanyIListModel();
        this.comboCompany.initCache(this.model);
        this.tCheckValidity = new SwingThrottle(800, new Runnable(){

            @Override
            public void run() {
                LoginFrame.this.checkValidity();
            }
        });
    }

    private JPanel createLoginPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        JImage imageLogo = new JImage(LoginFrame.class.getResource("OpenConcerto_login.png"));
        imageLogo.setBackground(Color.WHITE);
        imageLogo.check();
        panel.add((Component)imageLogo, c);
        ++c.gridy;
        c.gridwidth = 0;
        panel.add((Component)new JSeparator(0), c);
        c.insets = new Insets(2, 2, 1, 2);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.loginLabel.setHorizontalAlignment(4);
        panel.add((Component)this.loginLabel, c);
        this.textLogin = new EmptyValueWrapper<String>(ValueWrapperFactory.create(new JTextField(), String.class));
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)this.textLogin.getComp(), c);
        ((JTextField)this.textLogin.getComp()).addActionListener(this);
        this.textLogin.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoginFrame.this.tCheckValidity.execute();
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        System.err.println("LoginFrame.createLoginPanel()22c");
        this.passwordLabel.setHorizontalAlignment(4);
        panel.add((Component)this.passwordLabel, c);
        this.textPassWord = new JPasswordField();
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)this.textPassWord, c);
        this.textPassWord.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                LoginFrame.this.clearPassword = String.valueOf(LoginFrame.this.textPassWord.getPassword());
                LoginFrame.this.tCheckValidity.execute();
            }
        });
        this.textPassWord.addActionListener(this);
        System.err.println("LoginFrame.createLoginPanel()22d");
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.companyLabel.setHorizontalAlignment(4);
        panel.add((Component)this.companyLabel, c);
        this.comboCompany = new ISearchableCombo(true);
        this.comboCompany.setEnabled(false);
        ++c.gridx;
        panel.add(this.comboCompany, c);
        JPanel panelButton = new JPanel();
        panelButton.setOpaque(false);
        panelButton.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.weightx = 1.0;
        if (this.allowStoredPass) {
            this.saveCheckBox.setOpaque(false);
            panelButton.add((Component)this.saveCheckBox, c2);
            c2.weightx = 0.0;
        }
        ++c2.gridx;
        this.langButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                Locale locale = Locale.getDefault();
                for (final Locale l : LoginFrame.this.localesToDisplay) {
                    JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(l.getDisplayName(l));
                    if (l.equals(locale)) {
                        menuItem.setSelected(true);
                    }
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LoginFrame.this.setUILanguage(l);
                        }
                    });
                }
                menu.show(LoginFrame.this.langButton, 0, 0);
            }
        });
        this.langButton.setOpaque(false);
        this.langButton.setBorderPainted(false);
        this.langButton.setContentAreaFilled(false);
        this.langButton.setBorder(null);
        this.langButton.setFocusable(false);
        this.langButton.setVisible(false);
        panelButton.add((Component)this.langButton, c2);
        ++c2.gridx;
        this.reloadPanel = new ReloadPanel();
        this.reloadPanel.setOpaque(false);
        this.reloadPanel.setMode(2);
        panelButton.add((Component)this.reloadPanel, c2);
        ++c2.gridx;
        c2.weightx = 0.0;
        this.buttonConnect.setEnabled(false);
        this.buttonConnect.setOpaque(false);
        panelButton.add((Component)this.buttonConnect, c2);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.weighty = 1.0;
        panel.add((Component)panelButton, c);
        this.buttonConnect.addActionListener(this);
        this.initLocalization("org.openconcerto.ui.login.Messages", Arrays.asList(Locale.FRANCE, Locale.CANADA_FRENCH, new Locale("fr", "CH"), new Locale("fr", "BE"), Locale.UK, Locale.CANADA, Locale.US, Locale.GERMANY, new Locale("de", "CH")));
        this.setUILanguage(Locale.getDefault());
        return panel;
    }

    private void checkValidity() {
        String login = this.textLogin.getValue();
        this.buttonConnect.setEnabled(login != null && !login.trim().isEmpty() && this.comboCompany.getSelectedItem() != null);
        System.err.println("LoginFrame.checkValidity()");
        String ePassword = this.encryptedPassword;
        if (ePassword == null) {
            if (this.clearPassword == null) {
                this.clearPassword = "";
            }
            ePassword = LoginFrame.encodePassword(this.clearPassword);
        }
        if (login == null || login.trim().isEmpty()) {
            return;
        }
        this.reloadPanel.setMode(0);
        try {
            this.sendAllowedCompanyRequest(login, ePassword);
        }
        catch (Exception e) {
            this.reloadPanel.setMode(1);
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.comboCompany.getSelectedItem() == null) {
            return;
        }
        this.setEnabled(false);
        this.reloadPanel.setMode(0);
        String ePassword = this.encryptedPassword;
        if (ePassword == null) {
            if (this.clearPassword == null) {
                this.clearPassword = "";
            }
            ePassword = LoginFrame.encodePassword(this.clearPassword);
        }
        this.company = this.comboCompany.getSelectedItem().getName();
        this.sendLoginRequest(this.textLogin.getValue(), ePassword, this.comboCompany.getSelectedItem().getId(), this.context);
    }

    @Override
    public void stateChanged(int oldState, final int newState) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalAccessError("Must not be called in EventDispatchThread");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (newState == 3 || newState == 2) {
                    LoginFrame.this.reloadPanel.setMode(1);
                } else if (newState == 1) {
                    LoginFrame.this.reloadPanel.setMode(2);
                } else {
                    LoginFrame.this.reloadPanel.setMode(1);
                }
            }
        });
    }

    @Override
    public void setAllowedCompanies(final List<Company> list) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalAccessError("Must not be called in EventDispatchThread");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoginFrame.this.model.updateFrom(list);
                if (!list.isEmpty()) {
                    LoginFrame.this.comboCompany.setEnabled(true);
                    for (Company company : list) {
                        if (company.getId() != LoginFrame.this.loginProperties.getLastCompanyId()) continue;
                        LoginFrame.this.comboCompany.setValue(company);
                        break;
                    }
                    if (LoginFrame.this.comboCompany.getSelectedItem() == null) {
                        LoginFrame.this.comboCompany.setSelectedIndex(0);
                    }
                    LoginFrame.this.buttonConnect.setEnabled(!((String)LoginFrame.this.textLogin.getValue()).trim().isEmpty() && LoginFrame.this.comboCompany.getSelectedItem() != null);
                } else {
                    LoginFrame.this.buttonConnect.setEnabled(false);
                }
                LoginFrame.this.reloadPanel.setMode(2);
            }
        });
    }

    @Override
    public void setEnabled(boolean b) {
        if (b) {
            this.reloadPanel.setMode(2);
        }
        this.textLogin.getComp().setEnabled(b);
        this.textPassWord.setEnabled(b);
        this.comboCompany.setEnabled(b);
        this.saveCheckBox.setEnabled(b);
        this.buttonConnect.setEnabled(b);
    }

    private final void initLocalization(String baseName, List<Locale> toDisplay) {
        if (baseName == null) {
            throw new NullPointerException("Null baseName");
        }
        if (this.localeBaseName != null) {
            throw new IllegalStateException("Already inited to " + this.localeBaseName);
        }
        this.localeBaseName = baseName;
        this.localesToDisplay.addAll(toDisplay);
        TM.getInstance();
    }

    private void setUILanguage(Locale locale) {
        System.err.println("LoginFrame.setUILanguage():" + this.localeBaseName + " locale:" + locale);
        ResourceBundle bundle = ResourceBundle.getBundle(this.localeBaseName, locale, TranslationManager.getControl());
        this.loginLabel.setText(bundle.getString("loginLabel"));
        this.passwordLabel.setText(bundle.getString("passwordLabel"));
        this.companyLabel.setText(bundle.getString("companyLabel"));
        this.saveCheckBox.setText(bundle.getString("saveCheckBox"));
        this.buttonConnect.setText(bundle.getString("buttonConnect"));
        this.langButton.setText(locale.getLanguage());
        this.langButton.setVisible(true);
        Locale.setDefault(locale);
    }

    private static synchronized MessageDigest getMessageDigest() {
        if (md == null) {
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("no SHA1", e);
            }
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodePassword(String clearPassword) {
        byte[] s;
        MessageDigest messageDigest = LoginFrame.getMessageDigest();
        synchronized (messageDigest) {
            LoginFrame.getMessageDigest().reset();
            LoginFrame.getMessageDigest().update(clearPassword.getBytes());
            s = LoginFrame.getMessageDigest().digest();
        }
        return Base64.encodeBytes(s);
    }

    public String getCompany() {
        return this.company;
    }

    public void saveAndDispose() throws IOException {
        this.loginProperties.setLastCompanyId(this.comboCompany.getSelectedItem().getId());
        this.loginProperties.setLastCompanyName(this.comboCompany.getSelectedItem().getName());
        this.loginProperties.setLastLoginName(this.textLogin.getValue());
        this.loginProperties.store();
        this.dispose();
    }

    private void sendAllowedCompanyRequest(final String login, final String passwordHash) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                LoginFrame.this.client.setCredentials(login, passwordHash);
                JSONObject params = new JSONObject();
                params.put("login", login);
                try {
                    JSONObject result = LoginFrame.this.client.rpcCall(LoginFrame.this.serverUrl, "getAllowedCompanies", params);
                    JSONArray array = (JSONArray)result.get("companies");
                    ArrayList<Company> list = new ArrayList<Company>();
                    for (Object o : array) {
                        Company c = new Company();
                        c.fromJSON((JSONObject)o);
                        list.add(c);
                    }
                    LoginFrame.this.setAllowedCompanies(list);
                }
                catch (IOException e) {
                    LoginFrame.this.setAllowedCompanies(Collections.emptyList());
                    e.printStackTrace();
                }
            }
        });
    }

    private void sendLoginRequest(final String login, final String encodedPassword, final int idCompany, final String context) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                LoginFrame.this.stateChanged(LoginFrame.this.getConnectionState(), 0);
                LoginFrame.this.client.setCredentials(login, encodedPassword);
                JSONObject params = new JSONObject();
                params.put("company-id", idCompany);
                params.put("context", context);
                try {
                    JSONObject result = LoginFrame.this.client.rpcCall(LoginFrame.this.serverUrl, "login", params);
                    if (result.getAsString("status").equals("granted")) {
                        LoginFrame.this.idCompany = idCompany;
                        LoginFrame.this.stateChanged(LoginFrame.this.getConnectionState(), 1);
                    } else {
                        LoginFrame.this.stateChanged(LoginFrame.this.getConnectionState(), 3);
                    }
                }
                catch (IOException e) {
                    LoginFrame.this.stateChanged(LoginFrame.this.getConnectionState(), 4);
                }
            }
        });
    }

    public int getCompanyId() {
        return this.idCompany;
    }
}

