/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.UIManager;
import org.openconcerto.utils.OSFamily;

public class FrameUtil {
    public static void show(Window frame) {
        frame.setVisible(true);
        if (frame instanceof Frame) {
            ((Frame)frame).setState(0);
        }
        frame.toFront();
    }

    public static String getNimbusClassName() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
            if ("Nimbus".equals(info.getName())) {
                return info.getClassName();
            }
            ++n2;
        }
        return null;
    }

    public static void showPacked(Frame frame) {
        frame.pack();
        frame.setMinimumSize(new Dimension(frame.getWidth(), frame.getHeight()));
        FrameUtil.show(frame);
    }

    public static final void setBounds(Window w) {
        w.setBounds(FrameUtil.getWindowBounds());
    }

    private static final int getArea(GraphicsConfiguration gc) {
        Rectangle dm = gc.getBounds();
        return dm.width * dm.height;
    }

    public static final Rectangle getWindowBounds() {
        Rectangle dm;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        if (screens.length > 1 && OSFamily.getInstance() == OSFamily.Linux) {
            GraphicsConfiguration largest = null;
            GraphicsDevice[] graphicsDeviceArray = screens;
            int n = screens.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsDevice screen = graphicsDeviceArray[n2];
                GraphicsConfiguration current = screen.getDefaultConfiguration();
                if (largest == null || FrameUtil.getArea(current) > FrameUtil.getArea(largest)) {
                    largest = current;
                }
                ++n2;
            }
            assert (largest != null);
            dm = new Rectangle(largest.getBounds());
        } else {
            dm = new Rectangle(ge.getMaximumWindowBounds());
        }
        dm.grow(dm.getWidth() <= 800.0 ? -20 : -50, dm.getHeight() <= 600.0 ? -20 : -50);
        return dm;
    }

    public static void main(String[] args) {
        System.out.println("getWindowBounds(): " + FrameUtil.getWindowBounds());
    }
}

