/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.ui.light.LightUIComboBoxElement;
import org.openconcerto.ui.light.LightUIComboRequest;

public class LightUISQLComboRequest
implements LightUIComboRequest {
    private static final Pattern QUERY_SPLIT_PATTERN = Pattern.compile("\\s+");
    private final ComboSQLRequest request;

    public LightUISQLComboRequest(ComboSQLRequest request) {
        this.request = request;
    }

    @Override
    public List<LightUIComboBoxElement> getItems(String filter, Optional<LightUIComboBoxElement> selection) {
        Where where = selection.isPresent() ? new Where((FieldRef)this.request.getPrimaryTable().getKey(), "=", selection.get().getId()) : null;
        List<IComboSelectionItem> items = this.request.getComboItems(true, Arrays.asList(QUERY_SPLIT_PATTERN.split(filter)), Locale.getDefault(), where);
        ArrayList<LightUIComboBoxElement> res = new ArrayList<LightUIComboBoxElement>(items.size());
        for (IComboSelectionItem item : items) {
            res.add(new LightUIComboBoxElement(item.getId(), item.getLabel()));
        }
        return res;
    }
}

