/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.component.HTMLTextField;
import org.openconcerto.utils.BaseDirs;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.SystemInfo;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.utils.i18n.I18nUtils;

public class SoftwareInfoPanel
extends JPanel {
    public static final IFactory<String> FACTORY = new IFactory<String>(){

        @Override
        public String createChecked() {
            return SoftwareInfoPanel.get(false, Locale.ENGLISH).toString();
        }
    };
    private final FormLayouter l = new FormLayouter(this, 1);

    public static Map<Info, String> get(boolean html, Locale locale) {
        String version;
        String name;
        ProductInfo productInfo;
        PropsConfiguration propsConf;
        Configuration conf;
        HashMap<Info, String> res = new HashMap<Info, String>();
        UserRightsManager userRightsManager = UserRightsManager.getInstance();
        res.put(Info.RIGHTS, org.openconcerto.utils.i18n.TM.tr(locale, I18nUtils.getYesNoKey(userRightsManager != null), new Object[0]));
        User user = UserManager.getUser();
        if (user != null) {
            UserRights userRights = UserRightsManager.getCurrentUserRights();
            res.put(Info.USER, String.valueOf(user.toString()) + (userRights.isSuperUser() ? " (superuser)" : ""));
        }
        if ((conf = Configuration.getInstance()) instanceof PropsConfiguration) {
            propsConf = (PropsConfiguration)conf;
            productInfo = propsConf.getProductInfo();
        } else {
            propsConf = null;
            productInfo = ProductInfo.getInstance();
        }
        if (productInfo == null) {
            name = TM.tr(locale, "infoPanel.noAppName", new Object[0]);
            version = TM.tr(locale, "infoPanel.noVersion", new Object[0]);
        } else {
            name = productInfo.getName();
            version = productInfo.getProperty("VERSION", TM.tr(locale, "infoPanel.noVersion", new Object[0]));
        }
        res.put(Info.APP_NAME, name);
        res.put(Info.APP_VERSION, version);
        if (propsConf != null && propsConf.isUsingSSH()) {
            Tuple2<String, Integer> serverAddressAndPort = propsConf.parseServerAddressAndPort();
            res.put(Info.SECURE_LINK, "localhost:" + propsConf.getTunnelLocalPort() + " \u27f7 (" + propsConf.getWanHostAndPort() + ") " + serverAddressAndPort.get0() + ":" + serverAddressAndPort.get1());
        }
        if (conf != null) {
            res.put(Info.DB_URL, conf.getSystemRoot().getDataSource().getUrl());
        }
        if (conf != null) {
            String logs = propsConf == null ? "" : " ; " + SystemInfo.getLink(TM.tr(locale, "infoPanel.logs", new Object[0]), propsConf.getLogDir().toURI(), html);
            BaseDirs baseDirs = conf.getBaseDirs();
            String dirs = " ; " + SystemInfo.getLink(TM.tr(locale, "infoPanel.dataDir", new Object[0]), baseDirs.getAppDataFolder().toURI(), html);
            dirs = String.valueOf(dirs) + " ; " + SystemInfo.getLink(TM.tr(locale, "infoPanel.prefsDir", new Object[0]), baseDirs.getPreferencesFolder().toURI(), html);
            dirs = String.valueOf(dirs) + " ; " + SystemInfo.getLink(TM.tr(locale, "infoPanel.cacheDir", new Object[0]), baseDirs.getCacheFolder().toURI(), html);
            res.put(Info.DIRS, String.valueOf(SystemInfo.getLink(TM.tr(locale, "infoPanel.docs", new Object[0]), conf.getWD().toURI(), html)) + logs + dirs);
        }
        return res;
    }

    public SoftwareInfoPanel(Locale locale) {
        this.refresh(locale);
    }

    public final void refresh(Locale locale) {
        String dirs;
        JLabel dbURL;
        this.l.clear();
        Map<Info, String> infos = SoftwareInfoPanel.get(true, locale);
        this.l.add(TM.tr(locale, "infoPanel.rights", new Object[0]), new JLabel(infos.get((Object)Info.RIGHTS)));
        String user = infos.get((Object)Info.USER);
        if (user != null) {
            this.l.add(org.openconcerto.utils.i18n.TM.tr(locale, "user", new Object[0]), new JLabel(user));
        }
        this.l.add(TM.tr(locale, "infoPanel.appName", new Object[0]), new JLabel(infos.get((Object)Info.APP_NAME)));
        this.l.add(TM.tr(locale, "infoPanel.version", new Object[0]), new JLabel(infos.get((Object)Info.APP_VERSION)));
        String secureLink = infos.get((Object)Info.SECURE_LINK);
        if (secureLink != null) {
            this.l.add(TM.tr(locale, "infoPanel.secureLink", new Object[0]), new JLabel(secureLink));
        }
        if ((dbURL = new JLabel(infos.get((Object)Info.DB_URL))) != null) {
            this.l.add(TM.tr(locale, "infoPanel.dbURL", new Object[0]), dbURL);
        }
        if ((dirs = infos.get((Object)Info.DIRS)) != null) {
            this.l.add(TM.tr(locale, "infoPanel.dirs", new Object[0]), new HTMLTextField(dirs));
        }
        this.l.getComponent().revalidate();
    }

    public static enum Info {
        RIGHTS,
        USER,
        APP_NAME,
        APP_VERSION,
        SECURE_LINK,
        DB_URL,
        DIRS;

    }
}

