/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.AbstractPath;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;

public class PathBuilder
extends AbstractPath<PathBuilder> {
    private final List<SQLTable> tables;
    private final List<Step> fields;
    private final List<SQLField> singleFields;

    public PathBuilder(SQLTable start) {
        this.tables = new ArrayList<SQLTable>();
        this.fields = new ArrayList<Step>();
        this.singleFields = new ArrayList<SQLField>();
        this.tables.add(start);
    }

    public PathBuilder(Step step) {
        this.tables = new ArrayList<SQLTable>();
        this.tables.add(step.getFrom());
        this.tables.add(step.getTo());
        this.fields = new ArrayList<Step>();
        this.fields.add(step);
        this.singleFields = new ArrayList<SQLField>();
        this.singleFields.add(step.getSingleField());
    }

    public PathBuilder(Path p) {
        this.tables = new ArrayList<SQLTable>(p.getTables());
        this.fields = new ArrayList<Step>(p.getSteps());
        this.singleFields = new ArrayList<SQLField>(p.getSingleFields());
    }

    public final Path build() {
        return Path.create(this.tables, this.fields, this.singleFields);
    }

    @Override
    public List<SQLTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    protected final PathBuilder _append(Path p) {
        this.fields.addAll(p.getSteps());
        this.singleFields.addAll(p.getSingleFields());
        this.tables.addAll(p.getTables().subList(1, p.getTables().size()));
        return this;
    }

    @Override
    public final PathBuilder add(Step step) {
        this.check(step.getFrom());
        this.fields.add(step);
        this.singleFields.add(step.getSingleField());
        this.tables.add(step.getTo());
        return this;
    }

    @Override
    public PathBuilder addTables(List<String> names) {
        PathBuilder res = this;
        for (String name : names) {
            res = (PathBuilder)res.addTable(name);
        }
        return res;
    }

    @Override
    public PathBuilder addForeignFields(String ... fieldsNames) {
        PathBuilder res = this;
        String[] stringArray = fieldsNames;
        int n = fieldsNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            res = (PathBuilder)res.addForeignField(name);
            ++n2;
        }
        return res;
    }

    @Override
    public final List<Step> getSteps() {
        return Collections.unmodifiableList(this.fields);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.tables + "\n\tLinks:" + this.fields;
    }
}

