/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils.correct;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;

public class RenumberMouvement
extends Changer<DBRoot> {
    private Date dateMin;

    public RenumberMouvement(DBSystemRoot b) {
        super(b);
    }

    public final void setDateMin(Date dateMin) {
        this.dateMin = dateMin;
    }

    @Override
    public void setUpFromSystemProperties() {
        super.setUpFromSystemProperties();
        String dateMin = System.getProperty("mvt.dateMin", "").trim();
        if (dateMin.length() > 0) {
            this.setDateMin(Date.valueOf(dateMin));
        }
    }

    @Override
    protected void changeImpl(DBRoot societeRoot) throws SQLException {
        int firstNumber;
        SQLTable ecritureT = societeRoot.getTable("ECRITURE");
        SQLField dateF = ecritureT.getField("DATE");
        SQLField mvtF = ecritureT.getField("ID_MOUVEMENT");
        SQLTable mvtT = ecritureT.getForeignTable(mvtF.getName());
        SQLSelect sel = new SQLSelect();
        sel.addSelectFunctionStar("count");
        sel.addFrom(ecritureT);
        sel.setWhere(new Where((FieldRef)mvtF, "=", mvtT.getUndefinedID()));
        int count = ((Number)this.getDS().executeScalar(sel.asString())).intValue();
        if (count != 0) {
            throw new IllegalStateException(String.valueOf(count) + " ecritures on undefined mouvement");
        }
        sel = new SQLSelect();
        sel.addSelect(mvtF);
        sel.addSelectFunctionStar("count");
        sel.addFrom(ecritureT);
        sel.addGroupBy(mvtF);
        sel.setHaving(Where.createRaw("min(" + dateF.getFieldRef() + ") != max(" + dateF.getFieldRef() + ")", dateF));
        List mixedMvts = this.getDS().executeCol(sel.asString());
        if (mixedMvts.size() > 0) {
            throw new IllegalStateException(String.valueOf(mixedMvts.size()) + " mouvement(s) with mixed dates : " + mixedMvts);
        }
        if (this.dateMin == null) {
            firstNumber = 1;
        } else {
            SQLSelect selID = this.createSelect(dateF, mvtF, null);
            SQLSelect selFirstNumber = new SQLSelect();
            selFirstNumber.addSelect(mvtT.getField("NUMERO"), "max");
            selFirstNumber.setWhere(Where.createRaw(String.valueOf(mvtT.getKey().getFieldRef()) + " in ( " + selID + " )", new FieldRef[0]));
            firstNumber = ((Number)this.getDS().executeScalar(selFirstNumber.asString())).intValue() + 1;
        }
        final UpdateBuilder update = new UpdateBuilder(mvtT);
        update.addVirtualJoin("(" + this.createSelect(dateF, mvtF, firstNumber).asString() + ")", "m", "ID_MOUVEMENT");
        update.setFromVirtualJoinField("NUMERO", "m", "rn");
        int updatedCount = this.getDS().useConnection(new ConnectionHandlerNoSetup<Integer, SQLException>(){

            @Override
            public Integer handle(SQLDataSource ds) throws SQLException, SQLException {
                Statement stmt = ds.getConnection().createStatement();
                int res = stmt.executeUpdate(update.asString());
                stmt.close();
                return res;
            }
        });
        String date = this.dateMin != null ? " at or after " + this.dateMin : "";
        this.getStream().println("Updated " + updatedCount + " rows" + date + " numbering from " + firstNumber);
    }

    protected SQLSelect createSelect(SQLField dateF, SQLField mvtF, Integer offset) {
        String func = "min";
        String funcCall = "min(" + dateF.getFieldRef() + ")";
        SQLSelect sel = new SQLSelect();
        sel.addSelect(mvtF);
        if (offset != null) {
            sel.addSelect(dateF, "min");
            sel.addRawSelect("row_number() OVER (ORDER BY " + funcCall + "," + mvtF.getFieldRef() + ") - 1 + " + offset, "rn");
        }
        sel.addGroupBy(mvtF);
        if (this.dateMin != null) {
            Where w = Where.createRaw(String.valueOf(funcCall) + " >= '" + this.dateMin.toString() + "'", new FieldRef[0]);
            if (offset == null) {
                w = w.not();
            }
            sel.setHaving(w);
        }
        return sel;
    }
}

