/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils.correct;

import java.sql.SQLException;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.sql.changer.convert.MergeRows;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.cc.ITransformer;

public class MergeClients
extends MergeRows {
    private static final Pattern punctAndSpacePattern = Pattern.compile("(\\p{Punct}|\\p{Space})+");
    private static final Pattern diacriticalPattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final Pattern spacePattern = Pattern.compile("\\p{Blank}+");

    private static String normalize(String s, boolean full) {
        if (s == null) {
            return null;
        }
        s = diacriticalPattern.matcher(Normalizer.normalize(s.trim(), Normalizer.Form.NFD)).replaceAll("");
        return punctAndSpacePattern.matcher(s).replaceAll(full ? "" : ".").toLowerCase();
    }

    private static String removeBlanks(String s) {
        return spacePattern.matcher(s).replaceAll(" ").trim();
    }

    public MergeClients(DBSystemRoot b) {
        super(b);
        this.setFieldsToCompare(Arrays.asList("SIRET"));
        if (!b.isMappingAllRoots()) {
            b.mapAllRoots();
            try {
                b.reload();
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    protected SQLRowValues createGraph(SQLTable t) {
        SQLRowValues res = super.createGraph(t);
        res.setAllToNull();
        res.putRowValues("ID_ADRESSE").putNulls("VILLE", "RUE");
        return res;
    }

    @Override
    protected SQLRowValuesListFetcher createFetcher(final SQLTable t) {
        SQLRowValuesListFetcher res = super.createFetcher(t);
        res.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                return input.andWhere(Where.createRaw("length(trim( both from " + t.getField("SIRET").getFieldRef() + ")) > 0", new FieldRef[0]));
            }
        });
        return res;
    }

    @Override
    protected Object normalize(String fieldName, Object o) {
        return MergeClients.normalize((String)o, fieldName.equals("SIRET"));
    }

    @Override
    protected boolean shouldMerge(SQLRowValues r1, SQLRowValues r2) {
        SQLRowAccessor addr2;
        boolean superRes;
        boolean bl = superRes = super.shouldMerge(r1, r2) && this.isEqualValue(r1, r2, "EXTRANET_LOGIN", false);
        if (!superRes) {
            return superRes;
        }
        if (this.isEqualNonEmptyValue(r1, r2, "TEL")) {
            return true;
        }
        SQLRowAccessor addr1 = r1.getForeign("ID_ADRESSE");
        return this.isEqualNonEmptyValue(addr1, addr2 = r2.getForeign("ID_ADRESSE"), "VILLE") && this.isEqualValue(addr1, addr2, "RUE", false);
    }

    @Override
    protected void mergeFields(SQLRowValues emptyUpdateRow, List<SQLRow> rows) {
        SQLRow dest = rows.get(0);
        SQLTable t = emptyUpdateRow.getTable();
        SQLField dontMerge = t.getField("CODE");
        Set<SQLField> fks = t.getForeignKeys();
        for (SQLField f : t.getContentFields()) {
            if (f.equals(dontMerge)) continue;
            String fname = f.getName();
            Object mergedValue = null;
            boolean toUpdate = false;
            if (String.class.isAssignableFrom(f.getType().getJavaType())) {
                HashMap<String, String> m = new HashMap<String, String>();
                for (SQLRow r : rows) {
                    String existing;
                    String normalized;
                    String val = r.getString(fname);
                    if (val == null || (normalized = (String)this.normalize(fname, val = MergeClients.removeBlanks(val))).length() <= 0 || (existing = (String)m.get(normalized)) != null && val.length() <= existing.length()) continue;
                    m.put(normalized, val);
                }
                mergedValue = CollectionUtils.join(m.values(), " ; ");
                toUpdate = !CompareUtils.equals(dest.getObject(fname), mergedValue);
            } else if (fks.contains(f)) {
                for (SQLRow r : rows) {
                    if (r.isForeignEmpty(fname)) continue;
                    mergedValue = r.getObject(fname);
                    toUpdate = r != dest;
                    break;
                }
            } else {
                for (SQLRow r : rows) {
                    Object fValue = r.getObject(fname);
                    if (fValue == null) continue;
                    mergedValue = fValue;
                    toUpdate = r != dest;
                    break;
                }
            }
            if (!toUpdate) continue;
            emptyUpdateRow.put(fname, mergedValue);
        }
    }
}

