/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.panel.compta.AbstractExport;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.StringUtils;

public class ExportToQuadraCompta
extends AbstractExport {
    private static final Charset CHARSET = StringUtils.Cp1252;
    private List<Object[]> data;

    protected ExportToQuadraCompta(DBRoot rootSociete) {
        super(rootSociete, "QuadraCompta", ".txt");
    }

    @Override
    protected int fetchData(Date from, Date to, SQLRow selectedJournal, boolean onlyNew) {
        List l;
        SQLTable tableEcriture = this.getEcritureT();
        SQLTable tableMouvement = tableEcriture.getForeignTable("ID_MOUVEMENT");
        SQLTable tableCompte = tableEcriture.getForeignTable("ID_COMPTE_PCE");
        SQLTable tableJrnl = tableEcriture.getForeignTable("ID_JOURNAL");
        SQLTable tablePiece = tableMouvement.getForeignTable("ID_PIECE");
        SQLSelect sel = this.createSelect(from, to, selectedJournal, onlyNew);
        sel.addSelect(tableCompte.getField("NUMERO"));
        sel.addSelect(tableJrnl.getField("CODE"));
        sel.addSelect(tableEcriture.getField("DATE"));
        sel.addSelect(tableEcriture.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DEBIT"));
        sel.addSelect(tableEcriture.getField("CREDIT"));
        sel.addSelect(tablePiece.getField("NOM"));
        this.data = l = (List)this.getRootSociete().getDBSystemRoot().getDataSource().execute(sel.asString(), new ArrayListHandler());
        return l == null ? 0 : l.size();
    }

    @Override
    protected void export(OutputStream out) throws IOException, ParseException {
        OutputStreamWriter bufOut = new OutputStreamWriter(out, CHARSET);
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyy");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (Object[] array : this.data) {
            bufOut.write("M");
            bufOut.write(this.matchStringToFixedLength(array[0], 8, '0', true, false));
            bufOut.write(this.matchStringToFixedLength(array[1], 2, ' '));
            bufOut.write("000");
            Date date1 = simpleDateFormat.parse(String.valueOf(array[2]).trim());
            bufOut.write(dateFormat.format(date1));
            bufOut.write(" ");
            bufOut.write(this.matchStringToFixedLength("", 20, ' '));
            long debit = ((Number)array[4]).longValue();
            long credit = ((Number)array[5]).longValue();
            bufOut.write(this.getDebitOrCredit(debit, credit));
            bufOut.write(this.getAmountSign(this.getAmount(debit, credit)));
            bufOut.write(this.matchStringToFixedLength(this.getAmount(debit, credit), 12, '0', false, false));
            bufOut.write(this.matchStringToFixedLength("", 44, ' '));
            bufOut.write(this.matchStringToFixedLength(array[6], 8, ' ', false, true));
            bufOut.write("EUR");
            bufOut.write(this.matchStringToFixedLength(array[1], 3, ' '));
            bufOut.write(this.matchStringToFixedLength(array[3], 30, ' ', false, false));
            bufOut.write(this.matchStringToFixedLength("", 12, ' '));
            bufOut.write("\r\n");
        }
        ((Writer)bufOut).flush();
    }

    private String matchStringToFixedLength(Object o, int length, char filler, boolean fillRight, boolean keepRight) {
        String str = String.valueOf(o).trim();
        if (str.length() >= length) {
            if (keepRight) {
                return str.substring(str.length() - length, str.length());
            }
            return str.substring(0, length);
        }
        String format = fillRight ? "%-" + length + "s" : "%" + length + "s";
        return String.format(format, str).replace(' ', filler);
    }

    private String matchStringToFixedLength(Object o, int length, char filler) {
        return this.matchStringToFixedLength(o, length, filler, true, true);
    }

    private String getDebitOrCredit(long debit, long credit) {
        if (debit > 0L && credit > 0L) {
            throw new IllegalStateException("Both credit and debit");
        }
        if (debit == 0L) {
            return "C";
        }
        return "D";
    }

    private String getAmountSign(long amount) {
        if (amount < 0L) {
            return "-";
        }
        return "+";
    }

    private long getAmount(long debit, long credit) {
        if (debit > 0L) {
            return debit;
        }
        return credit;
    }
}

