/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.panel.compta.AbstractExport;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.text.CSVWriter;

public class ExportEBP_OL
extends AbstractExport {
    private static final Charset CHARSET = StringUtils.Cp1252;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("##0.00000000", DecimalFormatSymbols.getInstance(Locale.FRANCE));
    private List<Object[]> data;

    private static String formatCents(Number n) {
        return DECIMAL_FORMAT.format(BigDecimal.valueOf(n.longValue()).movePointLeft(2));
    }

    public ExportEBP_OL(DBRoot rootSociete) {
        super(rootSociete, "EBPOL", ".txt");
    }

    @Override
    protected int fetchData(Date from, Date to, SQLRow selectedJournal, boolean onlyNew) {
        List l;
        SQLTable tableEcriture = this.getEcritureT();
        SQLTable tableMouvement = tableEcriture.getForeignTable("ID_MOUVEMENT");
        SQLTable tableCompte = tableEcriture.getForeignTable("ID_COMPTE_PCE");
        SQLTable tableJrnl = tableEcriture.getForeignTable("ID_JOURNAL");
        SQLSelect sel = this.createSelect(from, to, selectedJournal, onlyNew);
        sel.addSelect(tableJrnl.getField("CODE"));
        sel.addSelect(tableJrnl.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DATE"));
        sel.addSelect(tableCompte.getField("NUMERO"));
        sel.addSelect(tableCompte.getField("NOM"));
        sel.addSelect(tableMouvement.getField("NUMERO"));
        sel.addSelect(tableEcriture.getField("NOM"));
        sel.addSelect(tableEcriture.getField("DEBIT"));
        sel.addSelect(tableEcriture.getField("CREDIT"));
        sel.addFieldOrder(tableJrnl.getField("CODE"));
        sel.addFieldOrder(tableEcriture.getField("DATE"));
        sel.addFieldOrder(tableMouvement.getField("NUMERO"));
        this.data = l = (List)this.getRootSociete().getDBSystemRoot().getDataSource().execute(sel.asString(), new ArrayListHandler());
        return l == null ? 0 : l.size();
    }

    @Override
    protected void export(OutputStream out) throws IOException {
        OutputStreamWriter bufOut = new OutputStreamWriter(out, CHARSET);
        CSVWriter csvWriter = new CSVWriter(bufOut, ';', '\"', '\"', "\r\n");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        int fieldsCount = 8;
        ArrayList<String> line = new ArrayList<String>(8);
        String[] stringArray = new String[8];
        for (Object[] array : this.data) {
            line.clear();
            line.add((String)array[0]);
            line.add((String)array[1]);
            String ecritureDate = dateFormat.format(array[2]);
            line.add(ecritureDate);
            line.add((String)array[3]);
            line.add((String)array[4]);
            line.add(String.valueOf(array[5]));
            line.add((String)array[6]);
            long debit = ((Number)array[7]).longValue();
            long credit = ((Number)array[8]).longValue();
            if (debit > 0L && credit > 0L) {
                throw new IllegalStateException("Both credit and debit");
            }
            long cents = debit > 0L ? -debit : credit;
            line.add(ExportEBP_OL.formatCents(cents));
            assert (line.size() == 8 && stringArray.length == 8);
            csvWriter.writeNext(line.toArray(stringArray));
        }
        csvWriter.close();
    }
}

