/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import org.openconcerto.utils.GestionDevise;

public class PrixTTC {
    private double ttc;
    private long value;

    public PrixTTC(double ttc) {
        long pi = Math.round(100.0 * ttc);
        this.ttc = (double)pi / 100.0;
    }

    public PrixTTC(long value) {
        this.value = value;
    }

    public double calculHT(double taxe) {
        return (double)Math.round(this.ttc / (1.0 + taxe) * 100.0) / 100.0;
    }

    public double calculTVA(double taxe) {
        return (double)Math.round((this.ttc - this.calculHT(taxe)) * 100.0) / 100.0;
    }

    public double getValue() {
        return (double)Math.round(this.ttc * 100.0) / 100.0;
    }

    public long calculLongHT(double taxe) {
        return Math.round((double)this.value / (1.0 + taxe));
    }

    public long calculLongTVA(double taxe) {
        return this.value - this.calculLongHT(taxe);
    }

    public long getLongValue() {
        return this.value;
    }

    public String toString() {
        return GestionDevise.currencyToString(this.value);
    }
}

