/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.openconcerto.erp.core.sales.pos.io.ConcertProtocol;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.POSLabel;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class CBPanel
extends JPanel
implements ConcertProtocol.ConcertStateListener {
    private final JLabel connectionLabel = new JLabel("\u226b");
    private final JLabel sendLabel = new JLabel("\u226b");
    private final JLabel recvLabel = new JLabel("\u226b");
    private final JLabel finalDescLabel = new JLabel("", 0);
    private final POSButton bForce = new POSButton("For\u00e7age manuel");
    private final POSButton bDrawer = new POSButton("Ouverture tiroir caisse");
    private final POSButton bCancel = new POSButton("Annuler la demande de r\u00e9glement");

    public CBPanel(final CaisseFrame frame, final CaisseControler controller, final Paiement p) {
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        JPanel innerPanel = new JPanel();
        innerPanel.setBackground(Color.WHITE);
        innerPanel.setOpaque(true);
        JPanel actionPanel = new JPanel();
        actionPanel.setBackground(Color.WHITE);
        actionPanel.setOpaque(true);
        POSLabel title = new POSLabel("Terminal de paiement");
        title.setHorizontalAlignment(0);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 10, 10);
        this.add((Component)title, c);
        c.insets = new Insets(2, 10, 10, 10);
        ++c.gridy;
        this.add((Component)new JSeparator(0), c);
        c.insets = new Insets(10, 10, 10, 10);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)innerPanel, c);
        ++c.gridy;
        this.add((Component)actionPanel, c);
        this.connectionLabel.setFont(this.connectionLabel.getFont().deriveFont(1, 18.0f));
        this.connectionLabel.setForeground(Color.BLUE);
        this.sendLabel.setFont(this.sendLabel.getFont().deriveFont(1, 18.0f));
        this.sendLabel.setForeground(Color.BLUE);
        this.recvLabel.setFont(this.recvLabel.getFont().deriveFont(1, 18.0f));
        this.recvLabel.setForeground(Color.BLUE);
        this.finalDescLabel.setFont(this.getFont().deriveFont(24.0f));
        GridBagConstraints cg = new GridBagConstraints();
        cg.fill = 1;
        cg.insets = new Insets(10, 10, 10, 10);
        cg.weightx = 0.0;
        cg.weighty = 0.0;
        cg.gridx = 0;
        cg.gridy = 0;
        cg.gridwidth = 3;
        JPanel jp2 = new JPanel();
        jp2.setOpaque(false);
        jp2.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(), new EmptyBorder(20, 20, 20, 20)));
        jp2.setLayout(new GridBagLayout());
        jp2.setPreferredSize(new Dimension(500, 180));
        innerPanel.add((Component)jp2, cg);
        JLabel amountLabel = new JLabel("Montant : " + new BigDecimal(p.getMontantInCents()).movePointLeft(2).setScale(2));
        amountLabel.setHorizontalAlignment(0);
        amountLabel.setFont(this.connectionLabel.getFont().deriveFont(1, 18.0f));
        amountLabel.setForeground(Color.BLUE);
        c = new DefaultGridBagConstraints();
        Insets inset = c.insets;
        c.insets = new Insets(10, 10, 10, 10);
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        jp2.add((Component)amountLabel, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = inset;
        jp2.add((Component)this.connectionLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        jp2.add((Component)new JLabel("Connexion au terminal de paiement"), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        jp2.add((Component)this.sendLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        jp2.add((Component)new JLabel("Envoi des informations"), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        jp2.add((Component)this.recvLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        jp2.add((Component)new JLabel("Attente de r\u00e9ception des informations de paiement"), c);
        Insets insets = c.insets;
        c.insets = new Insets(20, 10, 10, 10);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        ++c.gridx;
        c.weightx = 1.0;
        jp2.add((Component)this.finalDescLabel, c);
        c.insets = insets;
        GridBagConstraints ca = new GridBagConstraints();
        ca.fill = 1;
        ca.insets = new Insets(0, 4, 4, 4);
        ca.weightx = 1.0;
        ca.weighty = 0.0;
        ca.gridx = 3;
        ca.gridy = 0;
        actionPanel.add((Component)this.bForce, ca);
        this.bForce.setVisible(false);
        ++ca.gridx;
        actionPanel.add((Component)this.bDrawer, ca);
        this.bDrawer.setVisible(false);
        ++ca.gridx;
        actionPanel.add((Component)this.bCancel, ca);
        this.bDrawer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.openDrawer();
                frame.showCaisse();
            }
        });
        this.bForce.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.openDrawer();
                frame.showCaisse();
            }
        });
        this.bCancel.setBackground(new Color(233, 56, 63));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(frame, "Veuillez annuler la demande de r\u00e9glement sur le TPE");
                frame.showCaisse();
            }
        });
        if (p.getMontantInCents() < 0) {
            this.stateChanged(ConcertProtocol.ConcertStateListener.States.NOK);
            return;
        }
        final String creditCardPort = controller.getPOSConf().getCreditCardPort();
        if (creditCardPort != null && creditCardPort.trim().length() > 2) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConcertProtocol cp = new ConcertProtocol(creditCardPort);
                        cp.addStateListener(CBPanel.this);
                        boolean ok = cp.sendCardPayment(p.getMontantInCents(), "978");
                        if (ok) {
                            controller.addPaiement(p);
                        }
                    }
                    catch (Throwable ex) {
                        CBPanel.this.stateChanged(ConcertProtocol.ConcertStateListener.States.ERROR);
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        } else {
            this.stateChanged(ConcertProtocol.ConcertStateListener.States.ERROR);
        }
    }

    @Override
    public void stateChanged(ConcertProtocol.ConcertStateListener.States state) {
        System.err.println("CBPanel.stateChanged(" + (Object)((Object)state) + ")");
        switch (state) {
            case ERROR: {
                this.connectionLabel.setText("\u0445");
                this.connectionLabel.setForeground(Color.RED.darker());
                this.sendLabel.setText("\u0445");
                this.sendLabel.setForeground(Color.RED.darker());
                this.recvLabel.setText("\u0445");
                this.recvLabel.setForeground(Color.RED.darker());
                this.finalDescLabel.setText("Erreur de communication");
                this.bForce.setVisible(true);
                break;
            }
            case CONNECTED: {
                this.connectionLabel.setText("\u221a");
                this.connectionLabel.setForeground(Color.GREEN.darker());
                this.bForce.setVisible(false);
                break;
            }
            case WAITING: {
                this.sendLabel.setText("\u221a");
                this.sendLabel.setForeground(Color.GREEN.darker());
                break;
            }
            case NOK: {
                this.recvLabel.setText("\u221a");
                this.recvLabel.setForeground(Color.GREEN.darker());
                this.finalDescLabel.setForeground(Color.RED.darker());
                this.finalDescLabel.setText("Paiement refus\u00e9");
                this.bForce.setVisible(false);
                this.bDrawer.setVisible(false);
                break;
            }
            case OK: {
                this.recvLabel.setText("\u221a");
                this.recvLabel.setForeground(Color.GREEN.darker());
                this.finalDescLabel.setForeground(Color.GREEN.darker());
                this.finalDescLabel.setText("Paiement accept\u00e9");
                this.bDrawer.setVisible(true);
                this.bCancel.setVisible(false);
                break;
            }
        }
    }
}

