/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import javax.swing.JOptionPane;
import org.openconcerto.erp.core.sales.pos.io.ESCSerialPrinter;

public class TestDirectPrint {
    public static void main(String[] args) {
        ESCSerialPrinter tot = new ESCSerialPrinter("COM");
        tot.addToBuffer("hello");
        TestDirectPrint.print(tot.getPrintBufferBytes());
    }

    private static boolean feedPrinter(byte[] b) {
        try {
            HashPrintServiceAttributeSet attrSet = new HashPrintServiceAttributeSet(new PrinterName("EPSON TM-T20 Receipt", null));
            DocPrintJob job = PrintServiceLookup.lookupPrintServices(null, attrSet)[0].createPrintJob();
            DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
            SimpleDoc doc = new SimpleDoc(b, flavor, null);
            job.print(doc, null);
            System.out.println("Done !");
        }
        catch (PrintException pex) {
            System.out.println("Printer Error " + pex.getMessage());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void print(byte[] bytes) {
        PrintService ps = PrintServiceLookup.lookupDefaultPrintService();
        try {
            PrinterJob pj1 = PrinterJob.getPrinterJob();
            if (pj1.printDialog()) {
                System.err.println("TestDirectPrint.print()" + pj1.getPrintService().getName());
                ps = pj1.getPrintService();
                DocFlavor[] p = ps.getSupportedDocFlavors();
                int i = 0;
                while (i < p.length) {
                    DocFlavor docFlavor = p[i];
                    System.out.println(docFlavor.toString());
                    ++i;
                }
                System.err.println("TestDirectPrint.print()");
                System.out.println(Arrays.toString(ps.getSupportedAttributeCategories()));
            }
            if (ps != null) {
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                DocPrintJob pj = ps.createPrintJob();
                try {
                    ByteArrayInputStream b = new ByteArrayInputStream(bytes);
                    SimpleDoc doc = new SimpleDoc(b, flavor, null);
                    pj.print(doc, aset);
                    JOptionPane.showMessageDialog(null, "end        printing");
                }
                catch (PrintException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, e.getMessage());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(null, e1.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(null, "no        Printer");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

