/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;

public abstract class DefaultTicketPrinter
implements TicketPrinter {
    private String docName = "unknown doc";
    protected List<String> strings = new ArrayList<String>();
    protected List<Integer> modes = new ArrayList<Integer>();

    @Override
    public void addToBuffer(String t) {
        this.addToBuffer(t, 0);
    }

    @Override
    public void addToBuffer(String t, int mode) {
        this.strings.add(t);
        this.modes.add(mode);
    }

    @Override
    public void clearBuffer(String docName) {
        this.docName = docName;
        this.strings.clear();
        this.modes.clear();
    }

    public final String getDocName() {
        return this.docName;
    }

    public static String formatLeft(int l, String string) {
        if (string.length() > l) {
            string = string.substring(0, l);
        }
        StringBuffer str = new StringBuffer(l);
        str.append(string);
        int stop = l - string.length();
        int i = 0;
        while (i < stop) {
            str.append(' ');
            ++i;
        }
        return str.toString();
    }

    public static String formatRight(int l, String string) {
        return DefaultTicketPrinter.format(l, string, false);
    }

    public static String formatCenter(int l, String string) {
        return DefaultTicketPrinter.format(l, string, true);
    }

    private static String format(int l, String string, boolean center) {
        if (string.length() > l) {
            return string.substring(0, l);
        }
        StringBuffer str = new StringBuffer(l);
        int stop = center ? (l - string.length()) / 2 : l - string.length();
        int i = 0;
        while (i < stop) {
            str.append(' ');
            ++i;
        }
        str.append(string);
        return str.toString();
    }

    public static String formatSides(int l, String s1, String s2) {
        if (s1.length() + s2.length() > l) {
            return String.valueOf(s1.substring(0, l / 2)) + s2.substring(0, l / 2);
        }
        int spaceCount = l - (s1.length() + s2.length());
        StringBuilder sb = new StringBuilder(l);
        sb.append(s1);
        int i = 0;
        while (i < spaceCount) {
            sb.append(' ');
            ++i;
        }
        sb.append(s2);
        return sb.toString();
    }

    @Override
    public void addToBuffer(TicketLine line) {
        String style = line.getStyle();
        int mode = style == null ? 0 : (style.equals("bold_large") ? 2 : (style.equals("bold") ? 1 : (style.equals("underline") ? 3 : 0)));
        this.addToBuffer(line.getText(), mode);
    }
}

