/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.finance.accounting.ui.ListPanelEcritures;
import org.openconcerto.erp.core.finance.accounting.ui.ListeDesEcrituresPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.State;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.state.WindowStateManager;

public class ConsultationCompteFrame
extends JFrame {
    private final ListPanelEcritures panelEcritures;
    private final ListeDesEcrituresPanel panel;
    private String titre;
    private int indexID;

    public ConsultationCompteFrame(ListeDesEcrituresPanel panel, SQLRowAccessor rowCpt) {
        this.panel = panel;
        this.panelEcritures = panel.getListPanelEcritures();
        this.titre = "Consultation compte n\u00b0" + rowCpt.getString("NUMERO") + " " + rowCpt.getString("NOM");
        this.panelEcritures.getListe().addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ConsultationCompteFrame.this.setTitle();
            }
        });
        this.uiInit();
        State.INSTANCE.frameCreated();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                State.INSTANCE.frameHidden();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                State.INSTANCE.frameShown();
            }
        });
        final SQLTable ecrTable = rowCpt.getTable().getTable("ECRITURE");
        int id = rowCpt.getID();
        Where w = new Where((FieldRef)ecrTable.getField("ID_COMPTE_PCE"), "=", id);
        this.getPanel().getListe().getRequest().setWhere(w);
        final SQLTable cptTable = ecrTable.getForeignTable("ID_COMPTE_PCE");
        ArrayList<SQLRow> rowsCpt = new ArrayList<SQLRow>(SQLBackgroundTableCache.getInstance().getCacheForTable(cptTable).getRows());
        Collections.sort(rowsCpt, new Comparator<SQLRow>(){

            @Override
            public int compare(SQLRow o1, SQLRow o2) {
                return o1.getString("NUMERO").compareTo(o2.getString("NUMERO"));
            }
        });
        final ArrayList<Integer> idsCpt = new ArrayList<Integer>();
        for (SQLRow sqlRow : rowsCpt) {
            idsCpt.add(sqlRow.getID());
        }
        this.indexID = idsCpt.indexOf(rowCpt.getID());
        RowAction.PredicateRowAction prec = new RowAction.PredicateRowAction((Action)new AbstractAction("Pr\u00e9c\u00e9dent"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConsultationCompteFrame.this.indexID > 0) {
                    int newCptId = (Integer)idsCpt.get(ConsultationCompteFrame.this.indexID - 1);
                    Where w = new Where((FieldRef)ecrTable.getField("ID_COMPTE_PCE"), "=", newCptId);
                    ConsultationCompteFrame.this.getPanel().getListe().getRequest().setWhere(w);
                    SQLRow rowCptNew = SQLBackgroundTableCache.getInstance().getCacheForTable(cptTable).getRowFromId(newCptId);
                    ConsultationCompteFrame.this.setTitle("Consultation compte n\u00b0" + rowCptNew.getString("NUMERO") + " " + rowCptNew.getString("NOM"));
                    ConsultationCompteFrame consultationCompteFrame = ConsultationCompteFrame.this;
                    consultationCompteFrame.indexID = consultationCompteFrame.indexID - 1;
                }
            }
        }, true, false);
        prec.setPredicate(IListeAction.IListeEvent.createSelectionCountPredicate(0, Integer.MAX_VALUE));
        panel.getListPanelEcritures().getListe().addIListeAction(prec);
        RowAction.PredicateRowAction suivant = new RowAction.PredicateRowAction((Action)new AbstractAction("Suivant"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConsultationCompteFrame.this.indexID < idsCpt.size() - 1) {
                    int newCptId = (Integer)idsCpt.get(ConsultationCompteFrame.this.indexID + 1);
                    Where w = new Where((FieldRef)ecrTable.getField("ID_COMPTE_PCE"), "=", newCptId);
                    ConsultationCompteFrame.this.getPanel().getListe().getRequest().setWhere(w);
                    SQLRow rowCptNew = SQLBackgroundTableCache.getInstance().getCacheForTable(cptTable).getRowFromId(newCptId);
                    ConsultationCompteFrame.this.setTitle("Consultation compte n\u00b0" + rowCptNew.getString("NUMERO") + " " + rowCptNew.getString("NOM"));
                    ConsultationCompteFrame consultationCompteFrame = ConsultationCompteFrame.this;
                    consultationCompteFrame.indexID = consultationCompteFrame.indexID + 1;
                }
            }
        }, true, false);
        suivant.setPredicate(IListeAction.IListeEvent.createSelectionCountPredicate(0, Integer.MAX_VALUE));
        panel.getListPanelEcritures().getListe().addIListeAction(suivant);
    }

    @Override
    public void setTitle(String title) {
        this.titre = title;
        super.setTitle(title);
    }

    private String getPlural(String s, int nb) {
        return String.valueOf(nb) + " " + s + (nb > 1 ? "s" : "");
    }

    private void setTitle(boolean displayRowCount, boolean displayItemCount) {
        int count;
        String title = this.titre;
        if (displayRowCount) {
            int rowCount = this.panelEcritures.getListe().getRowCount();
            title = String.valueOf(title) + ", " + this.getPlural("ligne", rowCount);
            int total = this.panelEcritures.getListe().getTotalRowCount();
            if (total != rowCount) {
                title = String.valueOf(title) + " / " + total;
            }
        }
        if (displayItemCount && (count = this.panelEcritures.getListe().getItemCount()) >= 0) {
            title = String.valueOf(title) + ", " + this.getPlural("\u00e9l\u00e9ment", count);
        }
        this.setTitle(title);
    }

    public void setTitle() {
        this.setTitle(true, true);
    }

    private final void uiInit() {
        this.setTitle();
        this.getContentPane().setLayout(new GridLayout());
        this.getContentPane().add(this.panel);
        this.setBounds();
        File configFile = new File(Configuration.getInstance().getConfDir(), String.valueOf(this.panelEcritures.getElement().getPluralName()) + "-window.xml");
        new WindowStateManager(this, configFile).loadState();
    }

    protected final void setBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode dm = ge.getDefaultScreenDevice().getDisplayMode();
        int topOffset = 50;
        if (dm.getWidth() <= 800 || dm.getHeight() <= 600) {
            this.setLocation(0, 50);
            this.setSize(dm.getWidth(), dm.getHeight() - 50);
        } else {
            this.setLocation(10, 50);
            this.setSize(dm.getWidth() - 50, dm.getHeight() - 20 - 50);
        }
    }

    public final ListPanelEcritures getPanel() {
        return this.panelEcritures;
    }
}

